/*
 * Decompiled with CFR 0.152.
 */
package io.github.timtaran.deote.platform;

import io.github.timtaran.deote.DisableElytraOutsideTheEnd;
import io.github.timtaran.deote.GlobalStorage;
import io.github.timtaran.deote.config.DeoteConfig;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="deote", dist={Dist.CLIENT})
@EventBusSubscriber(modid="deote", value={Dist.CLIENT})
public class PlatformClientEntrypoint {
    public PlatformClientEntrypoint() {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parentScreen) -> DeoteConfig.getInstance().getConfigScreen(parentScreen));
    }

    @SubscribeEvent
    public static void onClientConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        if (!Minecraft.getInstance().hasSingleplayerServer()) {
            DisableElytraOutsideTheEnd.LOGGER.info(event.getMultiPlayerGameMode().toString());
            if (!GlobalStorage.isGotSyncPacket) {
                GlobalStorage.setNullConfig();
            }
            GlobalStorage.isConnectedToServer = true;
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        DeoteConfig.updateStorage();
        GlobalStorage.isGotSyncPacket = false;
        GlobalStorage.isConnectedToServer = false;
    }
}

