/*
 * Decompiled with CFR 0.152.
 */
package io.github.timtaran.deote.config;

import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import io.github.timtaran.deote.GlobalStorage;
import io.github.timtaran.deote.config.WorkingMode;
import io.github.timtaran.deote.util.DeoteIdentifier;
import io.github.timtaran.deote.util.TextUtils;
import java.nio.file.Path;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;

public class DeoteConfig {
    public static ConfigClassHandler<DeoteConfig> HANDLER = ConfigClassHandler.createBuilder(DeoteConfig.class).id(DeoteIdentifier.get("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(DeoteConfig.getConfigDirectory().resolve("deote.json")).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setJson5(false).build()).build();
    private static final WorkingMode DEFAULT_WORKING_MODE = WorkingMode.FLYING;
    private static final boolean DEFAULT_WARNING_MESSAGE_ENABLED = true;
    private static final String DEFAULT_FLIGHT_DISABLED_MESSAGE = "\u00a7cThe atmosphere here is too dense to allow the wings to open";
    private static final String DEFAULT_FIREWORKS_DISABLED_MESSAGE = "\u00a7cIt's hard to light a fuse in flight";
    @SerialEntry
    public WorkingMode workingMode = DEFAULT_WORKING_MODE;
    @SerialEntry
    public boolean warningMessageEnabled = true;
    @SerialEntry
    public String flightDisabledMessage = "\u00a7cThe atmosphere here is too dense to allow the wings to open";
    @SerialEntry
    public String fireworksDisabledMessage = "\u00a7cIt's hard to light a fuse in flight";

    public DeoteConfig(WorkingMode workingMode, boolean warningMessageEnabled, String flightDisabledMessage, String fireworksDisabledMessage) {
        this.workingMode = workingMode;
        this.warningMessageEnabled = warningMessageEnabled;
        this.flightDisabledMessage = flightDisabledMessage;
        this.fireworksDisabledMessage = fireworksDisabledMessage;
    }

    public DeoteConfig() {
    }

    private static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public Screen getConfigScreen(Screen parentScreen) {
        return YetAnotherConfigLib.createBuilder().title((Component)Component.literal((String)"Disable Elytra Outside The End")).category(ConfigCategory.createBuilder().name(TextUtils.translatable("config.categories.main")).group(OptionGroup.createBuilder().name(TextUtils.translatable("config.groups.main")).option(Option.createBuilder().name(TextUtils.translatable("config.groups.main.working_mode")).description(OptionDescription.of((Component[])new Component[]{TextUtils.translatable("config.groups.main.working_mode.description")})).binding((Object)DEFAULT_WORKING_MODE, () -> this.workingMode != null ? this.workingMode : DEFAULT_WORKING_MODE, newVal -> {
            this.workingMode = newVal;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(WorkingMode.class)).build()).option(Option.createBuilder().name(TextUtils.translatable("config.groups.main.warning_message")).description(OptionDescription.of((Component[])new Component[]{TextUtils.translatable("config.groups.main.warning_message.description")})).binding((Object)true, () -> this.warningMessageEnabled, newVal -> {
            this.warningMessageEnabled = newVal;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name(TextUtils.translatable("config.groups.main.flight_disabled_message")).binding((Object)DEFAULT_FLIGHT_DISABLED_MESSAGE, () -> this.flightDisabledMessage, newVal -> {
            this.flightDisabledMessage = newVal;
        }).controller(StringControllerBuilder::create).build()).option(Option.createBuilder().name(TextUtils.translatable("config.groups.main.fireworks_disabled_message")).binding((Object)DEFAULT_FIREWORKS_DISABLED_MESSAGE, () -> this.fireworksDisabledMessage, newVal -> {
            this.fireworksDisabledMessage = newVal;
        }).controller(StringControllerBuilder::create).build()).build()).build()).save(DeoteConfig::save).build().generateScreen(parentScreen);
    }

    public static DeoteConfig getInstance() {
        return (DeoteConfig)HANDLER.instance();
    }

    public static void save() {
        HANDLER.save();
        DeoteConfig.updateStorage();
    }

    public static void load() {
        HANDLER.load();
        DeoteConfig.updateStorage();
    }

    public static void updateStorage() {
        if (!GlobalStorage.isConnectedToServer) {
            GlobalStorage.deoteConfig = DeoteConfig.getInstance();
        }
    }
}

