/*
 * Decompiled with CFR 0.152.
 */
package io.github.timtaran.deote.mixin;

import io.github.timtaran.deote.GlobalStorage;
import io.github.timtaran.deote.config.WorkingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PreventClientFlyingMixin {
    @Shadow
    protected abstract boolean canGlide();

    @Inject(method={"tryToStartFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryToStartFallFlying(CallbackInfoReturnable<Boolean> callbackInfo) {
        Player self = (Player)this;
        if (GlobalStorage.deoteConfig.workingMode == WorkingMode.FLYING && this.canFallFlying(self) && self.level().dimension() != Level.END) {
            if (GlobalStorage.deoteConfig.warningMessageEnabled) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)GlobalStorage.deoteConfig.flightDisabledMessage), false);
            }
            callbackInfo.setReturnValue((Object)false);
            callbackInfo.cancel();
        }
    }

    @Unique
    private boolean canFallFlying(Player self) {
        return !self.isFallFlying() && this.canGlide() && !self.isInWater();
    }
}

