/*
 * Decompiled with CFR 0.152.
 */
package io.github.timtaran.deote.mixin;

import io.github.timtaran.deote.DisableElytraOutsideTheEnd;
import io.github.timtaran.deote.GlobalStorage;
import io.github.timtaran.deote.config.WorkingMode;
import java.lang.reflect.Method;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class PreventServerFlyingMixin {
    @Inject(method={"updateFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateFallFlying(CallbackInfo callbackInfo) {
        if (GlobalStorage.deoteConfig.workingMode == WorkingMode.FLYING) {
            LivingEntity self = (LivingEntity)this;
            try {
                if (self.level().dimension() != Level.END) {
                    ServerPlayer player;
                    if (GlobalStorage.deoteConfig.warningMessageEnabled && self instanceof ServerPlayer && (player = (ServerPlayer)self).isFallFlying() && !self.level().isClientSide()) {
                        player.displayClientMessage((Component)Component.literal((String)GlobalStorage.deoteConfig.flightDisabledMessage), true);
                    }
                    Method m = Entity.class.getDeclaredMethod("setSharedFlag", Integer.TYPE, Boolean.TYPE);
                    m.setAccessible(true);
                    m.invoke((Object)self, 7, false);
                    callbackInfo.cancel();
                }
            }
            catch (Exception exception) {
                DisableElytraOutsideTheEnd.LOGGER.error(exception.getMessage());
            }
        }
    }
}

