/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class ShockwaveParticleOption
implements ParticleOptions {
    public static final Codec<ShockwaveParticleOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue)), (App)Codec.FLOAT.fieldOf("originSize").forGetter(d -> Float.valueOf(d.originSize)), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.INT.fieldOf("speed").forGetter(d -> d.speed), (App)Codec.INT.fieldOf("life").forGetter(d -> d.speed), (App)Codec.BOOL.fieldOf("fade").forGetter(d -> d.fade)).apply((Applicative)instance, ShockwaveParticleOption::new));
    public static final ParticleOptions.Deserializer<ShockwaveParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<ShockwaveParticleOption>(){

        public ShockwaveParticleOption fromCommand(ParticleType<ShockwaveParticleOption> p_235961_, StringReader p_235962_) throws CommandSyntaxException {
            p_235962_.expect(' ');
            float r = p_235962_.readFloat();
            p_235962_.expect(' ');
            float g = p_235962_.readFloat();
            p_235962_.expect(' ');
            float b = p_235962_.readFloat();
            p_235962_.expect(' ');
            float s0 = p_235962_.readFloat();
            p_235962_.expect(' ');
            float s = p_235962_.readFloat();
            p_235962_.expect(' ');
            int s2 = p_235962_.readInt();
            p_235962_.expect(' ');
            int s3 = p_235962_.readInt();
            p_235962_.expect(' ');
            boolean f = p_235962_.readBoolean();
            return new ShockwaveParticleOption(r, g, b, s0, s, s2, s3, f);
        }

        public ShockwaveParticleOption fromNetwork(ParticleType<ShockwaveParticleOption> p_235964_, FriendlyByteBuf p_235965_) {
            return new ShockwaveParticleOption(p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readInt(), p_235965_.readInt(), p_235965_.readBoolean());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float originSize;
    private final float size;
    private final int speed;
    private final int life;
    private final boolean fade;

    public ShockwaveParticleOption() {
        this.red = 1.0f;
        this.green = 1.0f;
        this.blue = 1.0f;
        this.originSize = 20.0f;
        this.size = 10.0f;
        this.speed = 0;
        this.life = 30;
        this.fade = true;
    }

    public ShockwaveParticleOption(float size, int speed) {
        this.red = 1.0f;
        this.green = 1.0f;
        this.blue = 1.0f;
        this.originSize = size * 2.0f;
        this.size = size;
        this.speed = speed;
        this.life = 30;
        this.fade = true;
    }

    public ShockwaveParticleOption(float originSize, float size, int speed) {
        this.red = 1.0f;
        this.green = 1.0f;
        this.blue = 1.0f;
        this.originSize = originSize;
        this.size = size;
        this.speed = speed;
        this.life = 30;
        this.fade = true;
    }

    public ShockwaveParticleOption(ColorUtil colorUtil) {
        this.red = colorUtil.red;
        this.green = colorUtil.green;
        this.blue = colorUtil.blue;
        this.originSize = 20.0f;
        this.size = 10.0f;
        this.speed = 0;
        this.life = 30;
        this.fade = true;
    }

    public ShockwaveParticleOption(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.originSize = 20.0f;
        this.size = 10.0f;
        this.speed = 0;
        this.life = 30;
        this.fade = true;
    }

    public ShockwaveParticleOption(float r, float g, float b, float size, int speed, boolean fade) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.originSize = size * 2.0f;
        this.size = size;
        this.speed = speed;
        this.life = 30;
        this.fade = fade;
    }

    public ShockwaveParticleOption(float r, float g, float b, float originSize, float size, int speed, boolean fade) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.originSize = originSize;
        this.size = size;
        this.speed = speed;
        this.life = 30;
        this.fade = fade;
    }

    public ShockwaveParticleOption(float r, float g, float b, float originSize, float size, int speed, int life, boolean fade) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.originSize = originSize;
        this.size = size;
        this.speed = speed;
        this.life = life;
        this.fade = fade;
    }

    public void m_7711_(FriendlyByteBuf p_235956_) {
        p_235956_.writeFloat(this.red);
        p_235956_.writeFloat(this.green);
        p_235956_.writeFloat(this.blue);
        p_235956_.writeFloat(this.originSize);
        p_235956_.writeFloat(this.size);
        p_235956_.writeInt(this.speed);
        p_235956_.writeInt(this.life);
        p_235956_.writeBoolean(this.fade);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s %s %s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.originSize), Float.valueOf(this.size), this.speed, this.life, this.fade);
    }

    public ParticleType<ShockwaveParticleOption> m_6012_() {
        return (ParticleType)ModParticleTypes.SHOCKWAVE.get();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getOriginSize() {
        return this.originSize;
    }

    public float getSize() {
        return this.size;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getLife() {
        return this.life;
    }

    public boolean isFade() {
        return this.fade;
    }
}

