/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.DrownedNecromancerAnimations;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.DrownedNecromancer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DrownedNecromancerModel<T extends DrownedNecromancer>
extends HierarchicalModel<T> {
    public final ModelPart root;
    private final ModelPart skeleton;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart torso;
    private final ModelPart cape;
    private final ModelPart right_arm;
    private final ModelPart staff;
    private final ModelPart handle;
    private final ModelPart group;
    private final ModelPart staffhead;
    private final ModelPart right_pauldron;
    private final ModelPart left_arm;
    private final ModelPart left_pauldron;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public DrownedNecromancerModel(ModelPart root) {
        this.root = root;
        this.skeleton = root.m_171324_("skeleton");
        this.body = this.skeleton.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.torso = this.body.m_171324_("torso");
        this.cape = this.torso.m_171324_("cape");
        this.right_arm = this.body.m_171324_("right_arm");
        this.staff = this.right_arm.m_171324_("staff");
        this.handle = this.staff.m_171324_("handle");
        this.group = this.staff.m_171324_("group");
        this.staffhead = this.staff.m_171324_("staffhead");
        this.right_pauldron = this.right_arm.m_171324_("right_pauldron");
        this.left_arm = this.body.m_171324_("left_arm");
        this.left_pauldron = this.left_arm.m_171324_("left_pauldron");
        this.right_leg = this.skeleton.m_171324_("right_leg");
        this.left_leg = this.skeleton.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition skeleton = partdefinition.m_171599_("skeleton", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = skeleton.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(28, 93).m_171488_(-6.0f, -5.75f, -4.0f, 10.0f, 5.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)1.0f, (float)-4.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 32).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition cape = torso.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(24, 64).m_171488_(-8.0f, 0.0f, -2.0f, 16.0f, 24.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)1.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 70).m_171488_(-2.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)-5.0f, (float)-10.0f, (float)0.0f, (float)-1.3963f, (float)0.2618f, (float)0.0f));
        PartDefinition staff = right_arm.m_171599_("staff", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)5.5f, (float)1.4399f, (float)0.0f, (float)0.0f));
        PartDefinition handle = staff.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(60, 39).m_171488_(0.5f, -20.0f, -19.0f, 1.0f, 28.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition group = staff.m_171599_("group", CubeListBuilder.m_171558_().m_171514_(56, 48).m_171480_().m_171488_(2.5f, -22.0f, -19.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(56, 48).m_171488_(-1.5f, -22.0f, -19.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 56).m_171488_(-2.5f, -26.0f, -19.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 56).m_171488_(3.5f, -26.0f, -19.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 56).m_171488_(0.5f, -28.0f, -19.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition staffhead = staff.m_171599_("staffhead", CubeListBuilder.m_171558_().m_171514_(48, 50).m_171488_(-0.5f, -23.0f, -20.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition right_pauldron = right_arm.m_171599_("right_pauldron", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -4.0f, -3.5f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0472f, (float)-0.0873f, (float)-0.2618f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 86).m_171480_().m_171488_(-1.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition left_pauldron = left_arm.m_171599_("left_pauldron", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171480_().m_171488_(-1.0f, -4.0f, -3.5f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition right_leg = skeleton.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 112).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)-2.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition left_leg = skeleton.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 112).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            if (((DrownedNecromancer)entity).cantDo > 0) {
                this.head.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
                this.head.f_104203_ = 0.4f;
            } else {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
            }
        }
        if (entity.m_20072_()) {
            this.m_233381_(((DrownedNecromancer)entity).idleAnimationState, DrownedNecromancerAnimations.IDLE_SWIM, ageInTicks);
        } else {
            this.m_233381_(((DrownedNecromancer)entity).idleAnimationState, DrownedNecromancerAnimations.IDLE, ageInTicks);
        }
        if (this.f_102609_) {
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = 0.31415927f;
            this.right_leg.f_104205_ = 0.07853982f;
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = -0.31415927f;
            this.left_leg.f_104205_ = -0.07853982f;
        } else if (entity.m_20072_()) {
            this.m_267799_(DrownedNecromancerAnimations.SWIM, limbSwing, limbSwingAmount, 2.5f, 20.0f);
        } else {
            this.m_267799_(DrownedNecromancerAnimations.WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
        }
        this.m_233385_(((DrownedNecromancer)entity).attackAnimationState, DrownedNecromancerAnimations.SHOOT, ageInTicks, ((AbstractNecromancer)entity).getAttackSpeed());
        this.m_233381_(((DrownedNecromancer)entity).summonAnimationState, DrownedNecromancerAnimations.SUMMON, ageInTicks);
        this.m_233381_(((DrownedNecromancer)entity).spellAnimationState, DrownedNecromancerAnimations.SPELL, ageInTicks);
        this.m_233381_(((DrownedNecromancer)entity).stormAnimationState, DrownedNecromancerAnimations.STORM, ageInTicks);
        this.m_233381_(((DrownedNecromancer)entity).rapidAnimationState, DrownedNecromancerAnimations.RAPID, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

