/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.common.entities.hostile.servants.Malghast;
import com.Polarice3.Goety.common.entities.neutral.SummonedFlying;
import com.Polarice3.Goety.common.entities.projectiles.ModFireball;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MiniGhast
extends Malghast {
    public MiniGhast(EntityType<? extends Malghast> type, Level worldIn) {
        super((EntityType<? extends SummonedFlying>)type, worldIn);
    }

    @Override
    public void addFlyingGoal() {
        this.f_21345_.m_25352_(5, (Goal)new FlyingGoal(this));
    }

    @Override
    public void addFireballGoal() {
        this.f_21345_.m_25352_(7, (Goal)new FireballAttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.MiniGhastHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.MiniGhastHealth.get());
    }

    @Override
    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.8f;
    }

    @Override
    protected float m_6121_() {
        return 1.0f;
    }

    @Override
    public float m_6100_() {
        return 1.5f;
    }

    @Override
    public void setGhastSpawn() {
        if (this.getTrueOwner() == null) {
            this.setBoundPos(this.m_20183_());
            this.setWandering(false);
            this.setStaying(false);
        }
    }

    static class FlyingGoal
    extends Goal {
        private final MiniGhast ghast;

        public FlyingGoal(MiniGhast p_i45836_1_) {
            this.ghast = p_i45836_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.ghast.m_21566_();
            if (this.ghast.isCommanded() || this.ghast.isStaying()) {
                return false;
            }
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.ghast.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.ghast.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.ghast.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.ghast.m_217043_();
            float distance = 8.0f;
            BlockPos blockPos = null;
            if (this.ghast.getBoundPos() != null) {
                blockPos = this.ghast.getBoundPos();
            } else if (this.ghast.getTrueOwner() != null && this.ghast.isFollowing()) {
                blockPos = this.ghast.getTrueOwner().m_20183_().m_6630_(4);
            } else if (this.ghast.m_5448_() != null) {
                blockPos = this.ghast.m_5448_().m_20183_().m_6630_(4);
            }
            if (blockPos != null) {
                if (this.ghast.m_20238_(Vec3.m_82512_((Vec3i)blockPos)) < (double)Mth.m_14207_((float)distance)) {
                    Vec3 vector3d = Vec3.m_82512_((Vec3i)blockPos);
                    double X = this.ghast.m_20185_() + vector3d.f_82479_ * (double)distance + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                    double Y = this.ghast.m_20186_() + vector3d.f_82480_ * (double)distance + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                    double Z = this.ghast.m_20189_() + vector3d.f_82481_ * (double)distance + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                    this.ghast.m_21566_().m_6849_(X, Y, Z, 0.25);
                } else {
                    this.ghast.m_21566_().m_6849_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.25);
                }
            } else {
                double d0 = this.ghast.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                double d1 = this.ghast.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                double d2 = this.ghast.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                this.ghast.m_21566_().m_6849_(d0, d1, d2, 0.25);
            }
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final MiniGhast ghast;
        public int chargeTime;
        public boolean shotTimes;

        public FireballAttackGoal(MiniGhast p_i45837_1_) {
            this.ghast = p_i45837_1_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
            this.shotTimes = true;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            float d0 = 64.0f;
            if (livingentity != null && livingentity.m_20280_((Entity)this.ghast) < (double)Mth.m_14207_((float)d0) && this.ghast.m_142582_((Entity)livingentity)) {
                Level world = this.ghast.f_19853_;
                ++this.chargeTime;
                if (this.chargeTime == 10) {
                    boolean bl = this.shotTimes = this.ghast.f_19796_.m_188501_() >= 0.25f;
                    if (!this.ghast.m_20067_()) {
                        this.ghast.m_5496_(SoundEvents.f_11924_, 2.0f, (this.ghast.f_19796_.m_188501_() - this.ghast.f_19796_.m_188501_()) * 0.2f + this.ghast.m_6100_());
                    }
                }
                if (this.chargeTime == 20) {
                    double d1 = 2.0;
                    Vec3 vector3d = this.ghast.m_20252_(1.0f);
                    double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vector3d.f_82479_ * d1);
                    double d3 = livingentity.m_20227_(0.5) - this.ghast.m_20227_(0.5);
                    double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vector3d.f_82481_ * d1);
                    if (!this.ghast.m_20067_()) {
                        this.ghast.m_5496_(SoundEvents.f_11923_, 2.0f, (this.ghast.f_19796_.m_188501_() - this.ghast.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    }
                    ModFireball fireball = new ModFireball(world, (LivingEntity)this.ghast, d2, d3, d4);
                    double y = this.ghast.m_20186_() <= livingentity.m_20188_() ? this.ghast.m_20227_(0.5) : this.ghast.m_20186_();
                    fireball.setDangerous(false);
                    fireball.setDamage(((Double)AttributesConfig.MiniGhastDamage.get()).floatValue() + this.ghast.getFireBallDamage());
                    fireball.m_6034_(this.ghast.m_20185_() + vector3d.f_82479_ * d1, y, fireball.m_20189_() + vector3d.f_82481_ * d1);
                    world.m_7967_((Entity)fireball);
                    this.chargeTime = 0;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.ghast.setCharging(this.chargeTime > 10);
        }
    }
}

