/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.client.particles.ModShriekParticleOption;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class SignalerServant
extends AbstractIllagerServant {
    public int hornUse;
    public int changeTick;
    public List<LivingEntity> hordeSaved = new ArrayList<LivingEntity>();

    public SignalerServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.PillagerServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.PillagerServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.PillagerServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public AbstractIllagerServant.IllagerServantArmPose getArmPose() {
        if (this.isCelebrating()) {
            return AbstractIllagerServant.IllagerServantArmPose.CELEBRATING;
        }
        return AbstractIllagerServant.IllagerServantArmPose.NEUTRAL;
    }

    public double m_21133_(Attribute attribute) {
        double original = super.m_21133_(attribute);
        if (attribute == Attributes.f_22277_) {
            double heightMap;
            if (this.m_21051_(Attributes.f_22277_) == null) {
                original = 32.0;
            }
            if (this.m_6117_() && this.m_21211_().m_150930_(Items.f_151059_)) {
                original *= 2.0;
            }
            if (original > (heightMap = (double)this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_()).m_123342_())) {
                double diff = original - heightMap;
                original += diff;
            }
        }
        return original;
    }

    public ItemStack m_21211_() {
        if ((this.m_21205_().m_150930_(Items.f_151059_) || this.m_21205_().m_150930_(Items.f_220219_)) && !this.isCelebrating()) {
            return this.m_21205_();
        }
        return super.m_21211_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.isCelebrating()) {
                this.m_5810_();
            } else {
                if (this.hornUse > 0) {
                    --this.hornUse;
                    if (!this.m_21205_().m_150930_(Items.f_220219_)) {
                        this.swapItemHand();
                        this.changeTick = 5;
                    }
                } else if (!this.m_21205_().m_150930_(Items.f_151059_)) {
                    this.swapItemHand();
                    this.changeTick = 5;
                }
                if (this.changeTick > 0) {
                    --this.changeTick;
                }
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected SoundEvent m_7975_(DamageSource p_33306_) {
        return SoundEvents.f_12310_;
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_12308_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData data = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.populateDefaultWeapons(pLevel.m_213780_(), pDifficulty);
        return data;
    }

    @Override
    public void populateDefaultWeapons(RandomSource randomSource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_151059_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_220219_));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    @Override
    public void m_6710_(@Nullable LivingEntity target) {
        if (target != null && this.hornUse <= 0) {
            List<LivingEntity> list = this.hordeOfTargets(target);
            if (this.m_5448_() == null && (this.hordeSaved.isEmpty() || !this.hordeSaved.contains(target)) && (target instanceof Player || target.m_21233_() > this.m_21233_() * 2.0f || this.quantityOfTargets(target) >= 15)) {
                Mob ally2;
                list.sort(Comparator.comparingDouble(living -> living.m_20270_((Entity)this)));
                for (Mob ally2 : this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_)), mob -> {
                    IServant servant;
                    return mob instanceof IServant && (servant = (IServant)mob).isGuardingArea() && servant.getMasterOwner() == this.getMasterOwner() && mob != this;
                })) {
                    if (ally2 instanceof IServant) {
                        RaiderServant raiderServant;
                        IServant servant = (IServant)ally2;
                        servant.setPriorityTarget(target);
                        if (!list.isEmpty() && servant instanceof RaiderServant && (raiderServant = (RaiderServant)servant).isLeader()) {
                            List<RaiderServant> raiders = raiderServant.getNearbyCompanions();
                            int maxSize = Math.min(list.size(), raiders.size());
                            for (int i = 0; i < maxSize; ++i) {
                                try {
                                    RaiderServant follower = raiders.get(i);
                                    LivingEntity target1 = list.get(i);
                                    if (target1 == null) continue;
                                    follower.setPriorityTarget(target1);
                                    continue;
                                }
                                catch (IndexOutOfBoundsException ignored) {
                                    break;
                                }
                            }
                        }
                    }
                    if (!(ally2 instanceof SignalerServant)) continue;
                    ally2.m_6710_(target);
                }
                this.setPriorityTarget(target);
                MobUtil.instaLook((Mob)this, (Entity)target);
                ally2 = this.f_19853_;
                if (ally2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)ally2;
                    for (int j1 = 0; j1 < 5; ++j1) {
                        serverLevel.m_8767_((ParticleOptions)new ModShriekParticleOption(j1 * 5), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 0, 1.0, 1.0, 1.0, 1.0);
                    }
                }
                if (!list.isEmpty()) {
                    this.hordeSaved = list;
                }
                this.m_5496_((SoundEvent)ModSounds.INTRUDER_ALERT.get(), (float)(this.m_21133_(Attributes.f_22277_) / 2.0), this.m_6100_());
                this.hornUse = 60;
            }
        }
    }

    public int quantityOfTargets(LivingEntity mainTarget) {
        int size = 0;
        if (!this.hordeOfTargets(mainTarget).isEmpty()) {
            for (LivingEntity livingEntity : this.hordeOfTargets(mainTarget)) {
                OwnableEntity ownable;
                if (livingEntity.m_21233_() >= this.m_21233_()) {
                    size += 3;
                    continue;
                }
                if (livingEntity instanceof OwnableEntity && (ownable = (OwnableEntity)livingEntity).m_269323_() instanceof Player && MobUtil.isOwnedTargetable((Entity)this, ownable.m_269323_())) {
                    size += 3;
                    continue;
                }
                ++size;
            }
        }
        return size;
    }

    public List<LivingEntity> hordeOfTargets(LivingEntity mainTarget) {
        return this.f_19853_.m_6443_(LivingEntity.class, mainTarget.m_20191_().m_82400_(16.0), MobUtil.ownedPredicate((Entity)this));
    }

    public void swapItemHand() {
        ItemStack toOffHand = this.m_21205_();
        ItemStack toMainHand = this.m_21206_();
        this.m_21008_(InteractionHand.OFF_HAND, toOffHand);
        this.m_21008_(InteractionHand.MAIN_HAND, toMainHand);
        this.m_5810_();
    }
}

