/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class ModFireball
extends SmallFireball {
    public static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(ModFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(ModFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(ModFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> DATA_FIERY = SynchedEntityData.m_135353_(ModFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModFireball(EntityType<? extends ModFireball> p_i50160_1_, Level p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public ModFireball(Level p_i1771_1_, LivingEntity p_i1771_2_, double p_i1771_3_, double p_i1771_5_, double p_i1771_7_) {
        super(p_i1771_1_, p_i1771_2_, p_i1771_3_, p_i1771_5_, p_i1771_7_);
    }

    public ModFireball(Level pWorld, double pX, double pY, double pZ, double pAccelX, double pAccelY, double pAccelZ) {
        super(pWorld, pX, pY, pZ, pAccelX, pAccelY, pAccelZ);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntityType.MOD_FIREBALL.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)true);
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIERY, (Object)0);
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Damage", this.getDamage());
        pCompound.m_128350_("ExtraDamage", this.getExtraDamage());
        pCompound.m_128405_("Fiery", this.getFiery());
        pCompound.m_128379_("Dangerous", this.isDangerous());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Damage", 99)) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
        if (pCompound.m_128425_("ExtraDamage", 99)) {
            this.setExtraDamage(pCompound.m_128457_("ExtraDamage"));
        }
        if (pCompound.m_128441_("Fiery")) {
            this.setFiery(pCompound.m_128451_("Fiery"));
        }
        if (pCompound.m_128441_("Dangerous")) {
            this.setDangerous(pCompound.m_128471_("Dangerous"));
        }
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pDangerous) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pDangerous);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float extra) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(extra));
    }

    public int getFiery() {
        return (Integer)this.f_19804_.m_135370_(DATA_FIERY);
    }

    public void setFiery(int fiery) {
        this.f_19804_.m_135381_(DATA_FIERY, (Object)fiery);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            float enchantment = this.getExtraDamage();
            float damage = 5.0f;
            int flaming = 1 + this.getFiery();
            if (entity1 instanceof Player) {
                damage = ((Double)SpellConfig.FireballDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            } else if (entity1 instanceof LivingEntity) {
                damage = this.getDamage();
            }
            int i = entity.m_20094_() + (flaming - 1);
            entity.m_20254_(5 * flaming);
            DamageSource damageSource = entity.m_269291_().m_269453_((Fireball)this, entity1);
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity1;
                if (CuriosFinder.hasNetherRobe(livingEntity)) {
                    damageSource = ModDamageSource.magicFireball((Fireball)this, entity1, this.f_19853_);
                }
                if (MobUtil.getOwner((Entity)livingEntity) != null && CuriosFinder.hasNetherRobe(MobUtil.getOwner((Entity)livingEntity))) {
                    damageSource = ModDamageSource.magicFireball((Fireball)this, entity1, this.f_19853_);
                }
            }
            if (!(flag = entity.m_6469_(damageSource, damage + enchantment))) {
                entity.m_7311_(i);
            } else if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        BlockState blockstate = this.m_9236_().m_8055_(p_230299_1_.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, p_230299_1_, (Projectile)this);
        if (!this.f_19853_.f_46443_) {
            Entity entity = this.m_19749_();
            if (this.isDangerous()) {
                BlockPos blockpos;
                IOwned iOwned;
                boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_19749_());
                if (entity instanceof Player || entity instanceof IOwned && (iOwned = (IOwned)entity).getTrueOwner() instanceof Player) {
                    flag = (Boolean)SpellConfig.FireballGriefing.get();
                }
                if (flag && this.f_19853_.m_46859_(blockpos = p_230299_1_.m_82425_().m_121945_(p_230299_1_.m_82434_()))) {
                    this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
                }
            }
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            if (pEntity == this.m_19749_()) {
                return false;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }
}

