/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.AbstractBroodMother;
import com.Polarice3.Goety.common.entities.projectiles.TangleEntity;
import com.Polarice3.Goety.init.ModSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;

public class SpiderWeb
extends TangleEntity {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SpiderWeb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState holdAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();

    public SpiderWeb(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public SpiderWeb(Level p_19871_, LivingEntity owner, Entity target) {
        super((EntityType)ModEntityType.SPIDER_WEB.get(), p_19871_, owner, target);
    }

    public SpiderWeb(Level p_19871_, LivingEntity owner, BlockPos blockPos) {
        super((EntityType)ModEntityType.SPIDER_WEB.get(), p_19871_, owner, blockPos);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "hold")) {
            return 1;
        }
        if (Objects.equals(animation, "burrow")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.holdAnimationState);
        list.add(this.burrowAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.holdAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.holdAnimationState);
                    break;
                }
                case 2: {
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burrowAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    public void burst() {
        this.setAnimationState("hold");
        this.m_5496_((SoundEvent)ModSounds.SPIDER_WEB.get(), 1.5f, 1.0f);
    }

    @Override
    public void tangleTarget() {
        super.tangleTarget();
        this.setAnimationState("hold");
    }

    @Override
    public void burrow() {
        this.setAnimationState("burrow");
    }

    @Override
    protected boolean canHitEntity(Entity pEntity) {
        if (pEntity instanceof Spider || pEntity instanceof AbstractBroodMother) {
            return false;
        }
        return super.canHitEntity(pEntity);
    }
}

