/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.TidalSurge;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TidalSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TidalCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.TidalDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ABYSS_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.TidalCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int h;
        float potency = spellStat.getPotency();
        int range = spellStat.getRange();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0f;
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        HitResult hitResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        LivingEntity target = this.getTarget(caster, range);
        int lifespan = 0;
        double y = 0.0;
        Vec3 vec3 = null;
        if (target != null) {
            lifespan = (int)Math.floor(caster.m_20270_((Entity)target)) + 10;
            vec3 = target.m_20182_().m_82546_(caster.m_20182_());
            y = target.m_20186_();
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)hitResult;
            BlockPos blockPos = result.m_82425_();
            Vec3 vec30 = Vec3.m_82512_((Vec3i)blockPos);
            lifespan = (int)Math.floor(Mth.m_14116_((float)((float)caster.m_20238_(vec30)))) + 10;
            vec3 = vec30.m_82546_(caster.m_20182_());
            y = (double)blockPos.m_123342_() + 1.0;
        }
        int n = h = this.rightStaff(staff) ? 1 : 0;
        if (vec3 != null) {
            for (int i = -h; i <= h; ++i) {
                TidalSurge tidalSurge = new TidalSurge((Level)worldIn, caster);
                tidalSurge.m_6034_(caster.m_20185_(), y, caster.m_20189_());
                tidalSurge.setLifespan(lifespan + duration);
                tidalSurge.setWaveScale(tidalSurge.getWaveScale() + potency / 2.0f);
                tidalSurge.m_146922_(-((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)) + (float)(i * 10));
                worldIn.m_7967_((Entity)tidalSurge);
            }
        }
        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_12278_, this.getSoundSource(), 1.0f, 1.0f);
    }
}

