/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.cultists.Crone;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.util.SummonCircleBoss;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.common.items.magic.TaglockKit;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalBallBlock
extends Block {
    public static final VoxelShape SHAPE_BASE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    public static final VoxelShape SHAPE_BASE_2 = Block.m_49796_((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5);
    public static final VoxelShape SHAPE_CRYSTAL = Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BASE_2, SHAPE_CRYSTAL});
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public CrystalBallBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56744_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.TRUE));
    }

    public float m_5880_(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)POWERED) == false ? 3.0f : -1.0f;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)POWERED) == false ? 6.0f : 3600000.0f;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_ && pLevel.m_46791_() != Difficulty.PEACEFUL && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
                Crone crone = new Crone((EntityType<? extends Cultist>)((EntityType)ModEntityType.CRONE.get()), pLevel);
                BlockPos blockPos = BlockFinder.SummonFurtherRadius(pPos, (LivingEntity)crone, pLevel);
                if (!serverLevel.m_8055_(blockPos.m_7495_()).m_60804_((BlockGetter)pLevel, blockPos.m_7495_())) {
                    blockPos = BlockFinder.SummonRadius(pPos, (Entity)crone, pLevel);
                }
                crone.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                if (!CuriosFinder.hasWitchSet((LivingEntity)pPlayer) && MobUtil.validEntity((Entity)pPlayer)) {
                    crone.m_6710_((LivingEntity)pPlayer);
                }
                crone.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pPos), MobSpawnType.MOB_SUMMONED, null, null);
                crone.m_21530_();
                SummonCircleBoss summonCircle = new SummonCircleBoss((Level)serverLevel, blockPos, (Entity)crone);
                if (pLevel.m_7967_((Entity)summonCircle)) {
                    pLevel.m_5594_(null, summonCircle.m_20183_(), (SoundEvent)ModSounds.CRONE_LAUGH.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 0.75f);
                    ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123762_, (float)pPos.m_123341_() + 0.5f, (float)pPos.m_123342_() + 0.5f, (float)pPos.m_123343_() + 0.5f, (Level)serverLevel);
                    pLevel.m_46597_(pPos, (BlockState)((Block)ModBlocks.CRYSTAL_BALL.get()).m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
                }
            } else if (pPlayer.m_21120_(pHand).m_41720_() instanceof TaglockKit && TaglockKit.hasEntity(pPlayer.m_21120_(pHand))) {
                ItemStack itemStack = pPlayer.m_21120_(pHand);
                if (TaglockKit.isSameDimension((LivingEntity)pPlayer, itemStack)) {
                    SEHelper.setCamera(pPlayer, (Entity)TaglockKit.getEntity(pPlayer.m_21120_(pHand)));
                    ModNetwork.sendTo(pPlayer, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.END_WALK.get(), 1.0f, 0.5f));
                    pLevel.m_5594_(pPlayer, pPlayer.m_20183_(), (SoundEvent)ModSounds.END_WALK.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
                } else {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.taglock.difDimension"), true);
                }
            } else if (pPlayer.m_21120_(pHand).m_41720_() instanceof WaystoneItem && WaystoneItem.hasBlock(pPlayer.m_21120_(pHand))) {
                ItemStack itemStack = pPlayer.m_21120_(pHand);
                if (WaystoneItem.isSameDimension((LivingEntity)pPlayer, itemStack)) {
                    SEHelper.setCamera(pPlayer, null, WaystoneItem.getPosition(pPlayer.m_21120_(pHand)).m_122646_());
                    ModNetwork.sendTo(pPlayer, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.END_WALK.get(), 1.0f, 0.5f));
                    pLevel.m_5594_(pPlayer, pPlayer.m_20183_(), (SoundEvent)ModSounds.END_WALK.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
                } else {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.waystone.difDimension"), true);
                }
            } else if (pPlayer.m_21120_(pHand).m_204117_(ModTags.Items.RESPAWN_BOSS) && ((Boolean)MainConfig.CrystalBallRespawn.get()).booleanValue() && BlockFinder.findStructure(serverLevel, (LivingEntity)pPlayer, ModTags.Structures.CRONE_SPAWNS)) {
                ItemStack itemStack = pPlayer.m_21120_(pHand);
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pPos, itemStack);
                }
                pLevel.m_46597_(pPos, (BlockState)((Block)ModBlocks.CRYSTAL_BALL.get()).m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.TRUE));
                itemStack.m_41774_(1);
                pLevel.m_5594_(null, pPos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModBlocks.CRYSTAL_BALL.get());
    }

    public boolean m_7357_(BlockState p_48799_, BlockGetter p_48800_, BlockPos p_48801_, PathComputationType p_48802_) {
        return false;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRand) {
        double d0 = (double)pPos.m_123341_() + pRand.m_188500_();
        double d2 = (double)pPos.m_123343_() + pRand.m_188500_();
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123771_, d0, (double)pPos.m_123342_(), d2, 0.0, 0.0, 0.0);
        }
    }
}

