/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.HauntedMirrorBlockEntity;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayerRotationPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HauntedMirrorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public HauntedMirrorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283757_).m_60913_(1.0f, 3600000.0f).m_60953_(blockState -> 6).m_60955_().m_60918_(SoundType.f_56744_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(pPos.m_7494_()).m_76152_() == Fluids.f_76193_)), 3);
    }

    public void m_5707_(Level p_52755_, BlockPos p_52756_, BlockState p_52757_, Player p_52758_) {
        if (!p_52755_.f_46443_ && p_52758_.m_7500_()) {
            BlockFinder.preventCreativeDropFromBottomPart(p_52755_, p_52756_, p_52757_, p_52758_);
        }
        super.m_5707_(p_52755_, p_52756_, p_52757_, p_52758_);
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos blockpos = blockPos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? super.m_7898_(blockState, level, blockPos) : blockstate.m_60713_((Block)this);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)((Direction)pFacingState.m_61143_((Property)FACING)))).m_61124_((Property)LIT, (Comparable)((Boolean)pFacingState.m_61143_((Property)LIT))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_51750_) {
        boolean flag;
        BlockPos blockpos;
        BlockState blockstate = this.m_49966_();
        Level levelreader = p_51750_.m_43725_();
        FluidState fluidstate = levelreader.m_6425_(blockpos = p_51750_.m_8083_());
        boolean bl = flag = fluidstate.m_76152_() == Fluids.f_76193_;
        if (blockpos.m_123342_() < levelreader.m_151558_() - 1 && levelreader.m_8055_(blockpos.m_7494_()).m_60629_(p_51750_)) {
            for (Direction direction : p_51750_.m_6232_()) {
                if (direction.m_122434_() == Direction.Axis.Y || !(blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)FACING, (Comparable)direction)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_60710_((LevelReader)levelreader, blockpos)) continue;
                return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
        }
        return null;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState p_58114_, BlockGetter p_58115_, BlockPos p_58116_, CollisionContext p_58117_) {
        return switch ((Direction)p_58114_.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SOUTH_AABB;
            default -> NORTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    public BlockState m_6843_(BlockState p_58109_, Rotation p_58110_) {
        return (BlockState)p_58109_.m_61124_((Property)FACING, (Comparable)p_58110_.m_55954_((Direction)p_58109_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_58106_, Mirror p_58107_) {
        return p_58106_.m_60717_(p_58107_.m_54846_((Direction)p_58106_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_58112_) {
        p_58112_.m_61104_(new Property[]{FACING, WATERLOGGED, HALF, LIT});
    }

    public static Direction getDirection(BlockState blockState) {
        return (Direction)blockState.m_61143_((Property)FACING);
    }

    public static boolean isBlockTopOfMirror(BlockState blockState) {
        return blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER;
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!level.f_46443_ && entity.f_19797_ % 5 == 1 && (entity instanceof LivingEntity || entity instanceof ItemEntity)) {
            boolean validSize;
            int x = blockPos.m_123341_();
            int y = blockPos.m_123342_();
            int z = blockPos.m_123343_();
            int yShift = 0;
            if (!HauntedMirrorBlock.isBlockTopOfMirror(blockState)) {
                ++y;
                if (entity.m_20206_() <= 1.0f) {
                    yShift = -1;
                }
                if (level.m_8055_(new BlockPos(x, y, z)).m_60734_() != this) {
                    return;
                }
            }
            BlockPos blockPos1 = new BlockPos(x, y + yShift, z);
            AABB box = this.getBlockBoundingBox(blockPos1, blockState);
            float validWidth = EntityType.f_20532_.m_20678_();
            float validHeight = EntityType.f_20532_.m_20679_();
            boolean bl = validSize = entity.m_20205_() <= validWidth && entity.m_20206_() <= validHeight;
            if (entity.m_20191_().m_82381_(box) && validSize) {
                BlockState blockState2;
                BlockState blockState1;
                int newY;
                int i;
                Direction direction = (Direction)blockState.m_61143_((Property)FACING);
                int dx = direction.m_122429_();
                int dz = direction.m_122431_();
                float xShift = -direction.m_122429_();
                float zShift = -direction.m_122431_();
                Direction requiredSide = direction.m_122424_();
                for (i = 1; i < 32; ++i) {
                    Direction direction1;
                    int newX = x + dx * i;
                    int newZ = z + dz * i;
                    BlockPos blockPos2 = new BlockPos(newX, y, newZ);
                    BlockState blockState12 = level.m_8055_(blockPos2);
                    if (blockState12.m_60734_() != this || (direction1 = (Direction)blockState12.m_61143_((Property)FACING)) != requiredSide) continue;
                    entity.m_6021_(0.5 + (double)newX - (double)xShift, (double)(y - 1) + 0.01, 0.5 + (double)newZ - (double)zShift);
                    this.teleportHit(level, entity);
                    return;
                }
                for (i = 2; i < 16; ++i) {
                    newY = y + i;
                    BlockPos blockPos2 = new BlockPos(x, newY, z);
                    blockState1 = level.m_8055_(blockPos2);
                    if (blockState1.m_60734_() != this || HauntedMirrorBlock.getDirection(blockState2 = level.m_8055_(blockPos2)) != direction) continue;
                    if (HauntedMirrorBlock.isBlockTopOfMirror(blockState2)) {
                        --newY;
                    }
                    entity.m_6021_(0.5 + (double)x + (double)xShift, (double)newY + 0.01, 0.5 + (double)z + (double)zShift);
                    this.teleportHit(level, entity);
                    float turnAround = entity.m_7890_(Rotation.CLOCKWISE_180);
                    entity.m_146922_(turnAround);
                    entity.f_19859_ = turnAround;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        ModNetwork.sendTo((Player)serverPlayer, new SPlayerRotationPacket(turnAround, serverPlayer.m_146909_()));
                    }
                    return;
                }
                for (i = 2; i < 16; ++i) {
                    newY = y - i;
                    BlockPos blockPos2 = new BlockPos(x, newY, z);
                    blockState1 = level.m_8055_(blockPos2);
                    if (blockState1.m_60734_() != this || HauntedMirrorBlock.getDirection(blockState2 = level.m_8055_(blockPos2)) != direction) continue;
                    if (HauntedMirrorBlock.isBlockTopOfMirror(blockState2)) {
                        --newY;
                    }
                    entity.m_6021_(0.5 + (double)x + (double)xShift, (double)newY + 0.01, 0.5 + (double)z + (double)zShift);
                    this.teleportHit(level, entity);
                    float turnAround = entity.m_7890_(Rotation.CLOCKWISE_180);
                    entity.m_146922_(turnAround);
                    entity.f_19859_ = turnAround;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        ModNetwork.sendTo((Player)serverPlayer, new SPlayerRotationPacket(turnAround, serverPlayer.m_146909_()));
                    }
                    return;
                }
            }
        }
    }

    public AABB getBlockBoundingBox(BlockPos blockPos, BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        if (direction == Direction.SOUTH) {
            minZ = 0.32f;
        } else if (direction == Direction.NORTH) {
            maxZ = 0.68f;
        } else if (direction == Direction.WEST) {
            minX = 0.32f;
        } else if (direction == Direction.EAST) {
            maxX = 0.68f;
        }
        return new AABB((double)((float)blockPos.m_123341_() + minX), (double)((float)blockPos.m_123342_() + minY), (double)((float)blockPos.m_123343_() + minZ), (double)((float)blockPos.m_123341_() + maxX), (double)((float)blockPos.m_123342_() + maxY), (double)((float)blockPos.m_123343_() + maxZ));
    }

    public void teleportHit(Level level, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < serverLevel.f_46441_.m_188503_(10) + 10; ++i) {
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SUMMON.get()), entity.m_20208_(1.5), entity.m_20187_(), entity.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
        level.m_214171_(GameEvent.f_238175_, entity.m_20182_(), GameEvent.Context.m_223717_((Entity)entity));
        if (!entity.m_20067_()) {
            level.m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 0.5f, 0.75f);
            level.m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, (SoundEvent)ModSounds.CAST_SPELL.get(), entity.m_5720_(), 1.0f, 0.75f);
            entity.m_5496_(SoundEvents.f_11852_, 0.5f, 0.75f);
            entity.m_5496_((SoundEvent)ModSounds.CAST_SPELL.get(), 1.0f, 0.75f);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new HauntedMirrorBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_222100_, BlockState p_222101_, BlockEntityType<T> p_222102_) {
        return (world, pos, state, blockEntity) -> {
            if (!world.f_46443_ && blockEntity instanceof HauntedMirrorBlockEntity) {
                HauntedMirrorBlockEntity blockEntity1 = (HauntedMirrorBlockEntity)blockEntity;
                blockEntity1.tick();
            }
        };
    }
}

