/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.golem;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.golem.AbstractGolemServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SRCGlowPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class RedstoneCube
extends AbstractGolemServant {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RedstoneCube.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RedstoneCube.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String WALK = "walk";
    public int attackTick;
    public float minorGlow;
    public float bigGlow;
    public float glowAmount = 0.01f;
    public Vec3 detectPos;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public RedstoneCube(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new SeekBlockGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.RedstoneCubeHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RedstoneCubeDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.RedstoneCubeArmor.get()).doubleValue()).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.RedstoneCubeFollowRange.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.RedstoneCubeHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.RedstoneCubeArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RedstoneCubeDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.RedstoneCubeFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.REDSTONE_CUBE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REDSTONE_CUBE_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.REDSTONE_CUBE_WALK.get(), 0.5f, 1.0f);
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    @Override
    public boolean m_6094_() {
        return this.m_6084_() && !this.m_5833_() && !this.m_6147_();
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        Mob mob;
        if (entityIn instanceof Mob && (mob = (Mob)entityIn).m_5448_() != this) {
            mob.m_6710_((LivingEntity)this);
        }
        return super.m_7327_(entityIn);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.MOB_SUMMONED && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            for (int i = 0; i < 8; ++i) {
                double d0 = this.m_20185_() + this.f_19796_.m_188500_();
                double d1 = this.m_20186_() + 1.0;
                double d2 = this.m_20189_() + this.f_19796_.m_188500_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0, 0.0, 0.5, 0.0, 0.5);
            }
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_CUBE_BURST.get(), 0.65f, 0.7f + Math.min(this.f_19796_.m_188501_(), 0.5f));
        }
        return pSpawnData;
    }

    @Override
    public boolean canAnimateMove() {
        return super.canAnimateMove() && this.getCurrentAnimation() == this.getAnimationState(WALK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "walk")) {
            return 2;
        }
        if (Objects.equals(animation, "attack")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 3: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attack) {
        this.setFlag(1, attack);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected boolean m_6129_() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            if (!this.f_19853_.f_46443_) {
                ItemStack itemStack;
                if (this.isMeleeAttacking()) {
                    this.m_21573_().m_26573_();
                    ++this.attackTick;
                    if (this.attackTick >= MathHelper.secondsToTicks(1)) {
                        this.setMeleeAttacking(false);
                        this.setAnimationState(IDLE);
                    } else if (this.getCurrentAnimation() != this.getAnimationState(ATTACK)) {
                        this.setAnimationState(ATTACK);
                    }
                } else if (this.isMoving()) {
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (this.m_20096_() && this.f_19797_ % 5 == 0) {
                            ColorUtil colorUtil = new ColorUtil(0xFF0000);
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.REDSTONE_DEBRIS.get()), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 1.0);
                        }
                    }
                    this.setAnimationState(WALK);
                } else {
                    this.setAnimationState(IDLE);
                }
                if (this.m_5448_() != null) {
                    if (this.m_5448_().m_6084_() && EntitySelector.f_20406_.test(this.m_5448_()) && this.m_142582_((Entity)this.m_5448_())) {
                        if (this.targetClose(this.m_5448_(), this.m_20280_((Entity)this.m_5448_()))) {
                            if (!this.isMeleeAttacking()) {
                                this.setMeleeAttacking(true);
                            }
                            if (this.attackTick == 8) {
                                this.m_7327_((Entity)this.m_5448_());
                                this.m_5496_((SoundEvent)ModSounds.REDSTONE_CUBE_ATTACK.get(), 0.6f, 1.0f);
                            }
                        } else {
                            this.m_21573_().m_5624_((Entity)this.m_5448_(), 1.25);
                        }
                    }
                    if (!EntitySelector.f_20406_.test(this.m_5448_())) {
                        this.m_6710_(null);
                    }
                }
                if (!(itemStack = this.m_21205_()).m_41619_() && ((Boolean)MobsConfig.RedstoneCubeBlockFind.get()).booleanValue()) {
                    Block block = Block.m_49814_((Item)itemStack.m_41720_());
                    if (this.f_19797_ % 20 == 0) {
                        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                        this.detectPos = null;
                        for (int i = -16; i <= 16; ++i) {
                            for (int j = -16; j <= 16; ++j) {
                                for (int k = -16; k <= 16; ++k) {
                                    BlockPos blockPos2 = this.m_20183_().m_7918_(i, j, k);
                                    if (this.f_19853_.m_8055_(blockPos2).m_60734_() != block) continue;
                                    blockPosList.add(blockPos2);
                                }
                            }
                        }
                        if (!blockPosList.isEmpty()) {
                            blockPosList.sort(Comparator.comparingDouble(blockPos -> this.m_20238_(Vec3.m_82512_((Vec3i)blockPos))));
                            if (blockPosList.stream().findFirst().isPresent()) {
                                float distance;
                                BlockPos blockPos3 = (BlockPos)blockPosList.stream().findFirst().get();
                                this.bigGlow = distance = 1.0f - (float)this.m_20238_(Vec3.m_82512_((Vec3i)blockPos3)) / Mth.m_14207_((float)16.0f);
                                this.m_5496_((SoundEvent)ModSounds.TOCK.get(), distance, 1.5f);
                                this.detectPos = Vec3.m_82512_((Vec3i)blockPos3);
                            }
                        }
                    }
                } else {
                    this.detectPos = null;
                }
                this.bigGlow = Math.max(this.bigGlow - 0.01f, 0.0f);
                ModNetwork.sentToTrackingEntityAndPlayer((Entity)this, new SRCGlowPacket(this.m_19879_(), this.bigGlow));
            } else {
                this.glow();
            }
        }
    }

    private void glow() {
        this.minorGlow = Mth.m_14036_((float)(this.minorGlow + this.glowAmount), (float)0.0f, (float)1.0f);
        if (this.minorGlow == 0.0f || this.minorGlow == 1.0f) {
            this.glowAmount *= -1.0f;
        }
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + enemy.m_20205_();
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.m_21561_(true);
        } else if (p_21375_ == 7) {
            this.m_21561_(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if ((pPlayer.m_6047_() || pPlayer.m_6144_()) && pHand == InteractionHand.MAIN_HAND && ((Boolean)MobsConfig.RedstoneCubeBlockFind.get()).booleanValue()) {
                    BlockItem blockItem;
                    if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().m_49966_().m_204336_(ModTags.Blocks.REDSTONE_CUBE_DETECT) && !blockItem.m_40614_().m_49966_().m_204336_(ModTags.Blocks.REDSTONE_CUBE_EXEMPT) && this.m_21205_().m_41720_() != item) {
                        this.m_5496_(SoundEvents.f_11686_, 1.0f, 1.25f);
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_255036_(1));
                        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                        EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                        return InteractionResult.SUCCESS;
                    }
                    if (itemstack.m_41619_() && !this.m_21205_().m_41619_()) {
                        this.m_5496_(SoundEvents.f_11686_, 1.0f, 1.25f);
                        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                        return InteractionResult.SUCCESS;
                    }
                } else if ((itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_REDSTONE) || itemstack.m_204117_(Tags.Items.DUSTS_REDSTONE)) && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_REDSTONE)) {
                        this.m_5634_(this.m_21233_());
                        this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.25f);
                    } else {
                        this.m_5634_(this.m_21233_() / 4.0f);
                        this.m_5496_(SoundEvents.f_12009_, 0.25f, 1.0f);
                    }
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static class SeekBlockGoal
    extends Summoned.WanderGoal<RedstoneCube> {
        private final RedstoneCube redstoneCube;

        public SeekBlockGoal(RedstoneCube cube) {
            super(cube, 1.0, 60, 10.0f);
            this.redstoneCube = cube;
        }

        @Override
        @Nullable
        protected Vec3 m_7037_() {
            if (this.redstoneCube.detectPos != null) {
                Vec3 vec3 = LandRandomPos.m_148492_((PathfinderMob)this.redstoneCube, (int)10, (int)7, (Vec3)this.redstoneCube.detectPos);
                return vec3 == null ? super.m_7037_() : vec3;
            }
            return super.m_7037_();
        }
    }
}

