/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.common.entities.ally.spider.SpiderServant;
import com.Polarice3.Goety.common.entities.projectiles.BoneShard;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class BoneSpider
extends Spider
implements RangedAttackMob {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("2a3ee720-61cb-402c-affa-2eef9343910d");
    public static final AttributeModifier STOP_MODIFIER = new AttributeModifier(SPEED_MODIFIER_UUID, "Stop Moving Dammit", -1.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BoneSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String ATTACK = "attack";
    public int attackAnim;
    public AnimationState attackAnimationState = new AnimationState();

    public BoneSpider(EntityType<? extends Spider> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new ShootBoneGoal(this, 1.0, 50, 16.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return SpiderServant.setCustomAttributes().m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BoneSpiderServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BoneSpiderServantHealth.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BoneSpiderServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BoneSpiderServantDamage.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        return 0;
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.attackAnimationState.m_216973_();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
    }

    protected float m_6121_() {
        return 0.5f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.BONE_SPIDER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return (SoundEvent)ModSounds.BONE_SPIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BONE_SPIDER_DEATH.get();
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_((SoundEvent)ModSounds.BONE_SPIDER_STEP.get(), 0.15f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            if (this.getCurrentAnimation() == this.getAnimationState(ATTACK)) {
                this.m_21573_().m_26573_();
                if (modifiableattributeinstance != null && this.m_21051_(Attributes.f_22279_) != null) {
                    modifiableattributeinstance.m_22130_(STOP_MODIFIER);
                    modifiableattributeinstance.m_22118_(STOP_MODIFIER);
                }
            } else if (modifiableattributeinstance != null && modifiableattributeinstance.m_22109_(STOP_MODIFIER)) {
                modifiableattributeinstance.m_22130_(STOP_MODIFIER);
            }
            if (this.attackAnim > 0) {
                --this.attackAnim;
            } else {
                this.setAnimationState("");
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_32259_, DifficultyInstance p_32260_, MobSpawnType p_32261_, @Nullable SpawnGroupData p_32262_, @Nullable CompoundTag p_32263_) {
        return p_32262_;
    }

    protected float m_6431_(Pose p_32265_, EntityDimensions p_32266_) {
        return 0.45f;
    }

    public void m_6504_(LivingEntity target, float p_33318_) {
        BoneShard boneShard = new BoneShard((LivingEntity)this, this.f_19853_);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - boneShard.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        boneShard.m_36781_(boneShard.m_36789_() + (Double)AttributesConfig.BoneSpiderServantRangeDamage.get());
        boneShard.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.f_19853_.m_46791_().m_19028_() * 4);
        this.f_19853_.m_7967_((Entity)boneShard);
    }

    static class ShootBoneGoal
    extends Goal {
        public BoneSpider spider;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private final int attackInterval;
        private final float attackRadius;
        private final double attackRadiusSqr;

        public ShootBoneGoal(BoneSpider mob, double speed, int attackInterval, float attackRadius) {
            this.spider = mob;
            this.speedModifier = speed;
            this.attackInterval = attackInterval;
            this.attackRadius = attackRadius;
            this.attackRadiusSqr = attackRadius * attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity living = this.spider.m_5448_();
            if (living != null && living.m_6084_()) {
                this.target = living;
                return living.m_20270_((Entity)this.spider) >= 4.0f;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target != null && this.spider.getCurrentAnimation() == this.spider.getAnimationState(ATTACK);
        }

        public void m_8056_() {
            this.target = null;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                double d0 = this.spider.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                boolean flag = this.spider.m_21574_().m_148306_((Entity)this.target);
                if (d0 <= this.attackRadiusSqr) {
                    this.spider.m_21573_().m_26573_();
                    if (flag) {
                        --this.attackTime;
                    }
                } else {
                    this.spider.attackAnim = 0;
                    this.spider.setAnimationState("");
                    this.spider.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                }
                this.spider.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                if (this.attackTime == 20) {
                    this.spider.setAnimationState(ATTACK);
                    this.spider.attackAnim = MathHelper.secondsToTicks(2) + 5;
                    this.spider.m_5496_((SoundEvent)ModSounds.BONE_SPIDER_SPIT.get(), this.spider.m_6121_(), this.spider.m_6100_());
                }
                if (this.attackTime == 0) {
                    if (!flag) {
                        return;
                    }
                    float f = (float)Math.sqrt(d0) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    this.spider.m_6504_(this.target, f1);
                    this.attackTime = this.attackInterval;
                } else if (this.attackTime < 0) {
                    this.attackTime = this.attackInterval;
                }
            }
        }
    }
}

