/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.api.entities.IHiding;
import com.Polarice3.Goety.client.particles.TeleportInShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.TeleportShockwaveParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.CarrionMaggot;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.util.DelayedSummon;
import com.Polarice3.Goety.common.entities.util.ModFallingBlock;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.NoKnockBackDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class Wight
extends Summoned
implements Enemy,
NeutralMob,
IHiding {
    private static final EntityDataAccessor<Boolean> IS_CLONE = SynchedEntityData.m_135353_(Wight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HIDE = SynchedEntityData.m_135353_(Wight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Wight.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Wight.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String WALK = "walk";
    public static String ATTACK = "attack";
    public static String SMASH = "smash";
    public static String SUPER_SMASH = "super_smash";
    public static String UNLEASH = "unleash";
    public static String SUMMON = "summon";
    private final ModServerBossInfo bossInfo;
    public int screamTick;
    public int attackTick;
    public int hidingTime = 0;
    public int hidingCooldown = 0;
    public int deathTime = 0;
    public int regenHeal = 0;
    public int spawnCool = 100;
    public int teleportCool = 0;
    public int lookTime = 0;
    public double prevX;
    public double prevY;
    public double prevZ;
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    public DamageSource deathBlow = this.m_269291_().m_269264_();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();
    public AnimationState unleashAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState superSmashAnimationState = new AnimationState();

    public Wight(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.bossInfo = new ModServerBossInfo((Mob)this, BossEvent.BossBarColor.PURPLE, false, false);
        this.setHostile(true);
        this.waterNavigation = new WightAquaticNavigation((Mob)this, worldIn);
        this.groundNavigation = new WightNavigation((Mob)this, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_OPEN, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new StarePlayerGoal((Mob)this, 64.0f));
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(1.5));
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<Wight>(this, 0.8, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new WightLookForPlayerGoal(this, arg_0 -> ((Wight)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public void targetSelectGoal() {
    }

    @Override
    public void addTargetGoal() {
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WightHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WightDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WightHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.WightDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CLONE, (Object)false);
        this.f_19804_.m_135372_(DATA_HIDE, (Object)false);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag p_32520_) {
        super.m_7380_(p_32520_);
        p_32520_.m_128405_("HidingTime", this.hidingTime);
        p_32520_.m_128405_("HidingCooldown", this.hidingCooldown);
        p_32520_.m_128405_("RegenHeal", this.regenHeal);
        p_32520_.m_128405_("SpawnCool", this.spawnCool);
        p_32520_.m_128405_("TeleportCool", this.teleportCool);
        p_32520_.m_128379_("Hiding", this.isHiding());
        p_32520_.m_128379_("Clone", this.isHallucination());
        this.m_21678_(p_32520_);
    }

    @Override
    public void m_7378_(CompoundTag p_32511_) {
        super.m_7378_(p_32511_);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setHallucination(p_32511_.m_128471_("Clone"));
        this.setHide(p_32511_.m_128471_("Hiding"));
        this.hidingTime = p_32511_.m_128451_("HidingTime");
        this.hidingCooldown = p_32511_.m_128451_("HidingCooldown");
        this.regenHeal = p_32511_.m_128451_("RegenHeal");
        this.spawnCool = p_32511_.m_128451_("SpawnCool");
        this.teleportCool = p_32511_.m_128451_("TeleportCool");
        this.m_147285_(this.f_19853_, p_32511_);
    }

    public boolean isEasterEgg() {
        return this.m_7770_() != null && (this.m_7770_().getString().contains("Walter") || this.m_7770_().getString().contains("Waltuh") || this.m_7770_().getString().contains("Heisenberg"));
    }

    public void m_6825_() {
        this.m_7870_(MathHelper.minutesToTicks(10));
    }

    public void m_7870_(int p_32515_) {
        this.remainingPersistentAngerTime = p_32515_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID p_32509_) {
        this.persistentAngerTarget = p_32509_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.m_6069_();
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public void m_8032_() {
        if (!this.isHiding()) {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WIGHT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.WIGHT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WIGHT_DEATH.get();
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "attack")) {
            return 2;
        }
        if (Objects.equals(animation, "smash")) {
            return 3;
        }
        if (Objects.equals(animation, "unleash")) {
            return 4;
        }
        if (Objects.equals(animation, "summon")) {
            return 5;
        }
        if (Objects.equals(animation, "super_smash")) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.smashAnimationState);
        animationStates.add(this.unleashAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.superSmashAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 3: {
                    this.smashAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.smashAnimationState);
                    break;
                }
                case 4: {
                    this.unleashAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.unleashAnimationState);
                    break;
                }
                case 5: {
                    this.summonAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.summonAnimationState);
                    break;
                }
                case 6: {
                    this.superSmashAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.superSmashAnimationState);
                }
            }
        }
        if (DATA_HIDE.equals(p_219422_)) {
            this.m_6210_();
        }
        super.m_7350_(p_219422_);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (this.isHallucination()) {
            this.hallucinateVanish();
        } else if (this.deathTime > 0) {
            super.m_6667_(cause);
        }
    }

    protected void m_6153_() {
        ++this.deathTime;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 2; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, 0.0, 0.0, 0.0, 0.5);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
        if (this.deathTime == 1) {
            this.m_6667_(this.deathBlow);
        }
        if (this.deathTime >= 60) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue() && !this.isHallucination()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    @Override
    public int xpReward() {
        return 40;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        if (this.isHiding()) {
            return 0.1f;
        }
        return super.m_6431_(p_32517_, p_32518_);
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.isHiding() || this.isHallucination();
    }

    public boolean m_6051_() {
        return !this.isHiding() && super.m_6051_();
    }

    public boolean m_6097_() {
        return super.m_6097_() && !this.isHiding();
    }

    @Override
    public boolean m_20177_(Player p_20178_) {
        if (this.isHallucination()) {
            return false;
        }
        if (this.isHiding()) {
            return true;
        }
        return super.m_20177_(p_20178_);
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.isHiding();
    }

    public boolean m_6673_(DamageSource p_20122_) {
        return super.m_6673_(p_20122_) || this.isHiding();
    }

    public boolean m_142065_() {
        return super.m_142065_() && !this.isHiding();
    }

    private boolean getWightFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setWightFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getWightFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setWightFlags(1, attacking);
        this.attackTick = 0;
    }

    public boolean isScreaming() {
        return this.getWightFlag(2) || this.getWightFlag(8);
    }

    public void setScreaming(boolean scream) {
        this.setWightFlags(2, scream);
        this.screamTick = 0;
        if (!this.f_19853_.f_46443_ && scream) {
            this.setAnimationState(UNLEASH);
            this.applyDarkness();
        }
    }

    public boolean isClimbing() {
        return this.getWightFlag(4);
    }

    public void setClimbing(boolean climbing) {
        this.setWightFlags(4, climbing);
    }

    public boolean isSummoning() {
        return this.getWightFlag(8);
    }

    public void setSummoning(boolean scream) {
        this.setWightFlags(8, scream);
        this.screamTick = 0;
        if (!this.f_19853_.f_46443_ && scream) {
            this.setAnimationState(SUMMON);
        }
    }

    public boolean isHallucination() {
        return (Boolean)this.f_19804_.m_135370_(IS_CLONE);
    }

    public void setHallucination(boolean shadowClone) {
        this.f_19804_.m_135381_(IS_CLONE, (Object)shadowClone);
    }

    public void spawnHallucination() {
        this.setHallucination(true);
        this.f_19853_.m_7605_((Entity)this, (byte)6);
    }

    @Override
    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HIDE);
    }

    public void setHide(boolean hide) {
        this.f_19804_.m_135381_(DATA_HIDE, (Object)hide);
    }

    public ResourceLocation m_7582_() {
        return !this.isHallucination() ? super.m_7582_() : null;
    }

    public void applyDarkness() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, MathHelper.secondsToTicks(6), 0, false, false);
            MobEffectUtil.m_216946_((ServerLevel)serverLevel, (Entity)this, (Vec3)this.m_20182_(), (double)20.0, (MobEffectInstance)mobeffectinstance, (int)200);
        }
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.prevX, this.prevY, this.prevZ, (SoundEvent)ModSounds.WIGHT_TELEPORT_SCREAM.get(), this.m_5720_(), this.m_6121_() + 1.0f, this.m_6100_());
            this.m_5496_((SoundEvent)ModSounds.WIGHT_TELEPORT_SCREAM.get(), this.m_6121_() + 1.0f, this.m_6100_());
        }
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        if (this.isHiding()) {
            return EntityDimensions.m_20395_((float)0.1f, (float)0.1f);
        }
        if (p_21047_ == Pose.CROUCHING) {
            return super.m_6972_(p_21047_).m_20390_(1.0f, 0.25f);
        }
        return super.m_6972_(p_21047_);
    }

    @Override
    public boolean m_6469_(DamageSource p_32494_, float p_32495_) {
        if (this.m_6673_(p_32494_)) {
            return false;
        }
        if (p_32494_.m_276093_(DamageTypes.f_268612_) || p_32494_.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (!this.isMeleeAttacking() && this.attackTick <= 0 && this.teleportCool <= 0 && !(p_32494_ instanceof NoKnockBackDamageSource) && p_32495_ < this.m_21223_() && !this.f_19853_.m_5776_() && (p_32495_ < this.m_21223_() && p_32494_.m_7639_() instanceof LivingEntity || !(p_32494_.m_7639_() instanceof LivingEntity) && !p_32494_.m_269533_(DamageTypeTags.f_268745_) && !p_32494_.m_269533_(DamageTypeTags.f_268731_)) && this.teleport()) {
            this.teleportCool = MathHelper.secondsToTicks(2);
        }
        if (this.isHallucination() && p_32495_ > 0.0f) {
            this.hallucinateVanish();
        }
        if (this.m_21224_()) {
            this.deathBlow = p_32494_;
        }
        return super.m_6469_(p_32494_, p_32495_);
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
    }

    protected boolean m_7341_(Entity p_219462_) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_21515_() && this.m_20069_()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    public void breakBlocksAround() {
        if (this.m_21224_() || this.isHallucination() || !ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            return;
        }
        for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)this.m_20183_().m_7494_(), (int)1, (int)1, (int)1)) {
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49991_) || blockState.m_60713_(Blocks.f_49990_)) continue;
            Block block = blockState.m_60734_();
            if (blockPos.m_123341_() == this.m_146903_() && blockPos.m_123343_() == this.m_146907_() && this.m_20183_().m_123342_() < blockPos.m_123342_() && this.isClimbing() && !blockState.m_60795_() && blockState.m_60734_() instanceof LeavesBlock) {
                this.f_19853_.m_46961_(blockPos, false);
            }
            if (block instanceof TrapDoorBlock && blockState.m_61138_((Property)TrapDoorBlock.f_57514_)) {
                if (blockPos.m_123342_() > this.m_146904_()) {
                    if (((Boolean)blockState.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) continue;
                    this.f_19853_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (!((Boolean)blockState.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) continue;
                this.f_19853_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(false)));
                continue;
            }
            if (this.isClimbing() || !(block instanceof DoorBlock)) continue;
            this.f_19853_.m_46961_(blockPos, true);
            this.f_19853_.m_245747_(blockPos, SoundEvents.f_12601_, SoundSource.BLOCKS, 2.0f, 1.0f, true);
        }
    }

    @Override
    public void m_8119_() {
        boolean shouldStand;
        super.m_8119_();
        this.bossInfo.m_8321_(this.m_5912_() && !this.isHallucination());
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        BlockPos standPos0 = this.m_20183_().m_7918_(0, 2, 0);
        BlockPos standPos1 = this.m_20183_().m_7918_(0, 1, 0);
        boolean frontStand = this.f_19853_.m_8055_(standPos0.m_121945_(this.m_6350_())).m_60812_((BlockGetter)this.f_19853_, standPos0.m_121945_(this.m_6350_())).m_83281_() && this.f_19853_.m_8055_(standPos1.m_121945_(this.m_6350_())).m_60812_((BlockGetter)this.f_19853_, standPos1.m_121945_(this.m_6350_())).m_83281_();
        boolean bl = shouldStand = this.f_19853_.m_8055_(standPos0).m_60812_((BlockGetter)this.f_19853_, standPos0).m_83281_() && this.f_19853_.m_8055_(standPos1).m_60812_((BlockGetter)this.f_19853_, standPos1).m_83281_();
        if (frontStand && shouldStand && !this.m_5830_() || this.isClimbing()) {
            this.m_20124_(Pose.STANDING);
        } else {
            this.m_20124_(Pose.CROUCHING);
        }
        if (this.isClimbing()) {
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + 0.8f);
        }
    }

    @Override
    public void m_8107_() {
        this.f_20899_ = false;
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            Level level;
            this.m_21561_(this.m_5448_() != null);
            if (!this.isMeleeAttacking() && !this.isScreaming()) {
                this.setAnimationState(IDLE);
            }
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
            }
            if (this.m_5448_() != null) {
                this.breakBlocksAround();
            }
            if ((level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 vec3 = this.m_20184_();
                if (this.m_5842_() && (this.m_5448_() == null || this.m_5448_().m_146904_() > this.m_146904_() + 2)) {
                    this.m_20334_(vec3.m_7096_(), 0.25, vec3.m_7094_());
                } else if (this.m_20069_() && this.m_5448_() != null && this.m_5448_().m_146904_() + 2 < this.m_146904_()) {
                    this.m_20334_(vec3.m_7096_(), -0.25, vec3.m_7094_());
                }
                this.climb(serverLevel);
                this.m_21666_(serverLevel, true);
                if (!this.isHiding()) {
                    this.hidingTime = 0;
                    if (this.regenHeal > 0 && this.f_19797_ % 10 == 0) {
                        --this.regenHeal;
                        if (!this.m_6060_()) {
                            this.m_5634_(1.0f);
                            Vec3 vector3d = this.m_20184_();
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, vector3d.f_82479_ * -0.2, 0.1, vector3d.f_82481_ * -0.2, 0.5);
                        }
                    }
                    for (int i = 0; i < 2; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, 0.0, 0.0, 0.0, 0.5);
                    }
                } else {
                    ++this.hidingTime;
                    if (this.hidingTime >= MathHelper.secondsToTicks(5)) {
                        this.setHide(false);
                        this.f_19853_.m_7605_((Entity)this, (byte)5);
                        this.hidingCooldown = MathHelper.secondsToTicks(this.f_19853_.f_46441_.m_188503_(5) + 5);
                        if (this.m_5448_() != null) {
                            this.teleportNearTo((Entity)this.m_5448_());
                            this.teleportHit(serverLevel);
                        } else {
                            this.teleport();
                            this.teleportHit(serverLevel);
                        }
                    }
                }
            }
            if (this.isScreaming()) {
                int total;
                if (this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
                }
                this.m_21573_().m_26573_();
                ++this.screamTick;
                int n = total = this.isSummoning() ? 30 : 4;
                if (this.screamTick >= total) {
                    for (int i = 0; i < 64; ++i) {
                        if (!this.teleport()) continue;
                        this.setScreaming(false);
                        this.setSummoning(false);
                        this.f_19853_.m_7605_((Entity)this, (byte)9);
                        break;
                    }
                }
            }
            if (this.hidingCooldown > 0) {
                --this.hidingCooldown;
            }
            if (this.spawnCool > 0 && !this.isHiding()) {
                --this.spawnCool;
            }
            if (this.teleportCool > 0) {
                --this.teleportCool;
            }
            if (this.isHallucination() && this.getTrueOwner() != null && this.getTrueOwner().m_21224_()) {
                this.hallucinateVanish();
            }
        }
        if (this.isHiding() || this.isScreaming()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
            this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
        }
        super.m_8107_();
    }

    public void hallucinateVanish() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(10) + 10; ++i) {
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123762_, (Entity)this);
            }
        }
        this.m_146870_();
    }

    public int getClimbHeight(BlockPos pPos) {
        int y = 0;
        BlockPos blockPos = pPos;
        while (this.f_19853_.m_8055_(blockPos).m_60804_((BlockGetter)this.f_19853_, blockPos)) {
            blockPos = blockPos.m_7494_();
            if (++y <= this.f_19853_.m_151558_()) continue;
        }
        if (y > 0) {
            ++y;
        }
        return y;
    }

    public boolean isClimbable(BlockPos pPos, int pHeight) {
        for (int i = 1; i <= pHeight; ++i) {
            BlockPos above = pPos.m_6630_(i);
            if (!this.f_19853_.m_8055_(above).m_60804_((BlockGetter)this.f_19853_, above)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockPos getClimbPos(BlockPos pPos) {
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                BlockPos blockPos = pPos.m_7918_(i, 0, k);
                if (!this.f_19853_.m_8055_(blockPos).m_60804_((BlockGetter)this.f_19853_, blockPos)) continue;
                return blockPos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getClimbablePos(BlockPos pPos, int pHeight) {
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                BlockPos blockPos = pPos.m_7918_(i, 0, k);
                if (!this.isClimbable(blockPos, pHeight)) continue;
                return blockPos;
            }
        }
        return null;
    }

    public static double horizontalDistance(Vec3 firstPos, Vec3 secondPos) {
        Vec2 vec2 = new Vec2((float)firstPos.f_82479_, (float)firstPos.f_82481_);
        Vec2 vec21 = new Vec2((float)secondPos.f_82479_, (float)secondPos.f_82481_);
        return Math.sqrt(vec21.m_165914_(vec2));
    }

    public static boolean haveBlocksAround(Level level, BlockPos pPos, int rangeX, int rangeY, int rangeZ) {
        for (int i = -rangeX; i <= rangeX; ++i) {
            for (int j = -rangeY; j <= rangeY; ++j) {
                for (int k = -rangeZ; k <= rangeZ; ++k) {
                    BlockPos blockPos = pPos.m_7918_(i, j, k);
                    BlockState blockState = level.m_8055_(blockPos);
                    if (blockState.m_60812_((BlockGetter)level, blockPos).m_83281_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void climb(ServerLevel serverLevel) {
        if (this.m_5448_() == null) {
            this.setClimbing(false);
            return;
        }
        boolean blocksAbove = Wight.haveBlocksAround((Level)serverLevel, this.m_20183_().m_6630_(2), 1, 0, 1);
        this.setClimbing(blocksAbove && Wight.horizontalDistance(this.m_20182_(), this.m_5448_().m_20182_()) <= 5.0 && this.m_5448_().m_146904_() > this.m_146904_());
        if (this.isClimbing()) {
            this.m_20334_(0.0, 0.25, 0.0);
            BlockPos blockPos = this.getClimbPos(this.m_20183_());
            if (blockPos != null) {
                this.m_21563_().m_24964_(blockPos.m_252807_());
                int height = this.getClimbHeight(blockPos);
                BlockPos blockPos1 = this.getClimbablePos(blockPos, height);
                if (blockPos1 != null) {
                    Vec3 vec3 = blockPos1.m_7494_().m_252807_();
                    this.m_6034_(vec3.m_7096_(), this.m_20186_(), vec3.m_7094_());
                }
            }
        }
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && !this.isHallucination() && this.m_6084_()) {
            this.prevX = this.m_20185_();
            this.prevY = this.m_20186_();
            this.prevZ = this.m_20189_();
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(32) - 16);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    public boolean teleportNearTo(Entity p_32501_) {
        if (!this.f_19853_.m_5776_() && !this.isHallucination() && this.m_6084_()) {
            this.prevX = this.m_20185_();
            this.prevY = this.m_20186_();
            this.prevZ = this.m_20189_();
            Vec3 vec3 = new Vec3(this.m_20185_() - p_32501_.m_20185_(), this.m_20227_(0.5) - p_32501_.m_20188_(), this.m_20189_() - p_32501_.m_20189_());
            vec3 = vec3.m_82541_();
            double d0 = 16.0;
            double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * d0;
            double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * d0;
            double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * d0;
            return this.teleport(d1, d2, d3);
        }
        return false;
    }

    private boolean teleport(double pX, double pY, double pZ) {
        boolean flag1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean bl = flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_) && !this.m_6069_();
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (this.m_6069_() || this.m_5448_() != null && this.m_5448_().m_20069_()) {
                flag2 = MobUtil.randomWaterTeleport((LivingEntity)this, event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            }
            if (flag2) {
                if (this.m_5448_() != null && !this.isScreaming() && (double)this.m_5448_().m_20270_((Entity)this) >= 4.0 && this.spawnCool <= 0 && this.f_19853_.f_46441_.m_188501_() <= 0.25f) {
                    this.setSummoning(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)8);
                    this.m_5496_((SoundEvent)ModSounds.WIGHT_SUMMON.get(), 3.0f, 1.0f);
                    amount = 3 + this.f_19853_.f_46441_.m_188503_(1 + this.f_19853_.m_46791_().m_19028_());
                    for (j = 0; j < amount; ++j) {
                        CarrionMaggot carrionMaggot = new CarrionMaggot((EntityType<? extends CarrionMaggot>)((EntityType)ModEntityType.CARRION_MAGGOT.get()), this.f_19853_);
                        BlockPos blockPos = BlockFinder.SummonRadius(this.m_20183_(), (Entity)carrionMaggot, this.f_19853_);
                        carrionMaggot.setTrueOwner((LivingEntity)this);
                        carrionMaggot.setLimitedLife(MobUtil.getSummonLifespan(this.f_19853_));
                        carrionMaggot.m_20035_(blockPos, this.m_146908_(), this.m_146909_());
                        carrionMaggot.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                        DelayedSummon delayedSummon = new DelayedSummon(this.f_19853_, blockPos, (Entity)carrionMaggot, true, true, (LivingEntity)this);
                        delayedSummon.setLifeSpan(MathHelper.secondsToTicks(this.f_19796_.m_188503_(1 + j)));
                        this.f_19853_.m_7967_((Entity)delayedSummon);
                    }
                    this.spawnCool = MathHelper.secondsToTicks(10);
                } else if (this.f_19853_.f_46441_.m_188501_() <= 0.25f && this.hidingCooldown <= 0 || this.isScreaming()) {
                    this.setHide(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                    this.applyDarkness();
                } else if (this.f_19853_.f_46441_.m_188501_() <= 0.25f) {
                    this.applyDarkness();
                    if (this.f_19853_.f_46441_.m_188501_() <= 0.15f && this.m_5448_() != null) {
                        amount = 4 + this.f_19853_.f_46441_.m_188503_(1 + this.f_19853_.m_46791_().m_19028_());
                        for (j = 0; j < amount; ++j) {
                            Wight falseWight = new Wight((EntityType<? extends Owned>)((EntityType)ModEntityType.WIGHT.get()), this.f_19853_);
                            Vec3 vec31 = BlockFinder.SummonRadius(this.m_20183_(), (Entity)falseWight, this.f_19853_).m_252807_();
                            falseWight.setTrueOwner((LivingEntity)this);
                            falseWight.setLimitedLife(MathHelper.secondsToTicks(5 + this.f_19853_.f_46441_.m_188503_(10)));
                            falseWight.m_146884_(vec31);
                            double d2 = this.m_5448_().m_20185_() - falseWight.m_20185_();
                            double d1 = this.m_5448_().m_20189_() - falseWight.m_20189_();
                            falseWight.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                            float f = (float)Mth.m_14136_((double)d1, (double)d2);
                            float f2 = f + (float)j * (float)Math.PI * 0.25f + 4.0f;
                            vec31 = new Vec3(this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f2) * 4.0, this.m_5448_().m_20186_(), this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f2) * 4.0);
                            falseWight.m_146884_(vec31);
                            falseWight.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(BlockPos.m_274446_((Position)vec31)), MobSpawnType.MOB_SUMMONED, null, null);
                            falseWight.spawnHallucination();
                            falseWight.m_21153_(this.m_21223_());
                            this.f_19853_.m_7967_((Entity)falseWight);
                        }
                    }
                }
                Level j = this.f_19853_;
                if (j instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)j;
                    for (int i = 0; i < 16; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.prevX + (double)this.m_20205_() * (2.0 * this.f_19796_.m_188500_() - 1.0) * 0.5, this.prevY + (double)this.m_20206_() * this.f_19796_.m_188500_(), this.prevZ + (double)this.m_20205_() * (2.0 * this.f_19796_.m_188500_() - 1.0) * 0.5, 0, 0.0, 0.0, 0.0, 0.5);
                    }
                    serverLevel.m_8767_((ParticleOptions)new TeleportInShockwaveParticleOption(), this.prevX, this.prevY + 0.5, this.prevZ, 0, 0.0, 0.0, 0.0, 0.5);
                    if (!this.isHiding()) {
                        this.teleportHit(serverLevel);
                    }
                }
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_((Player)null, this.prevX, this.prevY, this.prevZ, (SoundEvent)ModSounds.WIGHT_TELEPORT.get(), this.m_5720_(), 1.0f, 0.5f);
                }
            }
            return flag2;
        }
        return false;
    }

    public void teleportHit(ServerLevel serverLevel) {
        for (int i = 0; i < 16; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, 0.0, 0.0, 0.0, 0.5);
        }
        serverLevel.m_8767_((ParticleOptions)new TeleportShockwaveParticleOption(10), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
        if (!this.m_20067_()) {
            this.m_5496_((SoundEvent)ModSounds.WIGHT_TELEPORT.get(), 1.0f, 0.5f);
        }
    }

    public double getAttackReachSqr(LivingEntity enemy) {
        return this.m_20205_() * 4.0f * this.m_20205_() * 4.0f + enemy.m_20205_();
    }

    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        double reach = this.getAttackReachSqr(enemy);
        return distToEnemySqr <= reach || this.m_20191_().m_82400_(1.0).m_82381_(enemy.m_20191_());
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        if (this.isHallucination()) {
            flag = this.doHurtTarget(0.5f, entityIn);
            if (flag) {
                if (entityIn instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entityIn;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
                }
                this.m_5496_((SoundEvent)ModSounds.WIGHT_SCREAM.get(), 1.0f, this.m_6100_());
                this.hallucinateVanish();
            }
        } else {
            flag = super.m_7327_(entityIn);
            if (flag && entityIn instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entityIn;
                if (entityIn instanceof Player) {
                    Player player = (Player)entityIn;
                    if (SEHelper.getSoulsAmount(player, (Integer)AttributesConfig.WightSoulAbsorb.get())) {
                        SEHelper.decreaseSouls(player, (Integer)AttributesConfig.WightSoulAbsorb.get());
                        this.regenHeal += ((Integer)AttributesConfig.WightSoulHeal.get()).intValue();
                    } else {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0, false, false));
                    }
                } else {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0, false, false));
                }
                living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CURSED.get(), 60, 0, false, false));
                if (this.isEasterEgg()) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0, false, false));
                }
            }
        }
        return flag;
    }

    public void upgradePower(int sePercent) {
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        AttributeInstance speed = this.m_21051_(Attributes.f_22279_);
        if (health != null && attack != null && speed != null && sePercent >= 15) {
            double h = 1.096;
            double a = 1.12;
            double d0 = 1.0;
            double d1 = 0.0;
            for (int i = 0; i < sePercent; ++i) {
                if (i <= 15) continue;
                if (i % 15 == 0) {
                    d0 += 0.1;
                }
                if (i % 30 != 0) continue;
                d1 += 0.05;
            }
            health.m_22100_((Double)AttributesConfig.WightHealth.get() * (h * d0));
            attack.m_22100_((Double)AttributesConfig.WightDamage.get() * (a * d0));
            speed.m_22100_(Math.min(0.45, 0.3 + d1));
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setHide(true);
        } else if (p_21375_ == 5) {
            this.setHide(false);
        } else if (p_21375_ == 6) {
            this.setHallucination(true);
        } else if (p_21375_ == 7) {
            this.setHallucination(false);
        } else if (p_21375_ == 8) {
            this.setSummoning(true);
        } else if (p_21375_ == 9) {
            this.setSummoning(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    @Nullable
    public static Wight findWight(Entity entity) {
        return Wight.findWight(entity, wight -> EntitySelector.f_20406_.test(entity) && !wight.m_5912_());
    }

    @Nullable
    public static Wight findWight(Entity entity, Predicate<Wight> predicate) {
        List wightList = entity.f_19853_.m_6443_(Wight.class, entity.m_20191_().m_82400_(64.0), predicate.and(wight -> !wight.isHallucination()));
        Wight wight2 = null;
        for (Wight wight1 : wightList) {
            if (wight1 == null) continue;
            wight2 = wight1;
        }
        return wight2;
    }

    static class WightAquaticNavigation
    extends WaterBoundPathNavigation {
        public WightAquaticNavigation(Mob entitylivingIn, Level worldIn) {
            super(entitylivingIn, worldIn);
        }

        protected PathFinder m_5532_(int p_179679_1_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.f_26508_, p_179679_1_);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected Vec3 m_7475_() {
            return new Vec3(this.f_26494_.m_20185_(), this.f_26494_.m_20227_(0.5), this.f_26494_.m_20189_());
        }

        protected boolean canMoveDirectly(Vec3 posVec31, Vec3 posVec32, int sizeX, int sizeY, int sizeZ) {
            Vec3 vector3d = new Vec3(posVec32.f_82479_, posVec32.f_82480_ + (double)this.f_26494_.m_20206_() * 0.5, posVec32.f_82481_);
            return this.f_26495_.m_45547_(new ClipContext(posVec31, vector3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.f_26494_)).m_6662_() == HitResult.Type.MISS;
        }

        public boolean m_6342_(BlockPos pos) {
            return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
        }
    }

    static class WightNavigation
    extends WallClimberNavigation {
        public WightNavigation(Mob p_33379_, Level p_33380_) {
            super(p_33379_, p_33380_);
        }

        @NotNull
        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new WightNodeEvaluator();
            this.f_26508_.m_77358_(true);
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, p_33382_);
        }
    }

    static class StarePlayerGoal
    extends Goal {
        protected final Mob mob;
        @Nullable
        protected Player lookAt;
        protected final float lookDistance;

        public StarePlayerGoal(Mob p_148118_, float p_148120_) {
            this.mob = p_148118_;
            this.lookDistance = p_148118_.m_21051_(Attributes.f_22277_) != null ? (float)p_148118_.m_21133_(Attributes.f_22277_) : p_148120_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_5448_() != null) {
                return false;
            }
            for (Player player : this.mob.f_19853_.m_6907_()) {
                if (this.lookAt != null || !EntitySelector.f_20406_.test(player) || MobUtil.areAllies((Entity)player, (Entity)this.mob) || !(player.m_20270_((Entity)this.mob) <= this.lookDistance)) continue;
                this.lookAt = player;
            }
            return this.lookAt != null;
        }

        public boolean m_8045_() {
            if (this.lookAt == null) {
                return false;
            }
            if (!this.lookAt.m_6084_()) {
                return false;
            }
            if (this.mob.m_20270_((Entity)this.lookAt) > this.lookDistance) {
                return false;
            }
            if (MobUtil.areAllies((Entity)this.mob, (Entity)this.lookAt)) {
                return false;
            }
            return EntitySelector.f_20406_.test(this.lookAt) && this.mob.m_5448_() == null;
        }

        public void m_8041_() {
            this.lookAt = null;
        }

        public void m_8037_() {
            if (this.lookAt != null && this.lookAt.m_6084_()) {
                if (this.mob.f_19853_.m_6907_().size() > 1) {
                    for (Player player2 : this.mob.f_19853_.m_6907_().stream().filter(player -> player != this.lookAt).toList()) {
                        if (!EntitySelector.f_20406_.test(player2) || MobUtil.areAllies((Entity)player2, (Entity)this.mob) || !(player2.m_20270_((Entity)this.mob) <= this.lookDistance) || SEHelper.getSoulAmountInt(player2) <= SEHelper.getSoulAmountInt(this.lookAt)) continue;
                        this.lookAt = player2;
                    }
                }
                this.mob.m_21573_().m_26573_();
                MobUtil.instaLook(this.mob, (Entity)this.lookAt);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)Wight.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return Wight.this.m_5448_() != null && Wight.this.m_5448_().m_6084_() && !Wight.this.isScreaming() && !Wight.this.isHiding();
        }

        public void m_8056_() {
            this.delayCounter = 0;
        }

        public void m_8041_() {
            Wight.this.setMeleeAttacking(false);
            Wight.this.attackTick = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = Wight.this.m_5448_();
            if (livingentity == null || Wight.this.isHiding() || Wight.this.isScreaming()) {
                return;
            }
            Wight.this.m_21563_().m_24960_((Entity)livingentity, (float)Wight.this.m_8085_(), (float)Wight.this.m_8132_());
            if (Wight.this.getCurrentAnimation() != Wight.this.getAnimationState(SUPER_SMASH)) {
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 10;
                    Wight.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
                }
            } else {
                Wight.this.m_21566_().m_24988_(0.0f, 0.0f);
                Wight.this.m_21573_().m_26573_();
            }
            this.m_6739_(livingentity, Wight.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (!Wight.this.isHiding()) {
                float chance;
                boolean smash = Wight.this.f_19796_.m_188499_();
                float f = chance = MobUtil.healthIsHalved((LivingEntity)Wight.this) ? 0.25f : 0.0f;
                if (!Wight.this.isMeleeAttacking() && Wight.this.targetClose(enemy, distToEnemySqr)) {
                    Wight.this.setMeleeAttacking(true);
                    float pitch = 0.0f;
                    if (Wight.this.f_19853_.m_213780_().m_188501_() <= chance && !Wight.this.isHallucination()) {
                        Wight.this.setAnimationState(SUPER_SMASH);
                        pitch = 0.5f;
                    } else if (smash) {
                        Wight.this.setAnimationState(SMASH);
                    } else {
                        Wight.this.setAnimationState(ATTACK);
                    }
                    Wight.this.m_5496_((SoundEvent)ModSounds.WIGHT_PRE_SWING.get(), Wight.this.m_6121_(), Wight.this.m_6100_() - pitch);
                }
                if (Wight.this.isMeleeAttacking()) {
                    float seconds;
                    float f2 = seconds = Wight.this.getCurrentAnimation() == Wight.this.getAnimationState(SUPER_SMASH) ? 2.05f : 1.7f;
                    if (Wight.this.attackTick < MathHelper.secondsToTicks(seconds)) {
                        Wight.this.m_5618_(Wight.this.m_6080_());
                        if (Wight.this.getCurrentAnimation() == Wight.this.getAnimationState(SUPER_SMASH)) {
                            if (Wight.this.attackTick == 24) {
                                Wight.this.m_5496_((SoundEvent)ModSounds.WIGHT_SWING.get(), Wight.this.m_6121_(), Wight.this.m_6100_() - 0.5f);
                                Difficulty difficulty = Wight.this.f_19853_.m_46791_();
                                int h = difficulty == Difficulty.HARD ? 8 : (difficulty == Difficulty.NORMAL ? 6 : 4);
                                for (int i = 0; i <= h; ++i) {
                                    AttackGoal.surroundTremor((LivingEntity)Wight.this, i, 3.0, 0.0f, false, 0.1f);
                                }
                                Wight.this.f_19853_.m_5594_(null, Wight.this.m_20183_(), (SoundEvent)ModSounds.WALL_ERUPT.get(), SoundSource.PLAYERS, 1.0f, 0.8f + Wight.this.f_19853_.f_46441_.m_188501_() * 0.4f);
                                Wight.this.f_19853_.m_5594_(null, Wight.this.m_20183_(), (SoundEvent)ModSounds.DIRT_DEBRIS.get(), SoundSource.PLAYERS, 1.0f, 0.8f + Wight.this.f_19853_.f_46441_.m_188501_() * 0.4f);
                                Wight.this.f_19853_.m_5594_(null, Wight.this.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.8f + Wight.this.f_19853_.f_46441_.m_188501_() * 0.4f);
                                if (Wight.this.targetClose(enemy, distToEnemySqr)) {
                                    Wight.this.m_7327_((Entity)enemy);
                                    if (enemy instanceof Player) {
                                        Player player = (Player)enemy;
                                        Wight.this.m_21424_(player, new ItemStack((ItemLike)Items.f_42386_), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                                    }
                                }
                            }
                        } else if (Wight.this.getCurrentAnimation() == Wight.this.getAnimationState(SMASH)) {
                            if (Wight.this.attackTick == 20) {
                                Wight.this.m_5496_((SoundEvent)ModSounds.WIGHT_SWING.get(), Wight.this.m_6121_(), Wight.this.m_6100_() - 0.5f);
                                if (Wight.this.targetClose(enemy, distToEnemySqr)) {
                                    Wight.this.m_7327_((Entity)enemy);
                                    if (enemy instanceof Player) {
                                        Player player = (Player)enemy;
                                        Wight.this.m_21424_(player, new ItemStack((ItemLike)Items.f_42428_), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                                    }
                                }
                            }
                        } else if (Wight.this.attackTick == 14) {
                            Wight.this.m_5496_((SoundEvent)ModSounds.WIGHT_SWING.get(), Wight.this.m_6121_(), Wight.this.m_6100_());
                            this.massiveSweep((LivingEntity)Wight.this, 3.0, 100.0);
                        }
                    } else {
                        Wight.this.setMeleeAttacking(false);
                        Wight.this.teleport();
                    }
                }
            } else {
                Wight.this.setMeleeAttacking(false);
            }
        }

        public void massiveSweep(LivingEntity source, double range, double arc) {
            List<LivingEntity> hits = MobUtil.getAttackableLivingEntitiesNearby(source, range, 1.0, range, range);
            for (LivingEntity target : hits) {
                float targetAngle = (float)((Math.atan2(target.m_20189_() - source.m_20189_(), target.m_20185_() - source.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float attackAngle = source.f_20883_ % 360.0f;
                if (targetAngle < 0.0f) {
                    targetAngle += 360.0f;
                }
                if (attackAngle < 0.0f) {
                    attackAngle += 360.0f;
                }
                float relativeAngle = targetAngle - attackAngle;
                float hitDistance = (float)Math.sqrt((target.m_20189_() - source.m_20189_()) * (target.m_20189_() - source.m_20189_()) + (target.m_20185_() - source.m_20185_()) * (target.m_20185_() - source.m_20185_())) - target.m_20205_() / 2.0f;
                if (!((double)hitDistance <= range && (double)relativeAngle <= arc / 2.0 && (double)relativeAngle >= -arc / 2.0 || (double)relativeAngle >= 360.0 - arc / 2.0) && !((double)relativeAngle <= -360.0 + arc / 2.0)) continue;
                Wight.this.m_7327_((Entity)target);
            }
        }

        public static void surroundTremor(LivingEntity livingEntity, int distance, double topY, float side, boolean grab, float airborne) {
            int hitY = Mth.m_14107_((double)(livingEntity.m_20191_().f_82289_ - 0.5));
            double spread = Math.PI * 2;
            int arcLen = Mth.m_14165_((double)((double)distance * spread));
            double minY = livingEntity.m_20186_() - 1.0;
            double maxY = livingEntity.m_20186_() + topY;
            for (int i = 0; i < arcLen; ++i) {
                double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread;
                double vx = Math.cos(theta);
                double vz = Math.sin(theta);
                double px = livingEntity.m_20185_() + vx * (double)distance + (double)side * Math.cos((double)(livingEntity.f_20883_ + 90.0f) * Math.PI / 180.0);
                double pz = livingEntity.m_20189_() + vz * (double)distance + (double)side * Math.sin((double)(livingEntity.f_20883_ + 90.0f) * Math.PI / 180.0);
                float factor = 1.0f - (float)distance / 12.0f;
                int hitX = Mth.m_14107_((double)px);
                int hitZ = Mth.m_14107_((double)pz);
                BlockPos blockPos = new BlockPos(hitX, hitY, hitZ);
                BlockState blockState = livingEntity.f_19853_.m_8055_(blockPos);
                while (blockState.m_60799_() != RenderShape.MODEL) {
                    blockPos = blockPos.m_7495_();
                    blockState = livingEntity.f_19853_.m_8055_(blockPos);
                }
                BlockState blockAbove = livingEntity.f_19853_.m_8055_(blockPos.m_7494_());
                if (blockState != Blocks.f_50016_.m_49966_() && !blockState.m_155947_() && !blockAbove.m_280555_()) {
                    ModFallingBlock fallingBlock = new ModFallingBlock(livingEntity.f_19853_, Vec3.m_82512_((Vec3i)blockPos.m_7494_()), blockState, (float)(0.2 + livingEntity.m_217043_().m_188583_() * 0.15));
                    livingEntity.f_19853_.m_7967_((Entity)fallingBlock);
                }
                AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
                List entities = livingEntity.f_19853_.m_45976_(LivingEntity.class, selection);
                for (LivingEntity target : entities) {
                    boolean flag;
                    if (MobUtil.areAllies((Entity)target, (Entity)livingEntity) || target == livingEntity || !(flag = livingEntity.m_7327_((Entity)target))) continue;
                    if (grab) {
                        double magnitude = -4.0;
                        double x = vx * (double)(1.0f - factor) * magnitude;
                        double y = 0.0;
                        if (target.m_20096_()) {
                            y += 0.15;
                        }
                        double z = vz * (double)(1.0f - factor) * magnitude;
                        MobUtil.push((Entity)target, x, y, z);
                        continue;
                    }
                    MobUtil.push((Entity)target, 0.0, (double)(airborne * (float)distance) + livingEntity.m_217043_().m_188500_() * 0.15, 0.0);
                }
            }
        }
    }

    static class WightLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final Wight wight;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_26893_().m_148355_();

        public WightLookForPlayerGoal(Wight wight, @Nullable Predicate<LivingEntity> predicate) {
            super((Mob)wight, Player.class, 10, false, false, predicate);
            this.wight = wight;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(livingEntity -> (MobUtil.isDirectlyLooking(livingEntity, (LivingEntity)this.wight) || wight.m_19950_((Entity)livingEntity, 4.0) || wight.m_5448_() == livingEntity) && !MobUtil.areAllies((Entity)wight, (Entity)livingEntity));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.wight.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.wight);
            return this.pendingTarget != null && !this.wight.isHallucination();
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.wight.setScreaming(true);
            if (this.pendingTarget != null) {
                Player player;
                this.pendingTarget.m_5496_((SoundEvent)ModSounds.WIGHT_SCREAM.get(), 3.0f, 0.5f);
                if (!this.wight.f_19853_.f_46443_ && (player = this.pendingTarget) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModNetwork.sendToClient(serverPlayer, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.WIGHT_SCREAM.get(), 3.0f, 0.5f));
                }
                MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, MathHelper.secondsToTicks(6), 0, false, false);
                this.pendingTarget.m_7292_(mobeffectinstance);
            }
            this.wight.m_5496_((SoundEvent)ModSounds.WIGHT_SCREAM.get(), 3.0f, 0.5f);
            this.teleportTime = 0;
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                this.wight.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.wight, this.f_26050_) || super.m_8045_();
        }

        public void m_8037_() {
            if (this.wight.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (!(this.f_26050_ == null || this.wight.m_20159_() || this.wight.isMeleeAttacking() || !(this.f_26050_.m_20280_((Entity)this.wight) > 256.0) && this.wight.m_142582_((Entity)this.f_26050_) || this.teleportTime++ < this.m_183277_(MathHelper.secondsToTicks(3.5f)) || !this.wight.teleportNearTo((Entity)this.f_26050_))) {
                    this.teleportTime = 0;
                }
                super.m_8037_();
            }
        }
    }

    static class WightNodeEvaluator
    extends WalkNodeEvaluator {
        WightNodeEvaluator() {
        }

        public void m_6028_(PathNavigationRegion region, Mob mob) {
            super.m_6028_(region, mob);
            this.f_77315_ = Mth.m_14143_((float)(mob.m_20205_() + 1.0f));
            this.f_77316_ = Mth.m_14143_((float)1.0f);
            this.f_77317_ = Mth.m_14143_((float)(mob.m_20205_() + 1.0f));
        }
    }
}

