/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModLootTables;
import com.Polarice3.Goety.utils.WitchBarterHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Maverick
extends Cultist {
    private static final UUID SPEED_MODIFIER_DRINKING_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_UUID, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM = SynchedEntityData.m_135353_(Maverick.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int usingTime;
    private int fleeTime;

    public Maverick(EntityType<? extends Cultist> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MaverickBarterGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.2){

            public boolean m_8036_() {
                return Maverick.this.fleeTime > 0 && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableWitchTargetGoal<Player>((Raider)this, Player.class, 10, true, false, null){
            private int unseenTicks;

            public boolean m_8045_() {
                LivingEntity mobTarget = this.f_26135_.m_5448_();
                if (mobTarget == null) {
                    mobTarget = this.f_26137_;
                }
                if (mobTarget == null) {
                    return false;
                }
                if (!this.f_26135_.m_6779_(mobTarget)) {
                    return false;
                }
                Team team = this.f_26135_.m_5647_();
                Team team1 = mobTarget.m_5647_();
                if (team != null && team1 == team) {
                    return false;
                }
                double d0 = this.m_7623_() * 2.0;
                if (this.f_26135_.m_20280_((Entity)mobTarget) > d0 * d0) {
                    return false;
                }
                if (this.f_26136_) {
                    if (this.f_26135_.m_21574_().m_148306_((Entity)mobTarget)) {
                        this.unseenTicks = 0;
                    } else if (++this.unseenTicks > 2.m_186073_((int)this.f_26138_)) {
                        return false;
                    }
                }
                this.f_26135_.m_6710_(mobTarget);
                return true;
            }

            public void m_8056_() {
                super.m_8056_();
                this.unseenTicks = 0;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.MaverickHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.MaverickArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.MaverickDamage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.MaverickHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.MaverickArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.MaverickDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_USING_ITEM, (Object)false);
    }

    public void setUsingItem(boolean p_34164_) {
        this.m_20088_().m_135381_(DATA_USING_ITEM, (Object)p_34164_);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.m_20088_().m_135370_(DATA_USING_ITEM);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MAVERICK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)ModSounds.MAVERICK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MAVERICK_DEATH.get();
    }

    @Override
    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.MAVERICK_CELEBRATE.get();
    }

    protected SoundEvent m_7838_(ItemStack p_35865_) {
        return p_35865_.m_150930_(Items.f_42455_) ? SoundEvents.f_12585_ : SoundEvents.f_12586_;
    }

    public boolean hasHarmfulEffect() {
        return this.m_21220_().stream().anyMatch(instance -> instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && instance.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_)) && instance.m_19557_() > 100);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        SpawnGroupData spawnGroupData = super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        this.m_213945_(p_37856_.m_213780_(), p_37857_);
        return spawnGroupData;
    }

    protected void m_213945_(RandomSource p_217055_, DifficultyInstance p_217056_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
    }

    @Override
    public Cultist.CultistArmPose getArmPose() {
        if (this.isDrinkingPotion() || WitchBarterHelper.getTrader(this) != null) {
            return Cultist.CultistArmPose.ITEM;
        }
        if (this.m_5912_()) {
            return Cultist.CultistArmPose.ATTACKING;
        }
        if (this.m_37888_()) {
            return Cultist.CultistArmPose.SPELLCASTING;
        }
        return Cultist.CultistArmPose.NEUTRAL;
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            this.m_21561_(this.m_5448_() != null);
            if (this.fleeTime > 0) {
                --this.fleeTime;
            }
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (this.isDrinkingPotion()) {
                int i = this.usingTime;
                if (i % 4 == 0 && !this.m_20067_()) {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7838_(this.m_21206_()), this.m_5720_(), 0.5f, this.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
                }
                if (this.usingTime-- <= 0) {
                    this.setUsingItem(false);
                    ItemStack itemstack = this.m_21206_();
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    if (itemstack.m_150930_(Items.f_42589_)) {
                        List list = PotionUtils.m_43547_((ItemStack)itemstack);
                        if (!list.isEmpty()) {
                            for (MobEffectInstance mobeffectinstance : list) {
                                this.m_7292_(new MobEffectInstance(mobeffectinstance));
                            }
                        }
                    } else if (itemstack.m_150930_(Items.f_42455_)) {
                        this.curePotionEffects(itemstack);
                    }
                    if (attributeinstance != null) {
                        attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                    }
                }
            } else {
                Potion potion = null;
                ItemStack milk = ItemStack.f_41583_;
                if (this.f_19796_.m_188501_() < 0.15f && this.hasHarmfulEffect()) {
                    milk = new ItemStack((ItemLike)Items.f_42455_);
                } else if (this.f_19796_.m_188501_() < 0.15f && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.m_21023_(MobEffects.f_19608_)) {
                    potion = Potions.f_43621_;
                } else if (this.f_19796_.m_188501_() < 0.15f && (this.m_6060_() || this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
                    potion = Potions.f_43610_;
                } else if (this.f_19796_.m_188501_() < 0.05f && this.m_21223_() < this.m_21233_() && (this.m_5448_() == null || (double)this.m_5448_().m_20270_((Entity)this) >= 8.0)) {
                    potion = !this.m_21023_(MobEffects.f_19609_) && !this.m_20145_() && this.f_19853_.m_6443_(Maverick.class, this.m_20191_().m_82400_(8.0), maverick -> MobUtil.areAllies((Entity)this, (Entity)maverick) && maverick.m_20145_()).size() <= 2 ? Potions.f_43605_ : (this.f_19796_.m_188501_() <= 0.25f && !this.m_21023_(MobEffects.f_19605_) ? Potions.f_43587_ : Potions.f_43623_);
                } else if (this.f_19796_.m_188501_() < 0.5f && this.m_5448_() != null && !this.m_21023_(MobEffects.f_19596_) && this.m_5448_().m_20280_((Entity)this) > 121.0) {
                    potion = Potions.f_43612_;
                }
                ItemStack itemStack = ItemStack.f_41583_;
                if (potion != null || !milk.m_41619_()) {
                    if (!milk.m_41619_()) {
                        itemStack = milk;
                    } else if (potion != null) {
                        itemStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
                    }
                }
                if (!itemStack.m_41619_()) {
                    this.m_8061_(EquipmentSlot.OFFHAND, itemStack);
                    this.usingTime = this.m_21206_().m_41779_();
                    this.setUsingItem(true);
                    if (attributeinstance != null) {
                        attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                        attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
                    }
                }
            }
        }
        if (this.f_19796_.m_188501_() < 7.5E-4f) {
            this.f_19853_.m_7605_((Entity)this, (byte)15);
        }
        super.m_8107_();
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean flag = super.m_6469_(pSource, pAmount);
        if (flag && this.m_21223_() <= this.m_21233_() / 2.0f && this.fleeTime <= 0) {
            this.fleeTime = MathHelper.secondsToTicks(1);
        }
        return flag;
    }

    public boolean m_7327_(Entity target) {
        boolean flag = false;
        Potion potion = Potions.f_43582_;
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (!livingEntity.m_21023_(MobEffects.f_19597_) && !livingEntity.m_21023_(MobEffects.f_19597_) && livingEntity.m_7301_(new MobEffectInstance(MobEffects.f_19597_))) {
                potion = Potions.f_43615_;
            } else if (livingEntity.m_21223_() >= 8.0f && !livingEntity.m_21023_(MobEffects.f_19614_) && livingEntity.m_7301_(new MobEffectInstance(MobEffects.f_19614_))) {
                potion = Potions.f_43584_;
            } else if (!livingEntity.m_21023_(MobEffects.f_19613_) && !livingEntity.m_21023_(MobEffects.f_19613_) && this.f_19796_.m_188501_() < 0.25f && livingEntity.m_7301_(new MobEffectInstance(MobEffects.f_19613_))) {
                potion = Potions.f_43593_;
            } else if (livingEntity.m_21222_()) {
                potion = Potions.f_43623_;
            }
            ArrayList<MobEffectInstance> instants = new ArrayList<MobEffectInstance>();
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            for (Object instance : potion.m_43488_()) {
                if (instance.m_19544_().m_8093_()) {
                    instants.add((MobEffectInstance)instance);
                    continue;
                }
                effects.add((MobEffectInstance)instance);
            }
            if (!effects.isEmpty() || !instants.isEmpty()) {
                boolean hurt = !instants.isEmpty() ? !livingEntity.m_21275_(this.m_269291_().m_269333_((LivingEntity)this)) && !this.m_20145_() : (this.m_20145_() ? MobUtil.doHurtTarget((Mob)this, (Entity)livingEntity, this.m_269291_().m_269104_((Entity)this, (Entity)this)) : super.m_7327_((Entity)livingEntity));
                if (hurt) {
                    if (!effects.isEmpty()) {
                        for (MobEffectInstance instance : effects) {
                            livingEntity.m_7292_(new MobEffectInstance(instance));
                        }
                    }
                    if (!instants.isEmpty()) {
                        for (MobEffectInstance instance : instants) {
                            instance.m_19544_().m_19461_((Entity)this, (Entity)this, livingEntity, instance.m_19564_(), 1.0);
                        }
                    }
                } else if (livingEntity.m_21254_()) {
                    super.m_7327_((Entity)livingEntity);
                }
                flag = true;
            }
            if (flag) {
                if (this.m_21023_(MobEffects.f_19609_)) {
                    Object instance;
                    this.m_21195_(MobEffects.f_19609_);
                    instance = this.f_19853_;
                    if (instance instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)instance;
                        for (int i = 0; i < 8; ++i) {
                            ColorUtil colorUtil = new ColorUtil(4073788);
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_CULT_SPELL.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 0.5);
                        }
                    }
                }
                if (!livingEntity.m_20142_() && this.fleeTime <= 0) {
                    this.fleeTime = MathHelper.secondsToTicks(1);
                }
            }
        }
        return flag;
    }

    protected float m_6515_(DamageSource damageSource, float damage) {
        damage = super.m_6515_(damageSource, damage);
        if (damageSource.m_7639_() == this) {
            damage = 0.0f;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268731_)) {
            damage *= 0.15f;
        }
        return damage;
    }

    public void m_7822_(byte p_34138_) {
        if (p_34138_ == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + 0.5 + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(p_34138_);
        }
    }

    public static class MaverickBarterGoal
    extends Goal {
        private int progress = 100;
        public Maverick maverick;

        public MaverickBarterGoal(Maverick maverick) {
            this.maverick = maverick;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8037_() {
            this.maverick.m_6710_(null);
            LivingEntity trader = WitchBarterHelper.getTrader(this.maverick);
            if (--this.progress > 0) {
                this.maverick.m_21573_().m_26573_();
                if (trader != null && this.maverick.m_20270_((Entity)trader) <= 16.0f) {
                    this.maverick.m_21563_().m_148051_((Entity)trader);
                }
            }
            if (this.progress <= 0) {
                Vec3 vec3;
                Vec3 vec32 = vec3 = trader != null ? trader.m_20182_() : this.maverick.m_20182_();
                if (!this.maverick.f_19853_.f_46443_ && this.maverick.f_19853_.m_7654_() != null) {
                    float luck = 0.0f;
                    if (this.maverick.m_21206_().m_204117_(ModTags.Items.WITCH_BETTER_CURRENCY)) {
                        luck = 1.0f;
                    }
                    LootTable loottable = this.maverick.f_19853_.m_7654_().m_278653_().m_278676_(ModLootTables.MAVERICK_BARTER);
                    ObjectArrayList list = loottable.m_287195_(new LootParams.Builder((ServerLevel)this.maverick.f_19853_).m_287286_(LootContextParams.f_81455_, (Object)this.maverick).m_287286_(LootContextParams.f_81460_, (Object)this.maverick.m_20182_()).m_287239_(luck).m_287235_(LootContextParamSets.f_81416_));
                    for (ItemStack itemstack : list) {
                        BehaviorUtils.m_22613_((LivingEntity)this.maverick, (ItemStack)itemstack, (Vec3)vec3.m_82520_(0.0, 1.0, 0.0));
                    }
                }
                this.clearTrade();
            }
            if (this.maverick.f_20916_ != 0 && (this.maverick.m_21120_(InteractionHand.OFF_HAND).m_204117_(ModTags.Items.WITCH_CURRENCY) || this.maverick.m_21120_(InteractionHand.OFF_HAND).m_204117_(ModTags.Items.WITCH_BETTER_CURRENCY))) {
                this.maverick.m_19983_(this.maverick.m_21120_(InteractionHand.OFF_HAND));
                this.clearTrade();
            }
        }

        protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
            if (!this.maverick.f_19853_.f_46443_) {
                ServerLevel serverLevel = (ServerLevel)this.maverick.f_19853_;
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.maverick.m_217043_().m_188583_() * 0.02;
                    double d1 = this.maverick.m_217043_().m_188583_() * 0.02;
                    double d2 = this.maverick.m_217043_().m_188583_() * 0.02;
                    serverLevel.m_8767_(p_35288_, this.maverick.m_20208_(1.0), this.maverick.m_20187_() + 1.0, this.maverick.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
        }

        public boolean m_8036_() {
            return this.maverick.m_21206_().m_204117_(ModTags.Items.WITCH_CURRENCY) || this.maverick.m_21206_().m_204117_(ModTags.Items.WITCH_BETTER_CURRENCY);
        }

        public void m_8056_() {
            super.m_8056_();
            this.progress = 100;
            WitchBarterHelper.setTimer(this.maverick, 5);
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        }

        public void clearTrade() {
            this.maverick.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            WitchBarterHelper.setTimer(this.maverick, 5);
            WitchBarterHelper.setTrader(this.maverick, null);
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

