/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.GlacialWall;
import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IceChunk
extends SpellEntity {
    private final int distance = 4;
    private boolean isDropping;
    public int hovering = 0;

    public IceChunk(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public IceChunk(Level pLevel, LivingEntity pOwner, LivingEntity pTarget) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.ICE_CHUNK.get()), pLevel);
        if (pTarget != null) {
            this.m_6034_(pTarget.m_20185_(), pTarget.m_20186_() + 4.0, pTarget.m_20189_());
        }
        this.setOwner(pOwner);
        if (!MobUtil.areAllies((Entity)pOwner, (Entity)pTarget)) {
            this.setTarget(pTarget);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.hovering = pCompound.m_128451_("hovering");
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("hovering", this.hovering);
    }

    private void onHit(HitResult hitResult) {
        if (!this.f_19853_.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            BlockState blockState = Blocks.f_50354_.m_49966_();
            double y = this.m_20186_();
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                Entity entity = entityHitResult.m_82443_();
                y = entity.m_20186_();
            }
            this.m_5496_((SoundEvent)ModSounds.ICE_CHUNK_HIT.get(), 2.0f, 1.0f);
            serverWorld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.m_20185_(), y + (double)this.m_20206_() / 2.0, this.m_20189_(), 256, (double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0, 1.0);
            ColorUtil colorUtil = new ColorUtil(0xFFFEFF);
            serverWorld.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 4.0f, 1), this.m_20185_(), y, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.5);
            int i = 0;
            while ((float)i < 8.0f) {
                this.setParticleAura((ParticleOptions)ParticleTypes.f_123759_, 1.0f, this.m_20185_(), y, this.m_20189_());
                ++i;
            }
            if (this.isDropping) {
                for (LivingEntity livingEntity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 1.0, 2.0), this::canHitEntity)) {
                    this.damageTargets(livingEntity);
                }
            }
        }
        this.m_146870_();
    }

    public void damageTargets(LivingEntity livingEntity) {
        float damage = ((Double)SpellConfig.IceChunkDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (livingEntity != null && livingEntity.m_6469_(ModDamageSource.indirectFreeze(this, (Entity)this.m_269323_()), damage += this.getExtraDamage())) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.STUNNED.get(), MathHelper.secondsToTicks(2)));
        }
    }

    public void setParticleAura(ParticleOptions particleAura, float radius, double pX, double pY, double pZ) {
        if (!this.f_19853_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            float f5 = (float)Math.PI * radius * radius;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * radius;
                float f8 = Mth.m_14089_((float)f6) * f7;
                float f9 = Mth.m_14031_((float)f6) * f7;
                serverWorld.m_8767_(particleAura, pX + (double)f8, pY, pZ + (double)f9, 1, 0.0, 0.0, 0.0, 0.0);
                ++k1;
            }
        }
    }

    @Override
    public void m_8119_() {
        double d2;
        double d1;
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            ++this.hovering;
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            HitResult result = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            if (result.m_6662_() != HitResult.Type.MISS) {
                EntityHitResult result1;
                if (result.m_6662_() == HitResult.Type.ENTITY && (result1 = (EntityHitResult)result).m_82443_() instanceof LivingEntity) {
                    this.damageTargets((LivingEntity)result1.m_82443_());
                }
                this.onHit(result);
            }
            if (this.m_20096_() || this.m_5830_() || this.f_19863_ || this.f_19862_) {
                this.onHit(result);
            }
            if (!this.isStarting()) {
                if (!this.isDropping) {
                    this.setParticleAura((ParticleOptions)ParticleTypes.f_123796_, 1.5f, this.m_20185_(), this.m_20186_(), this.m_20189_());
                }
                BlockPos blockpos = this.m_20183_().m_7495_();
                BlockState blockState = Blocks.f_50127_.m_49966_();
                if (serverWorld.m_46859_(blockpos)) {
                    this.setParticleAura((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, blockState), 1.5f, this.m_20185_(), this.m_20186_(), this.m_20189_());
                }
            }
            if (this.hovering == 20) {
                for (int k = 0; k < 60; ++k) {
                    float f2 = this.f_19796_.m_188501_() * 4.0f;
                    float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    d1 = Mth.m_14089_((float)f1) * f2;
                    d2 = 0.01 + this.f_19796_.m_188500_() * 0.5;
                    double d3 = Mth.m_14031_((float)f1) * f2;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.25);
                }
            }
        } else {
            ++this.hovering;
        }
        if (this.hovering == 1 && !this.m_5830_() && !this.m_20096_()) {
            this.m_5496_((SoundEvent)ModSounds.ICE_CHUNK_IDLE.get(), 1.0f, 1.0f);
        }
        int hoverTime = MathHelper.secondsToTicks(5);
        if (this.isStaff()) {
            hoverTime = MathHelper.secondsToTicks(2.75f);
        }
        boolean isHovering = !this.isStarting() && this.hovering < hoverTime;
        boolean bl = this.isDropping = this.hovering > hoverTime;
        if (this.hovering == hoverTime - 15) {
            this.m_5496_((SoundEvent)ModSounds.ICE_CHUNK_DROP.get(), 1.0f, 1.0f);
        }
        if (isHovering) {
            float speed = 0.175f;
            if (this.getTarget() != null && this.getTarget().m_6084_()) {
                this.m_20256_(Vec3.f_82478_);
                double d0 = this.getTarget().m_20185_() - this.m_20185_();
                d1 = this.getTarget().m_20186_() + (double)this.distance - this.m_20186_();
                d2 = this.getTarget().m_20189_() - this.m_20189_();
                double d = Math.sqrt(d0 * d0 + d2 * d2);
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                if (d > 0.5) {
                    this.m_20256_(this.m_20184_().m_82520_(d0 / d3, d1 / d3, d2 / d3).m_82490_((double)speed));
                }
            }
        } else if (!this.isDropping) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.25, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public boolean isStarting() {
        return this.hovering < 20;
    }

    public boolean m_6097_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_7337_(Entity p_20303_) {
        return super.m_7337_(p_20303_) && !(p_20303_ instanceof GlacialWall);
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && !entity.f_19794_ && !(entity instanceof IceChunk)) {
            LivingEntity owner = this.m_269323_();
            return owner == null || !owner.m_20365_(entity) && !MobUtil.areAllies((Entity)owner, entity);
        }
        return false;
    }
}

