/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class ScytheSlash
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(ScytheSlash.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/projectiles/scythe/scythe_0.png"));
        map.put(1, Goety.location("textures/entity/projectiles/scythe/scythe_1.png"));
        map.put(2, Goety.location("textures/entity/projectiles/scythe/scythe_2.png"));
        map.put(3, Goety.location("textures/entity/projectiles/scythe/scythe_3.png"));
        map.put(4, Goety.location("textures/entity/projectiles/scythe/scythe_4.png"));
        map.put(5, Goety.location("textures/entity/projectiles/scythe/scythe_5.png"));
        map.put(6, Goety.location("textures/entity/projectiles/scythe/scythe_6.png"));
        map.put(7, Goety.location("textures/entity/projectiles/scythe/scythe_7.png"));
    });
    private ItemStack weapon = new ItemStack((ItemLike)ModItems.DEATH_SCYTHE.get());
    private float damage;
    private int lifespan;
    private int totalLife;

    public ScytheSlash(EntityType<? extends AbstractHurtingProjectile> p_i50173_1_, Level p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
        this.damage = 7.5f;
        this.lifespan = 0;
        this.totalLife = 60;
    }

    public ScytheSlash(ItemStack itemStack, Level world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super((EntityType)ModEntityType.SCYTHE.get(), x, y, z, xSpeed, ySpeed, zSpeed, world);
        this.weapon = itemStack;
    }

    public ScytheSlash(Level world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super((EntityType)ModEntityType.SCYTHE.get(), x, y, z, xSpeed, ySpeed, zSpeed, world);
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getAnimation(), TEXTURE_BY_TYPE.get(0));
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getTotalLife() {
        return this.totalLife;
    }

    public void setTotalLife(int totalLife) {
        this.totalLife = totalLife;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAnimation(compound.m_128451_("Animation"));
        if (compound.m_128441_("Damage")) {
            this.setLifespan(compound.m_128451_("Damage"));
        }
        if (compound.m_128441_("Lifespan")) {
            this.setLifespan(compound.m_128451_("Lifespan"));
        }
        if (compound.m_128441_("TotalLife")) {
            this.setTotalLife(compound.m_128451_("TotalLife"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Animation", this.getAnimation());
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128405_("Lifespan", this.getLifespan());
        compound.m_128405_("TotalLife", this.getTotalLife());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lifespan < this.getTotalLife()) {
            ++this.lifespan;
        } else {
            this.m_146870_();
        }
        if (this.getAnimation() < 7) {
            this.setAnimation(this.getAnimation() + 1);
        } else {
            this.setAnimation(0);
        }
        if (((Boolean)ItemConfig.ScytheSlashBreaks.get()).booleanValue()) {
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (!blockstate.m_204336_(BlockTags.f_144281_) && !BlockFinder.isScytheBreak(blockstate)) continue;
                ItemStack itemStack = this.weapon;
                if (this.weapon == null || this.weapon.m_41619_()) {
                    itemStack = new ItemStack((ItemLike)ModItems.DEATH_SCYTHE.get());
                }
                BlockFinder.breakBlock(this.f_19853_, blockpos, itemStack, (Entity)this);
            }
        }
        if (!this.f_19853_.f_46443_) {
            ArrayList<Entity> targets = new ArrayList<Entity>();
            for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82400_(0.5))) {
                if (this.m_19749_() != null) {
                    if (entity == this.m_19749_() || MobUtil.areAllies(entity, this.m_19749_()) || entity == this.m_19749_().m_20202_()) continue;
                    targets.add(entity);
                    continue;
                }
                targets.add(entity);
            }
            if (!targets.isEmpty()) {
                for (Entity entity : targets) {
                    if (!MobUtil.validEntity(entity)) continue;
                    float f = this.getDamage();
                    if (this.m_19749_() != null) {
                        DamageSource damageSource;
                        Entity entity2;
                        if (entity instanceof LivingEntity) {
                            f += EnchantmentHelper.m_44833_((ItemStack)this.weapon, (MobType)((LivingEntity)entity).m_6336_());
                        }
                        if ((entity2 = this.m_19749_()) instanceof Player) {
                            Player player = (Player)entity2;
                            boolean attack = entity.m_6469_(entity.m_269291_().m_269075_(player), f);
                            if (entity instanceof EnderDragon) {
                                EnderDragon enderDragonEntity = (EnderDragon)entity;
                                attack = enderDragonEntity.m_6469_(entity.m_269291_().m_269075_(player), f);
                            }
                            if (!attack || !(entity instanceof LivingEntity)) continue;
                            int enchantment = this.weapon.getEnchantmentLevel((Enchantment)ModEnchantments.SOUL_EATER.get());
                            int soulEater = Mth.m_14045_((int)(enchantment + 1), (int)1, (int)10);
                            SEHelper.increaseSouls(player, (Integer)ItemConfig.DarkScytheSouls.get() * soulEater);
                            continue;
                        }
                        Entity entity3 = this.m_19749_();
                        if (entity3 instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity3;
                            damageSource = entity.m_269291_().m_269333_(livingEntity);
                        } else {
                            damageSource = entity.m_269291_().m_269390_((Entity)this, (Entity)this);
                        }
                        DamageSource damageSource2 = damageSource;
                        entity.m_6469_(damageSource2, f);
                        continue;
                    }
                    entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, (Entity)this), f);
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        this.m_146870_();
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123797_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

