/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.vehicle;

import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.utils.MobUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class PioneerRock
extends SpellEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(PioneerRock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(PioneerRock.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;

    public PioneerRock(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19850_ = true;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_7337_(Entity p_38376_) {
        return PioneerRock.canVehicleCollide(this, p_38376_);
    }

    public static boolean canVehicleCollide(Entity p_38324_, Entity p_38325_) {
        return (p_38325_.m_5829_() || p_38325_.m_6094_()) && !p_38324_.m_20365_(p_38325_);
    }

    public boolean m_5829_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis p_38335_, BlockUtil.FoundRectangle p_38336_) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(p_38335_, p_38336_));
    }

    public void m_7334_(Entity p_38373_) {
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6469_(DamageSource p_38319_, float p_38320_) {
        if (this.m_6673_(p_38319_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_38320_ * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, p_38319_.m_7639_());
            boolean bl = flag = p_38319_.m_7639_() instanceof Player && ((Player)p_38319_.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public void m_6453_(double p_38299_, double p_38300_, double p_38301_, float p_38302_, float p_38303_, int p_38304_, boolean p_38305_) {
        this.lerpX = p_38299_;
        this.lerpY = p_38300_;
        this.lerpZ = p_38301_;
        this.lerpYRot = p_38302_;
        this.lerpXRot = p_38303_;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    @Override
    public void m_8119_() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        if (this.m_6109_()) {
            if (this.m_9236_().f_46443_) {
                this.controlBoat();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_20101_();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    private void controlBoat() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            if (this.inputUp) {
                f += 0.04f;
            }
            if (this.inputDown) {
                f -= 0.005f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
        }
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public boolean hasEnoughSpaceFor(Entity p_273171_) {
        return p_273171_.m_20205_() < this.m_20205_();
    }

    protected void m_19956_(Entity p_289552_, Entity.MoveFunction p_289571_) {
        if (this.m_20363_(p_289552_)) {
            float f = this.getSinglePassengerXOffset();
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + p_289552_.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(p_289552_);
                f = i == 0 ? 0.2f : -0.6f;
                if (p_289552_ instanceof Animal) {
                    f += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            p_289571_.m_20372_(p_289552_, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            p_289552_.m_146922_(p_289552_.m_146908_() + this.deltaRotation);
            p_289552_.m_5616_(p_289552_.m_6080_() + this.deltaRotation);
            this.clampRotation(p_289552_);
            if (p_289552_ instanceof Animal && this.m_20197_().size() == this.getMaxPassengers()) {
                int j = p_289552_.m_19879_() % 2 == 0 ? 90 : 270;
                p_289552_.m_5618_(((Animal)p_289552_).f_20883_ + (float)j);
                p_289552_.m_5616_(p_289552_.m_6080_() + (float)j);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity p_38357_) {
        Vec3 vec3 = PioneerRock.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)p_38357_.m_20205_(), (float)p_38357_.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)this.m_20191_().f_82292_, (double)d1);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.m_9236_().m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.m_9236_().m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : p_38357_.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec31, (LivingEntity)p_38357_, (Pose)pose)) continue;
                    p_38357_.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(p_38357_);
    }

    protected void clampRotation(Entity p_38322_) {
        p_38322_.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(p_38322_.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        p_38322_.f_19859_ += f1 - f;
        p_38322_.m_146922_(p_38322_.m_146908_() + f1 - f);
        p_38322_.m_5616_(p_38322_.m_146908_());
    }

    public void m_7340_(Entity p_38383_) {
        this.clampRotation(p_38383_);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6096_(Player p_38330_, InteractionHand p_38331_) {
        if (p_38330_.m_36341_()) return InteractionResult.PASS;
        if (this.m_9236_().f_46443_) return InteractionResult.SUCCESS;
        if (this.m_269323_() == null) return p_38330_.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        if (this.m_269323_() != p_38330_ && !MobUtil.areAllies((Entity)this.m_269323_(), (Entity)p_38330_) || !p_38330_.m_20329_((Entity)this)) return InteractionResult.PASS;
        return InteractionResult.CONSUME;
    }

    public void setDamage(float p_38312_) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(p_38312_));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int p_38355_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_38355_);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    protected boolean m_7310_(Entity p_38390_) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        return 2;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingentity;
        Entity entity = this.m_146895_();
        LivingEntity livingentity1 = entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null;
        return livingentity1;
    }

    public void setInput(boolean p_38343_, boolean p_38344_, boolean p_38345_, boolean p_38346_) {
        this.inputLeft = p_38343_;
        this.inputRight = p_38344_;
        this.inputUp = p_38345_;
        this.inputDown = p_38346_;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }
}

