/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.EarthFist;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EarthFistSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(8.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.EarthFistCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.EarthFistDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.EarthFistCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    public List<LivingEntity> getLivingEntities(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        int i = (int)caster.m_20185_();
        int j = (int)caster.m_20186_();
        int k = (int)caster.m_20189_();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            radius *= (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0 + 1.0;
        }
        return worldIn.m_6443_(LivingEntity.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).m_82400_(radius), livingEntity -> !MobUtil.areAllies((Entity)livingEntity, (Entity)caster));
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        LivingEntity target = this.getTarget(caster, range);
        Vec3 vec3 = null;
        if (target != null) {
            vec3 = target.m_20182_();
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)rayTraceResult;
            vec3 = result.m_82450_();
        }
        if (this.rightStaff(staff) && !this.getLivingEntities(worldIn, caster, spellStat).isEmpty()) {
            for (LivingEntity entity : this.getLivingEntities(worldIn, caster, spellStat)) {
                float f = (float)Mth.m_14136_((double)(entity.m_20189_() - caster.m_20189_()), (double)(entity.m_20185_() - caster.m_20185_()));
                EarthFist earthFist = new EarthFist((Level)worldIn, entity.m_20182_(), caster);
                earthFist.setExtraDamage(potency);
                earthFist.setWarmupDelayTicks(10);
                earthFist.m_146922_(f * 57.295776f);
                worldIn.m_7967_((Entity)earthFist);
                worldIn.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ModSounds.RUMBLE.get(), this.getSoundSource(), 1.0f, 1.0f);
            }
        } else if (vec3 != null) {
            float f = (float)Mth.m_14136_((double)(vec3.f_82481_ - caster.m_20189_()), (double)(vec3.f_82479_ - caster.m_20185_()));
            EarthFist earthFist = new EarthFist((Level)worldIn, vec3, caster);
            earthFist.setExtraDamage(potency);
            earthFist.setWarmupDelayTicks(10);
            earthFist.m_146922_(f * 57.295776f);
            worldIn.m_7967_((Entity)earthFist);
            worldIn.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ModSounds.RUMBLE.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

