/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellLightningBolt;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LightningSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.LightningCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.LightningDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.LightningCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        double radius = spellStat.getRadius();
        int range = spellStat.getRange();
        float damage = ((Double)SpellConfig.LightningDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        damage += (float)spellStat.getPotency();
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, radius);
        Optional<BlockPos> lightningRod = BlockFinder.findLightningRod(worldIn, BlockPos.m_274446_((Position)rayTraceResult.m_82450_()));
        if (lightningRod.isPresent() && !this.rightStaff(staff)) {
            BlockPos blockPos = lightningRod.get();
            SpellLightningBolt lightningBolt = new SpellLightningBolt((EntityType<? extends LightningBolt>)((EntityType)ModEntityType.SPELL_LIGHTNING_BOLT.get()), (Level)worldIn);
            lightningBolt.setDamage(damage);
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
            lightningBolt.setOwner(caster);
            worldIn.m_7967_((Entity)lightningBolt);
        } else {
            LivingEntity target = this.getTarget(caster, range);
            if (target != null) {
                SpellLightningBolt lightningBolt = new SpellLightningBolt((EntityType<? extends LightningBolt>)((EntityType)ModEntityType.SPELL_LIGHTNING_BOLT.get()), (Level)worldIn);
                lightningBolt.setDamage(damage);
                lightningBolt.m_146884_(target.m_20182_());
                lightningBolt.setOwner(caster);
                worldIn.m_7967_((Entity)lightningBolt);
            } else if (rayTraceResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
                BlockPos blockPos = blockHitResult.m_82425_();
                SpellLightningBolt lightningBolt = new SpellLightningBolt((EntityType<? extends LightningBolt>)((EntityType)ModEntityType.SPELL_LIGHTNING_BOLT.get()), (Level)worldIn);
                lightningBolt.setDamage(damage);
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                lightningBolt.setOwner(caster);
                worldIn.m_7967_((Entity)lightningBolt);
            }
        }
    }
}

