/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.AbstractCyclone;
import com.Polarice3.Goety.common.entities.projectiles.Cyclone;
import com.Polarice3.Goety.common.entities.projectiles.FireTornado;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CycloneSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(600).setRadius(1.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.CycloneCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.CycloneDuration.get();
    }

    @Override
    public SoundEvent CastingSound(LivingEntity caster) {
        if (CuriosFinder.hasUnholySet(caster)) {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SPELL.get();
        }
        return (SoundEvent)ModSounds.WIND.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.CycloneCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        Vec3 vector3d;
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        float velocity = spellStat.getVelocity();
        double radius = spellStat.getRadius();
        Vec3 vec3 = vector3d = caster.m_20252_(1.0f);
        LivingEntity livingEntity = this.getTarget(caster);
        if (livingEntity != null) {
            double d1 = livingEntity.m_20185_() - caster.m_20185_();
            double d2 = livingEntity.m_20227_(0.5) - caster.m_20227_(0.5);
            double d3 = livingEntity.m_20189_() - caster.m_20189_();
            vec3 = new Vec3(d1, d2, d3);
        }
        AbstractCyclone cyclone = new Cyclone((Level)worldIn, caster, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        if (CuriosFinder.hasUnholySet(caster)) {
            cyclone = new FireTornado((Level)worldIn, caster, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
        cyclone.setOwner(caster);
        if (livingEntity != null) {
            cyclone.setTarget(livingEntity);
        }
        if (this.rightStaff(staff)) {
            radius += 1.0;
            ++potency;
        }
        if (WandUtil.enchantedFocus(caster)) {
            potency *= WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) + 1;
            duration *= WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster);
            radius += (double)((float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 10.0f);
        }
        cyclone.setDamage(potency);
        cyclone.setTotalLife(duration);
        cyclone.setBoltSpeed((int)velocity);
        cyclone.setSize((float)radius);
        cyclone.m_6034_(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0);
        worldIn.m_7967_((Entity)cyclone);
        this.playSound(worldIn, caster, 1.0f, 1.0f);
    }
}

