/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.PillagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.Prisoner;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.illager.VindicatorServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieVillagerServant;
import com.Polarice3.Goety.common.entities.hostile.BorderWraith;
import com.Polarice3.Goety.common.entities.hostile.MuckWraith;
import com.Polarice3.Goety.common.entities.hostile.Wraith;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.common.events.ArcaTeleporter;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;

public class ServantUtil {
    public static void convertZombies(Entity target, LivingEntity owner, boolean permanent) {
        Zombie zombieEntity;
        if (target instanceof Zombie && ForgeEventFactory.canLivingConvert((LivingEntity)(zombieEntity = (Zombie)target), (EntityType)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), timer -> {})) {
            EntityType entityType = (EntityType)ModEntityType.ZOMBIE_SERVANT.get();
            if (zombieEntity instanceof ZombieVillager) {
                entityType = (EntityType)ModEntityType.ZOMBIE_VILLAGER_SERVANT.get();
            } else if (zombieEntity instanceof Husk) {
                entityType = (EntityType)ModEntityType.HUSK_SERVANT.get();
            } else if (zombieEntity instanceof Drowned) {
                entityType = (EntityType)ModEntityType.DROWNED_SERVANT.get();
            } else if (zombieEntity instanceof ZombifiedPiglin) {
                entityType = (EntityType)ModEntityType.ZPIGLIN_SERVANT.get();
            }
            ZombieServant zombieServant = (ZombieServant)zombieEntity.m_21406_(entityType, true);
            if (zombieServant != null) {
                Level level;
                if (owner != null) {
                    zombieServant.setTrueOwner(owner);
                }
                if ((level = target.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    zombieServant.m_6518_((ServerLevelAccessor)serverLevel, target.f_19853_.m_6436_(zombieServant.m_20183_()), MobSpawnType.CONVERSION, null, null);
                }
                if (zombieEntity instanceof ZombieVillager) {
                    ZombieVillager villager = (ZombieVillager)zombieEntity;
                    if (zombieServant instanceof ZombieVillagerServant) {
                        ZombieVillagerServant servant = (ZombieVillagerServant)zombieServant;
                        servant.m_34375_(villager.m_7141_());
                        servant.setGossips(villager.f_34361_);
                        servant.setTradeOffers(villager.f_34362_);
                        servant.setVillagerXp(villager.m_149889_());
                    }
                }
                if (!permanent) {
                    zombieServant.setLimitedLife(10 * (15 + target.f_19853_.f_46441_.m_188503_(45)));
                }
                ForgeEventFactory.onLivingConvert((LivingEntity)zombieEntity, (LivingEntity)zombieServant);
                if (!zombieServant.m_20067_()) {
                    zombieServant.f_19853_.m_5898_(null, 1026, zombieServant.m_20183_(), 0);
                }
            }
        }
    }

    public static void convertSkeletons(Entity target, LivingEntity owner, boolean wither, boolean permanent) {
        AbstractSkeleton skeleton;
        if (target instanceof AbstractSkeleton && ForgeEventFactory.canLivingConvert((LivingEntity)(skeleton = (AbstractSkeleton)target), (EntityType)((EntityType)ModEntityType.SKELETON_SERVANT.get()), timer -> {})) {
            EntityType entityType = (EntityType)ModEntityType.SKELETON_SERVANT.get();
            if (skeleton instanceof Stray) {
                entityType = (EntityType)ModEntityType.STRAY_SERVANT.get();
            } else if (wither && skeleton instanceof WitherSkeleton) {
                entityType = (EntityType)ModEntityType.WITHER_SKELETON_SERVANT.get();
            }
            AbstractSkeletonServant skeletonServant = (AbstractSkeletonServant)skeleton.m_21406_(entityType, true);
            if (skeletonServant != null) {
                Level level;
                if (owner != null) {
                    skeletonServant.setTrueOwner(owner);
                }
                if ((level = target.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    skeletonServant.m_6518_((ServerLevelAccessor)serverLevel, target.f_19853_.m_6436_(skeletonServant.m_20183_()), MobSpawnType.CONVERSION, null, null);
                }
                if (!permanent) {
                    skeletonServant.setLimitedLife(10 * (15 + target.f_19853_.f_46441_.m_188503_(45)));
                }
                ForgeEventFactory.onLivingConvert((LivingEntity)skeleton, (LivingEntity)skeletonServant);
                if (!skeletonServant.m_20067_()) {
                    skeletonServant.f_19853_.m_5898_(null, 1026, skeletonServant.m_20183_(), 0);
                }
            }
        }
    }

    public static void infect(Mob target, LivingEntity owner, boolean permanent, boolean keepLoot) {
        EntityType entityType;
        Summoned summoned = null;
        if (target instanceof Wraith) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.WRAITH_SERVANT.get(), keepLoot);
        } else if (target instanceof BorderWraith) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.BORDER_WRAITH_SERVANT.get(), keepLoot);
        } else if (target instanceof MuckWraith) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.MUCK_WRAITH_SERVANT.get(), keepLoot);
        } else if (target instanceof PiglinBrute) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get(), keepLoot);
        } else if (target instanceof AbstractPiglin) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.ZPIGLIN_SERVANT.get(), keepLoot);
        } else if (target instanceof Villager || target instanceof Prisoner) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.ZOMBIE_VILLAGER_SERVANT.get(), keepLoot);
        } else if (target instanceof Vindicator || target instanceof VindicatorServant) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.ZOMBIE_VINDICATOR_SERVANT.get(), keepLoot);
        } else if (target instanceof Pillager || target instanceof PillagerServant) {
            summoned = (Summoned)target.m_21406_((EntityType)ModEntityType.SKELETON_PILLAGER_SERVANT.get(), keepLoot);
        }
        if (summoned != null && ForgeEventFactory.canLivingConvert((LivingEntity)target, (EntityType)(entityType = summoned.m_6095_()), timer -> {})) {
            Level level = target.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                summoned.m_6518_((ServerLevelAccessor)serverLevel, target.f_19853_.m_6436_(summoned.m_20183_()), MobSpawnType.CONVERSION, null, null);
            }
            if (!permanent) {
                summoned.setLimitedLife(10 * (15 + target.f_19853_.f_46441_.m_188503_(45)));
            }
            if (owner != null) {
                summoned.setTrueOwner(owner);
            }
            if (summoned instanceof ZombieVillagerServant) {
                ZombieVillagerServant servant = (ZombieVillagerServant)summoned;
                if (target instanceof Villager) {
                    Villager villager = (Villager)target;
                    servant.m_34375_(villager.m_7141_());
                    servant.setGossips((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                    servant.setTradeOffers(villager.m_6616_().m_45388_());
                    servant.setVillagerXp(villager.m_7809_());
                } else if (target instanceof Prisoner) {
                    Prisoner prisoner = (Prisoner)target;
                    servant.m_34375_(prisoner.m_7141_());
                    if (prisoner.getGossips() != null) {
                        servant.setGossips(prisoner.getGossips());
                    }
                    if (prisoner.getOffers() != null) {
                        servant.setTradeOffers(prisoner.getOffers());
                    }
                    servant.setVillagerXp(prisoner.getVillagerXp());
                }
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)target, (LivingEntity)summoned);
            if (!summoned.m_20067_()) {
                summoned.f_19853_.m_5898_(null, 1026, summoned.m_20183_(), 0);
            }
        }
    }

    public static boolean isFrostHeal(LivingEntity servant) {
        MobType mobType = servant.m_6336_();
        EntityType entityType = servant.m_6095_();
        return mobType == ModMobType.FROST || entityType.m_204039_(ModTags.EntityTypes.FROST_HEAL);
    }

    public static boolean isWildHeal(LivingEntity servant) {
        MobType mobType = servant.m_6336_();
        EntityType entityType = servant.m_6095_();
        return mobType == ModMobType.NATURAL || mobType == MobType.f_21642_ || entityType.m_204039_(ModTags.EntityTypes.WILD_HEAL);
    }

    public static boolean isNetherHeal(LivingEntity servant) {
        MobType mobType = servant.m_6336_();
        EntityType entityType = servant.m_6095_();
        return mobType == ModMobType.NETHER || entityType.m_204039_(ModTags.EntityTypes.NETHER_HEAL);
    }

    public static boolean isNecroHeal(LivingEntity servant) {
        MobType mobType = servant.m_6336_();
        EntityType entityType = servant.m_6095_();
        return mobType == MobType.f_21641_ || entityType.m_204039_(ModTags.EntityTypes.NECRO_HEAL);
    }

    public static boolean isAbyssHeal(LivingEntity servant) {
        MobType mobType = servant.m_6336_();
        EntityType entityType = servant.m_6095_();
        return mobType == MobType.f_21644_ || entityType.m_204039_(ModTags.EntityTypes.ABYSS_HEAL);
    }

    public static boolean isVoidHeal(LivingEntity servant) {
        EntityType entityType = servant.m_6095_();
        return servant instanceof AbstractEnderling || entityType.m_204039_(ModTags.EntityTypes.VOID_HEAL);
    }

    public static boolean isValidServantHeal(LivingEntity livingEntity) {
        return ServantUtil.isFrostHeal(livingEntity) || ServantUtil.isWildHeal(livingEntity) || ServantUtil.isNecroHeal(livingEntity) || ServantUtil.isNetherHeal(livingEntity) || ServantUtil.isAbyssHeal(livingEntity) || ServantUtil.isVoidHeal(livingEntity);
    }

    public static boolean notServantButOwned(LivingEntity livingEntity) {
        return livingEntity instanceof OwnableEntity && !(livingEntity instanceof IServant) && ServantUtil.isValidServantHeal(livingEntity);
    }

    public static void healServant(LivingEntity owner, LivingEntity servant) {
        if (owner instanceof Player) {
            Player player = (Player)owner;
            ServantUtil.healServant(player, servant);
        }
    }

    public static void healServant(Player owner, LivingEntity servant) {
        if (!(servant.f_19853_.f_46443_ || servant.m_6095_().m_204039_(ModTags.EntityTypes.NO_HEAL_SERVANTS) || servant.m_6060_() || servant.m_21224_() || !(servant.m_21223_() < servant.m_21233_()))) {
            boolean curio = false;
            int soulCost = 0;
            int healRate = 0;
            float healAmount = 0.0f;
            if (ServantUtil.isNecroHeal(servant) && ((Boolean)MobsConfig.UndeadMinionHeal.get()).booleanValue()) {
                curio = CuriosFinder.hasUndeadCape((LivingEntity)owner);
                soulCost = (Integer)MobsConfig.UndeadMinionHealCost.get();
                healRate = (Integer)MobsConfig.UndeadMinionHealTime.get();
                healAmount = ((Double)MobsConfig.UndeadMinionHealAmount.get()).floatValue();
            }
            if (ServantUtil.isAbyssHeal(servant) && ((Boolean)MobsConfig.WaterMinionHeal.get()).booleanValue()) {
                curio = CuriosFinder.hasAbyssRobes((LivingEntity)owner);
                soulCost = (Integer)MobsConfig.WaterMinionHealCost.get();
                healRate = (Integer)MobsConfig.WaterMinionHealTime.get();
                healAmount = ((Double)MobsConfig.WaterMinionHealAmount.get()).floatValue();
            }
            if (ServantUtil.isWildHeal(servant) && ((Boolean)MobsConfig.NaturalMinionHeal.get()).booleanValue()) {
                curio = CuriosFinder.hasWildRobe((LivingEntity)owner);
                soulCost = (Integer)MobsConfig.NaturalMinionHealCost.get();
                healRate = (Integer)MobsConfig.NaturalMinionHealTime.get();
                healAmount = ((Double)MobsConfig.NaturalMinionHealAmount.get()).floatValue();
            }
            if (ServantUtil.isFrostHeal(servant) && ((Boolean)MobsConfig.FrostMinionHeal.get()).booleanValue()) {
                curio = CuriosFinder.hasFrostRobes((LivingEntity)owner);
                soulCost = (Integer)MobsConfig.FrostMinionHealCost.get();
                healRate = (Integer)MobsConfig.FrostMinionHealTime.get();
                healAmount = ((Double)MobsConfig.FrostMinionHealAmount.get()).floatValue();
            }
            if (ServantUtil.isNetherHeal(servant) && ((Boolean)MobsConfig.NetherMinionHeal.get()).booleanValue()) {
                curio = CuriosFinder.hasNetherRobe((LivingEntity)owner);
                soulCost = (Integer)MobsConfig.NetherMinionHealCost.get();
                healRate = (Integer)MobsConfig.NetherMinionHealTime.get();
                healAmount = ((Double)MobsConfig.NetherMinionHealAmount.get()).floatValue();
            }
            if (ServantUtil.isVoidHeal(servant) && ((Boolean)MobsConfig.VoidMinionHeal.get()).booleanValue()) {
                curio = CuriosFinder.hasVoidRobe((LivingEntity)owner);
                soulCost = (Integer)MobsConfig.VoidMinionHealCost.get();
                healRate = (Integer)MobsConfig.VoidMinionHealTime.get();
                healAmount = ((Double)MobsConfig.VoidMinionHealAmount.get()).floatValue();
            }
            if (curio && SEHelper.getSoulsAmount(owner, soulCost) && servant.f_19797_ % (MathHelper.secondsToTicks(healRate) + 1) == 0) {
                servant.m_5634_(healAmount);
                Vec3 vector3d = servant.m_20184_();
                Level level = servant.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    SEHelper.decreaseSouls(owner, soulCost);
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_235898_, servant.m_20208_(0.5), servant.m_20187_(), servant.m_20262_(0.5), 0, vector3d.f_82479_ * -0.2, 0.1, vector3d.f_82481_ * -0.2, 0.5);
                }
            }
        }
    }

    public static boolean teleportToRevive(IOwned owned) {
        if (owned instanceof LivingEntity) {
            LivingEntity livingOwned = (LivingEntity)owned;
            BlockPos blockPos = owned.getRevivePos();
            if (blockPos != null) {
                Optional optional;
                ServerLevel serverWorld;
                BlockPos blockPos1 = BlockPos.m_274561_((double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
                if (owned.getReviveLevel() == livingOwned.f_19853_.m_46472_()) {
                    Optional optional2 = RespawnAnchorBlock.m_55839_((EntityType)livingOwned.m_6095_(), (CollisionGetter)livingOwned.f_19853_, (BlockPos)blockPos1);
                    if (optional2.isPresent()) {
                        Vec3 vec3 = (Vec3)optional2.get();
                        if (livingOwned.f_19853_.m_6857_().m_187562_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) {
                            livingOwned.m_6021_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                        } else {
                            BlockPos blockPos2 = livingOwned.f_19853_.m_220360_();
                            livingOwned.m_6021_((double)blockPos2.m_123341_(), (double)blockPos2.m_123342_(), (double)blockPos2.m_123343_());
                        }
                        return true;
                    }
                } else if (owned.getReviveLevel() != null && livingOwned.m_20194_() != null && (serverWorld = livingOwned.m_20194_().m_129880_(owned.getReviveLevel())) != null && (optional = RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)serverWorld, (BlockPos)blockPos1)).isPresent()) {
                    Vec3 vec3 = (Vec3)optional.get();
                    livingOwned.changeDimension(serverWorld, (ITeleporter)new ArcaTeleporter((Vec3)optional.get()));
                    if (serverWorld.m_6857_().m_187562_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) {
                        livingOwned.m_6021_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    } else {
                        BlockPos blockPos2 = serverWorld.m_220360_();
                        livingOwned.m_6021_((double)blockPos2.m_123341_(), (double)blockPos2.m_123342_(), (double)blockPos2.m_123343_());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static InteractionResult equipServantArmor(Player player, Summoned summoned, ItemStack itemStack, InteractionResult failResult) {
        ItemStack helmet = summoned.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = summoned.m_6844_(EquipmentSlot.CHEST);
        ItemStack legging = summoned.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = summoned.m_6844_(EquipmentSlot.FEET);
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            if (((Boolean)MobsConfig.RaiderServantWearArmor.get()).booleanValue() || !(summoned instanceof RaiderServant)) {
                summoned.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                if (armor.m_266204_() == ArmorItem.Type.HELMET) {
                    summoned.m_8061_(EquipmentSlot.HEAD, itemStack.m_255036_(1));
                    summoned.dropEquipment(EquipmentSlot.HEAD, helmet);
                    summoned.m_21508_(EquipmentSlot.HEAD);
                }
                if (armor.m_266204_() == ArmorItem.Type.CHESTPLATE) {
                    summoned.m_8061_(EquipmentSlot.CHEST, itemStack.m_255036_(1));
                    summoned.dropEquipment(EquipmentSlot.CHEST, chestplate);
                    summoned.m_21508_(EquipmentSlot.CHEST);
                }
                if (armor.m_266204_() == ArmorItem.Type.LEGGINGS) {
                    summoned.m_8061_(EquipmentSlot.LEGS, itemStack.m_255036_(1));
                    summoned.dropEquipment(EquipmentSlot.LEGS, legging);
                    summoned.m_21508_(EquipmentSlot.LEGS);
                }
                if (armor.m_266204_() == ArmorItem.Type.BOOTS) {
                    summoned.m_8061_(EquipmentSlot.FEET, itemStack.m_255036_(1));
                    summoned.dropEquipment(EquipmentSlot.FEET, boots);
                    summoned.m_21508_(EquipmentSlot.FEET);
                }
                for (int i = 0; i < 7; ++i) {
                    double d0 = summoned.m_217043_().m_188583_() * 0.02;
                    double d1 = summoned.m_217043_().m_188583_() * 0.02;
                    double d2 = summoned.m_217043_().m_188583_() * 0.02;
                    summoned.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, summoned.m_20208_(1.0), summoned.m_20187_() + 0.5, summoned.m_20262_(1.0), d0, d1, d2);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return failResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EquipmentSlot getClickedSlot(Mob mob, Vec3 vec3) {
        EquipmentSlot equipmentslot = EquipmentSlot.MAINHAND;
        boolean flag = mob.m_6162_();
        double d0 = flag ? vec3.f_82480_ * 2.0 : vec3.f_82480_;
        EquipmentSlot equipmentslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && mob.m_21033_(equipmentslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && mob.m_21033_(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && mob.m_21033_(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && mob.m_21033_(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (mob.m_21033_(EquipmentSlot.MAINHAND)) return equipmentslot;
        if (!mob.m_21033_(EquipmentSlot.OFFHAND)) return equipmentslot;
        return EquipmentSlot.OFFHAND;
    }
}

