/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.entities.vehicle.ModBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class ModBoatRenderer
extends EntityRenderer<ModBoat> {
    private final Map<ModBoat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public ModBoatRenderer(EntityRendererProvider.Context p_i46190_1_, boolean hasChest) {
        super(p_i46190_1_);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)Goety.location(ModBoatRenderer.getTextureLocation(type, hasChest)), (Object)this.createBoatModel(p_i46190_1_, (ModBoat.Type)((Object)type), hasChest))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, ModBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? ModBoatRenderer.createChestBoatModelName(type) : ModBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.m_174023_(modellayerlocation);
        return chest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static ModelLayerLocation createLocation(String path) {
        return new ModelLayerLocation(Goety.location(path), "main");
    }

    public static ModelLayerLocation createBoatModelName(ModBoat.Type type) {
        return ModBoatRenderer.createLocation("boat/" + type.getName());
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoat.Type type) {
        return ModBoatRenderer.createLocation("chest_boat/" + type.getName());
    }

    private static String getTextureLocation(ModBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(ModBoat pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.375, 0.0);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        float f = (float)pEntity.m_38385_() - pPartialTicks;
        float f1 = pEntity.m_38384_() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = pEntity.m_38352_(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.m_252781_(new Quaternionf().setAngleAxis(pEntity.m_38352_(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_((Entity)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = pBuffer.m_6299_(listmodel.m_103119_(this.getTextureLocation(pEntity)));
        listmodel.m_7695_(pMatrixStack, ivertexbuilder, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            VertexConsumer vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.m_102282_().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
            }
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(ModBoat p_113927_) {
        return (ResourceLocation)this.getModelWithLocation(p_113927_).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(ModBoat boat) {
        return this.boatResources.get((Object)boat.getModBoatType());
    }
}

