/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.VoidShockModel;
import com.Polarice3.Goety.common.entities.projectiles.VoidShock;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class VoidShockRenderer
extends EntityRenderer<VoidShock> {
    private static final ResourceLocation OUTER_TEXTURES = Goety.location("textures/entity/projectiles/void_shock_outer.png");
    private static final ResourceLocation INNER_TEXTURES = Goety.location("textures/entity/projectiles/void_shock_inner.png");
    private static final ResourceLocation TRAIL_TEXTURE = Goety.location("textures/particle/trail.png");
    private final VoidShockModel<VoidShock> model;
    private final RandomSource random = RandomSource.m_216327_();

    public VoidShockRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.model = new VoidShockModel(renderManagerIn.m_174023_(ModModelLayer.VOID_SHOCK));
    }

    public void render(VoidShock entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_());
        float f1 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        VertexConsumer VertexConsumer2 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(entityIn)));
        this.model.setupAnim(entityIn, f, f1);
        this.model.m_7695_(matrixStackIn, VertexConsumer2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer VertexConsumer22 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)OUTER_TEXTURES));
        this.model.m_7695_(matrixStackIn, VertexConsumer22, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.4f);
        matrixStackIn.m_85849_();
        if (entityIn.hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            float randomF = 0.04f;
            ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
            float r = colorUtil.red() + this.random.m_188501_() * randomF;
            float g = colorUtil.green() + this.random.m_188501_() * randomF;
            float b = colorUtil.blue() + this.random.m_188501_() * randomF;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-x, -y, -z);
            this.renderTrail(entityIn, partialTicks, matrixStackIn, bufferIn, r, g, b, 1.0f, packedLightIn);
            matrixStackIn.m_85849_();
        }
    }

    private void renderTrail(VoidShock entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float red, float green, float blue, float alpha, int packedLightIn) {
        int sampleSize = 1;
        double trailHeight = 0.25;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, -trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 8, partialTicks);
            Vec3 draw1 = drawFrom;
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f2 = (float)(entityIn.f_19797_ % 8) / 8.0f;
            float f3 = f2 + 0.5f;
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)bottomAngleVec.f_82479_, (float)sample.f_82480_ + (float)bottomAngleVec.f_82480_, (float)sample.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)topAngleVec.f_82479_, (float)sample.f_82480_ + (float)topAngleVec.f_82480_, (float)sample.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }

    protected int getBlockLightLevel(VoidShock entityIn, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(VoidShock entity) {
        return INNER_TEXTURES;
    }
}

