/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.CryologerAnimations;
import com.Polarice3.Goety.client.render.layer.HierarchicalArmor;
import com.Polarice3.Goety.common.entities.ally.illager.CryologerServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.BoundCryologer;
import com.Polarice3.Goety.common.entities.hostile.illagers.Cryologer;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class CryologerModel<T extends Mob>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
HierarchicalArmor {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart upperBody;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart cape;
    private final ModelPart arms;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public CryologerModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.upperBody = this.illager.m_171324_("upperBody");
        this.head = this.upperBody.m_171324_("head");
        this.body = this.upperBody.m_171324_("body");
        this.cape = this.upperBody.m_171324_("cape");
        this.arms = this.upperBody.m_171324_("arms");
        this.right_arm = this.upperBody.m_171324_("right_arm");
        this.left_arm = this.upperBody.m_171324_("left_arm");
        this.right_leg = this.illager.m_171324_("right_leg");
        this.left_leg = this.illager.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upperBody = illager.m_171599_("upperBody", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.5f, (float)0.0f));
        PartDefinition head = upperBody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.5f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition hood = head.m_171599_("hood", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-5.5f, -11.5f, -4.5f, 9.0f, 11.0f, 9.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)0.0f));
        PartDefinition eyebrows = head.m_171599_("eyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.5f, (float)-4.1f));
        PartDefinition right_eye = eyebrows.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -0.5f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition left_eye = eyebrows.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -0.5f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition blinks = head.m_171599_("blinks", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_blink = blinks.m_171599_("right_blink", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171488_(-2.0f, 1.5f, -0.05f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-5.5f, (float)-4.0f));
        PartDefinition left_blink = blinks.m_171599_("left_blink", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171480_().m_171488_(0.0f, 1.5f, -0.05f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)-5.5f, (float)-4.0f));
        PartDefinition body = upperBody.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.5f, (float)0.0f));
        PartDefinition clothes = body.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape = upperBody.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-4.5f, -1.0f, -0.5f, 9.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)3.5f));
        PartDefinition arms = upperBody.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171480_().m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.5f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = upperBody.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-9.5f, (float)0.0f));
        PartDefinition left_arm = upperBody.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-9.5f, (float)0.0f));
        PartDefinition right_leg = illager.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_boot = right_leg.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(80, 61).m_171488_(-2.0f, 5.0f, -3.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.1f)).m_171514_(64, 55).m_171488_(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = illager.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_boot = left_leg.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(64, 55).m_171488_(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.1f)).m_171514_(80, 61).m_171488_(-2.0f, 5.0f, -3.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        if (this.f_102609_) {
            this.right_arm.f_104203_ = -0.62831855f;
            this.right_arm.f_104204_ = 0.0f;
            this.right_arm.f_104205_ = 0.0f;
            this.left_arm.f_104203_ = -0.62831855f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = 0.31415927f;
            this.right_leg.f_104205_ = 0.07853982f;
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = -0.31415927f;
            this.left_leg.f_104205_ = -0.07853982f;
        } else {
            this.right_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.right_arm.f_104204_ = 0.0f;
            this.right_arm.f_104205_ = 0.0f;
            this.left_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.right_leg.f_104204_ = 0.0f;
            this.right_leg.f_104205_ = 0.0f;
            this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.left_leg.f_104204_ = 0.0f;
            this.left_leg.f_104205_ = 0.0f;
        }
        float f = 1.0f;
        if (entity.m_21256_() > 4) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.cape.f_104203_ = MathHelper.modelDegrees(10.0f) + Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
        if (entity instanceof Cryologer) {
            Cryologer cryologer = (Cryologer)entity;
            this.m_233381_(cryologer.idleAnimationState, CryologerAnimations.IDLE, ageInTicks);
            this.m_233381_(cryologer.breathAnimationState, CryologerAnimations.BREATH, ageInTicks);
            this.m_233381_(cryologer.cloudAnimationState, CryologerAnimations.HAIL, ageInTicks);
            this.m_233381_(cryologer.wallAnimationState, CryologerAnimations.WALL, ageInTicks);
            this.m_233381_(cryologer.chunkAnimationState, CryologerAnimations.CHUNK, ageInTicks);
            if (cryologer.getCurrentAnimation() == cryologer.getAnimationState("idle")) {
                this.right_arm.f_104203_ = -0.75f;
                this.right_arm.f_104205_ = 0.0f;
                this.right_arm.f_104204_ = 0.0f;
                this.left_arm.f_104203_ = -0.75f;
                this.left_arm.f_104205_ = 0.0f;
                this.left_arm.f_104204_ = 0.0f;
                this.arms.f_104207_ = true;
                this.right_arm.f_104207_ = false;
                this.left_arm.f_104207_ = false;
            } else {
                this.arms.f_104207_ = false;
                this.right_arm.f_104207_ = true;
                this.left_arm.f_104207_ = true;
            }
        } else if (entity instanceof CryologerServant) {
            CryologerServant cryologer = (CryologerServant)entity;
            this.m_233381_(cryologer.idleAnimationState, CryologerAnimations.IDLE, ageInTicks);
            this.m_233381_(cryologer.breathAnimationState, CryologerAnimations.BREATH, ageInTicks);
            this.m_233381_(cryologer.cloudAnimationState, CryologerAnimations.HAIL, ageInTicks);
            this.m_233381_(cryologer.wallAnimationState, CryologerAnimations.WALL, ageInTicks);
            this.m_233381_(cryologer.chunkAnimationState, CryologerAnimations.CHUNK, ageInTicks);
            if (cryologer.getCurrentAnimation() == cryologer.getAnimationState("idle")) {
                this.right_arm.f_104203_ = -0.75f;
                this.right_arm.f_104205_ = 0.0f;
                this.right_arm.f_104204_ = 0.0f;
                this.left_arm.f_104203_ = -0.75f;
                this.left_arm.f_104205_ = 0.0f;
                this.left_arm.f_104204_ = 0.0f;
                this.arms.f_104207_ = true;
                this.right_arm.f_104207_ = false;
                this.left_arm.f_104207_ = false;
            } else {
                this.arms.f_104207_ = false;
                this.right_arm.f_104207_ = true;
                this.left_arm.f_104207_ = true;
            }
        } else if (entity instanceof BoundCryologer) {
            BoundCryologer cryologer = (BoundCryologer)entity;
            this.m_233381_(cryologer.idleAnimationState, CryologerAnimations.IDLE, ageInTicks);
            this.m_233381_(cryologer.breathAnimationState, CryologerAnimations.BREATH, ageInTicks);
            this.m_233381_(cryologer.cloudAnimationState, CryologerAnimations.HAIL, ageInTicks);
            this.m_233381_(cryologer.wallAnimationState, CryologerAnimations.WALL, ageInTicks);
            this.m_233381_(cryologer.chunkAnimationState, CryologerAnimations.CHUNK, ageInTicks);
            if (cryologer.getCurrentAnimation() == cryologer.getAnimationState("idle")) {
                this.right_arm.f_104203_ = -0.75f;
                this.right_arm.f_104205_ = 0.0f;
                this.right_arm.f_104204_ = 0.0f;
                this.left_arm.f_104203_ = -0.75f;
                this.left_arm.f_104205_ = 0.0f;
                this.left_arm.f_104204_ = 0.0f;
                this.arms.f_104207_ = true;
                this.right_arm.f_104207_ = false;
                this.left_arm.f_104207_ = false;
            } else {
                this.arms.f_104207_ = false;
                this.right_arm.f_104207_ = true;
                this.left_arm.f_104207_ = true;
            }
        }
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.right_arm, (Object)this.left_arm, (Object)this.right_leg, (Object)this.left_leg);
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        this.getArm(arm).m_104299_(poseStack);
    }

    @Override
    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    @Override
    public void translateToArms(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.right_arm);
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.left_arm);
    }

    @Override
    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    @Override
    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

