/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.entities.OminousIdolBlockEntity;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.items.block.OminousIdolBlockItem;
import com.Polarice3.Goety.utils.BlockFinder;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OminousIdolBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape SHAPE_BOTTOM_BODY = Block.m_49796_((double)4.0, (double)8.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_BOTTOM_BODY_WE = Block.m_49796_((double)5.0, (double)8.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    protected static final VoxelShape BOTTOM_NORTH_AABB = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_BOTTOM_BODY);
    protected static final VoxelShape BOTTOM_WEST_AABB = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_BOTTOM_BODY_WE);
    protected static final VoxelShape BOTTOM_EAST_AABB = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_BOTTOM_BODY_WE);
    protected static final VoxelShape BOTTOM_SOUTH_AABB = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_BOTTOM_BODY);
    protected static final VoxelShape SHAPE_TOP_BODY = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)11.0);
    protected static final VoxelShape SHAPE_TOP_BODY_WE = Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)12.0);
    protected static final VoxelShape SHAPE_HEAD = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    protected static final VoxelShape TOP_NORTH_AABB = Shapes.m_83110_((VoxelShape)SHAPE_TOP_BODY, (VoxelShape)SHAPE_HEAD);
    protected static final VoxelShape TOP_WEST_AABB = Shapes.m_83110_((VoxelShape)SHAPE_TOP_BODY_WE, (VoxelShape)SHAPE_HEAD);
    protected static final VoxelShape TOP_EAST_AABB = Shapes.m_83110_((VoxelShape)SHAPE_TOP_BODY_WE, (VoxelShape)SHAPE_HEAD);
    protected static final VoxelShape TOP_SOUTH_AABB = Shapes.m_83110_((VoxelShape)SHAPE_TOP_BODY, (VoxelShape)SHAPE_HEAD);

    public OminousIdolBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 6.0f).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? 14 : 0).m_60955_().m_60988_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return switch ((Direction)pState.m_61143_((Property)FACING)) {
                case Direction.SOUTH -> BOTTOM_SOUTH_AABB;
                default -> BOTTOM_NORTH_AABB;
                case Direction.WEST -> BOTTOM_WEST_AABB;
                case Direction.EAST -> BOTTOM_EAST_AABB;
            };
        }
        if (pState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return switch ((Direction)pState.m_61143_((Property)FACING)) {
                case Direction.SOUTH -> TOP_SOUTH_AABB;
                default -> TOP_NORTH_AABB;
                case Direction.WEST -> TOP_WEST_AABB;
                case Direction.EAST -> TOP_EAST_AABB;
            };
        }
        return Shapes.m_83144_();
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(pPos.m_7494_()).m_76152_() == Fluids.f_76193_)), 3);
        BlockEntity tileentity = pLevel.m_7702_(pPos);
        if (pStack.m_41720_() instanceof OminousIdolBlockItem && tileentity instanceof OminousIdolBlockEntity) {
            OminousIdolBlockEntity blockEntity = (OminousIdolBlockEntity)tileentity;
            if (pPlacer instanceof Player) {
                Player player = (Player)pPlacer;
                if (blockEntity.getTrueOwner() == null) {
                    blockEntity.setOwner((LivingEntity)player);
                }
            }
            if (!OminousIdolBlockItem.getIllagers(pStack, pLevel).isEmpty()) {
                for (RaiderServant illagerServant : OminousIdolBlockItem.getIllagers(pStack, pLevel)) {
                    blockEntity.addIllager(illagerServant);
                }
            }
        }
    }

    public void m_5707_(Level p_52755_, BlockPos p_52756_, BlockState p_52757_, Player p_52758_) {
        if (!p_52755_.f_46443_ && p_52758_.m_7500_()) {
            BlockFinder.preventCreativeDropFromBottomPart(p_52755_, p_52756_, p_52757_, p_52758_);
        }
        super.m_5707_(p_52755_, p_52756_, p_52757_, p_52758_);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POWERED, WATERLOGGED, FACING, HALF});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level iworld = pContext.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos blockpos = blockPos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? super.m_7898_(blockState, level, blockPos) : blockstate.m_60713_((Block)this);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)pState.m_61124_((Property)POWERED, (Comparable)((Boolean)pFacingState.m_61143_((Property)POWERED))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public BlockState m_6843_(BlockState p_51295_, Rotation p_51296_) {
        return (BlockState)p_51295_.m_61124_((Property)FACING, (Comparable)p_51296_.m_55954_((Direction)p_51295_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_51292_, Mirror p_51293_) {
        return p_51292_.m_60717_(p_51293_.m_54846_((Direction)p_51292_.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pTe, ItemStack pStack) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        if (pTe instanceof OminousIdolBlockEntity) {
            OminousIdolBlockEntity blockEntity = (OminousIdolBlockEntity)pTe;
            this.setItemStackTags(itemStack, blockEntity);
        }
        OminousIdolBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)itemStack);
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        BlockEntity tileEntity = world.m_7702_(pos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            tileEntity = world.m_7702_(pos.m_7495_());
        }
        if (tileEntity instanceof OminousIdolBlockEntity) {
            OminousIdolBlockEntity blockEntity = (OminousIdolBlockEntity)tileEntity;
            this.setItemStackTags(itemStack, blockEntity);
        }
        return itemStack;
    }

    public void setItemStackTags(ItemStack itemStack, OminousIdolBlockEntity tileEntity) {
        if (!tileEntity.getUuids().isEmpty()) {
            for (UUID uuid : tileEntity.getUuids()) {
                OminousIdolBlockItem.setUUIDs(itemStack, uuid);
            }
        } else {
            OminousIdolBlockItem.clearUUIDs(itemStack);
        }
    }

    public BlockEntity m_142194_(BlockPos p_151996_, BlockState p_151997_) {
        if (p_151997_.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return new OminousIdolBlockEntity(p_151996_, p_151997_);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof OminousIdolBlockEntity) {
                OminousIdolBlockEntity blockEntity1 = (OminousIdolBlockEntity)blockEntity;
                blockEntity1.tick();
            }
        };
    }
}

