/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.bound;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AllyVex;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.AbstractBoundIllager;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.Fangs;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class BoundEvoker
extends AbstractBoundIllager {
    @Nullable
    private Sheep wololoTarget;

    public BoundEvoker(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new EvokerCastingSpellGoal());
        this.f_21345_.m_25352_(2, new AvoidTargetGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new EvokerSummonSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new EvokerAttackSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new EvokerWololoSpellGoal());
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<BoundEvoker>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22280_, 0.15).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.BoundEvokerFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BoundEvokerArmor.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BoundEvokerHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BoundEvokerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BoundEvokerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.BoundEvokerFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7378_(CompoundTag p_32642_) {
        super.m_7378_(p_32642_);
    }

    @Override
    public void m_7380_(CompoundTag p_32646_) {
        super.m_7380_(p_32646_);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_11863_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return SoundEvents.f_11866_;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        this.m_5496_((SoundEvent)ModSounds.DEAD_MOAN.get(), 2.0f, 1.0f);
        super.m_6667_(pCause);
    }

    public float m_6100_() {
        return 0.45f;
    }

    void setWololoTarget(@Nullable Sheep p_32635_) {
        this.wololoTarget = p_32635_;
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.f_11862_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), (0.5 - this.f_19796_.m_188500_()) * 0.15, (double)0.01f, (0.5 - this.f_19796_.m_188500_()) * 0.15);
            }
        }
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    class EvokerCastingSpellGoal
    extends AbstractBoundIllager.BoundCastingSpellGoal {
        EvokerCastingSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (BoundEvoker.this.m_5448_() != null) {
                BoundEvoker.this.m_21563_().m_24960_((Entity)BoundEvoker.this.m_5448_(), (float)BoundEvoker.this.m_8085_(), (float)BoundEvoker.this.m_8132_());
            } else if (BoundEvoker.this.getWololoTarget() != null) {
                BoundEvoker.this.m_21563_().m_24960_((Entity)BoundEvoker.this.getWololoTarget(), (float)BoundEvoker.this.m_8085_(), (float)BoundEvoker.this.m_8132_());
            }
        }
    }

    class EvokerSummonSpellGoal
    extends AbstractBoundIllager.BoundUseSpellGoal {
        private final TargetingConditions vexCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();

        EvokerSummonSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int i = BoundEvoker.this.f_19853_.m_45971_(AllyVex.class, this.vexCountTargeting, (LivingEntity)BoundEvoker.this, BoundEvoker.this.m_20191_().m_82400_(16.0)).size();
            return BoundEvoker.this.f_19796_.m_188503_(8) + 1 > i;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)BoundEvoker.this.f_19853_;
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = BoundEvoker.this.m_20183_().m_7918_(-2 + BoundEvoker.this.f_19796_.m_188503_(5), 1, -2 + BoundEvoker.this.f_19796_.m_188503_(5));
                AllyVex vex = (AllyVex)((EntityType)ModEntityType.ALLY_VEX.get()).m_20615_(BoundEvoker.this.f_19853_);
                if (vex == null) continue;
                vex.m_20035_(blockpos, 0.0f, 0.0f);
                vex.m_6518_((ServerLevelAccessor)serverlevel, BoundEvoker.this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                vex.setTrueOwner((LivingEntity)BoundEvoker.this);
                vex.setBoundOrigin(blockpos);
                vex.setLimitedLife(20 * (30 + BoundEvoker.this.f_19796_.m_188503_(90)));
                serverlevel.m_47205_((Entity)vex);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractBoundIllager.BoundSpell getSpell() {
            return AbstractBoundIllager.BoundSpell.SUMMON_VEX;
        }
    }

    class EvokerAttackSpellGoal
    extends AbstractBoundIllager.BoundUseSpellGoal {
        EvokerAttackSpellGoal() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected void performSpellCasting() {
            LivingEntity livingentity = BoundEvoker.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            double d0 = Math.min(livingentity.m_20186_(), BoundEvoker.this.m_20186_());
            double d1 = Math.max(livingentity.m_20186_(), BoundEvoker.this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - BoundEvoker.this.m_20189_()), (double)(livingentity.m_20185_() - BoundEvoker.this.m_20185_()));
            if (BoundEvoker.this.m_20280_((Entity)livingentity) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.createSpellEntity(BoundEvoker.this.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, BoundEvoker.this.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(BoundEvoker.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, BoundEvoker.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    this.createSpellEntity(BoundEvoker.this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, BoundEvoker.this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, l);
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = BlockPos.m_274561_((double)p_32673_, (double)p_32676_, (double)p_32674_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = BoundEvoker.this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)BoundEvoker.this.f_19853_, blockpos1, Direction.UP)) continue;
                if (!BoundEvoker.this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = BoundEvoker.this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)BoundEvoker.this.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_32675_) - 1);
            if (flag) {
                BoundEvoker.this.f_19853_.m_7967_((Entity)new Fangs(BoundEvoker.this.f_19853_, p_32673_, (double)blockpos.m_123342_() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)BoundEvoker.this));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractBoundIllager.BoundSpell getSpell() {
            return AbstractBoundIllager.BoundSpell.FANGS;
        }
    }

    public class EvokerWololoSpellGoal
    extends AbstractBoundIllager.BoundUseSpellGoal {
        private final TargetingConditions wololoTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(p_32710_ -> ((Sheep)p_32710_).m_29874_() == DyeColor.RED);

        @Override
        public boolean m_8036_() {
            if (BoundEvoker.this.m_5448_() != null) {
                return false;
            }
            if (BoundEvoker.this.isCastingSpell()) {
                return false;
            }
            if (BoundEvoker.this.f_19797_ < this.nextAttackTickCount) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)BoundEvoker.this.f_19853_, (Entity)BoundEvoker.this)) {
                return false;
            }
            List list = BoundEvoker.this.f_19853_.m_45971_(Sheep.class, this.wololoTargeting, (LivingEntity)BoundEvoker.this, BoundEvoker.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            BoundEvoker.this.setWololoTarget((Sheep)list.get(BoundEvoker.this.f_19796_.m_188503_(list.size())));
            return true;
        }

        @Override
        public boolean m_8045_() {
            return BoundEvoker.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            BoundEvoker.this.setWololoTarget(null);
        }

        @Override
        protected void performSpellCasting() {
            Sheep sheep = BoundEvoker.this.getWololoTarget();
            if (sheep != null && sheep.m_6084_()) {
                sheep.m_29855_(DyeColor.BLUE);
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 140;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11869_;
        }

        @Override
        protected AbstractBoundIllager.BoundSpell getSpell() {
            return AbstractBoundIllager.BoundSpell.WOLOLO;
        }
    }
}

