/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.servants.Inferno;
import com.Polarice3.Goety.common.entities.neutral.BlazeServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class BlazeSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BlazeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BlazeDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.BlazeSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound(LivingEntity caster) {
        if (CuriosFinder.hasUnholySet(caster)) {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SUMMON.get();
        }
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BlazeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof BlazeServant;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.BlazeLimit.get();
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 2 + caster.f_19853_.f_46441_.m_188503_(4);
            }
            for (int i1 = 0; i1 < i; ++i1) {
                BlazeServant blazeServant = new BlazeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.BLAZE_SERVANT.get()), (Level)worldIn);
                if (CuriosFinder.hasUnholySet(caster)) {
                    blazeServant = new Inferno((EntityType<? extends Owned>)((EntityType)ModEntityType.INFERNO.get()), (Level)worldIn);
                }
                BlockPos blockPos = BlockFinder.SummonRadius(caster.m_20183_(), (Entity)blazeServant, (Level)worldIn);
                if (caster.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius(caster, (Level)worldIn);
                }
                blazeServant.setTrueOwner(caster);
                blazeServant.m_20035_(blockPos, 0.0f, 0.0f);
                MobUtil.moveDownToGround((Entity)blazeServant);
                blazeServant.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                blazeServant.m_21530_();
                blazeServant.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.buffSummon(caster, (LivingEntity)blazeServant, potency);
                this.SummonSap(caster, (LivingEntity)blazeServant);
                this.setTarget(caster, (Mob)blazeServant);
                worldIn.m_7967_((Entity)blazeServant);
                this.summonAdvancement(caster, (LivingEntity)blazeServant);
            }
            this.SummonDown(caster);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SUMMON_SPELL_FIERY.get());
        }
    }

    @Override
    public void buffSummon(LivingEntity caster, LivingEntity summoned, int potency) {
        if (potency > 0 && !this.hasSummonDown(caster)) {
            int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
            summoned.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost, false, false));
            if (summoned instanceof BlazeServant) {
                BlazeServant blazeServant = (BlazeServant)summoned;
                blazeServant.setFireBallDamage(blazeServant.getFireBallDamage() + (float)potency);
            }
        }
    }
}

