/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.entities.projectiles.BlossomThorn;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.Vec3Util;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BlossomThornRenderer
extends EntityRenderer<BlossomThorn> {
    private static final ResourceLocation TEXTURE_LOCATION = Goety.location("textures/entity/projectiles/blossom_thorn.png");

    public BlossomThornRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(BlossomThorn entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        if (!entity.sentTrapEvent) {
            return;
        }
        this.renderBeam(entity, partialTicks, poseStack, buffer, RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
    }

    private void renderBeam(BlossomThorn blossomThorn, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, RenderType type) {
        float numTextures = 8.0f;
        int maxAge = 20;
        int age = maxAge - blossomThorn.lifeTicks;
        float lifeRatio = 2.0f;
        float textureProgress = Math.max(0.0f, ((float)age + tickDelta) * lifeRatio / (float)maxAge - lifeRatio + 1.0f);
        if (textureProgress >= 1.0f) {
            return;
        }
        float spikeHeight = blossomThorn.height;
        float textureRatio = 0.34375f;
        float spikeWidth = textureRatio * spikeHeight * 0.5f;
        double upProgress = (Math.sin(Math.min((double)((float)age + tickDelta) / ((double)maxAge * 0.4), 1.0) * Math.PI * 0.5) - 1.0) * (double)spikeHeight;
        Function<Float, Float> texTransformer = this.textureMultiplier(Float.valueOf(1.0f / numTextures), (float)(Math.floor(textureProgress * numTextures) / (double)numTextures));
        poseStack.m_85836_();
        Vec3 offset = BlossomThornRenderer.fromLerpedPosition(blossomThorn, 0.0, tickDelta).m_82546_(blossomThorn.m_20182_());
        poseStack.m_85837_(-offset.f_82479_, upProgress - offset.f_82480_, -offset.f_82481_);
        Vec3 bottomPos = blossomThorn.randVec.m_82549_(Vec3Util.yAxis.m_82490_((double)spikeHeight)).m_82541_();
        float n = (float)Math.acos(bottomPos.f_82480_);
        float o = (float)Math.atan2(bottomPos.f_82481_, bottomPos.f_82479_);
        float pi = (float)Math.PI;
        float rTD = 57.295776f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_((pi / 2.0f - o) * rTD));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(n * rTD));
        float q = 0.0f;
        int red = (int)(ColorUtil.WHITE.red * 255.0f);
        int green = (int)(ColorUtil.WHITE.green * 255.0f);
        int blue = (int)(ColorUtil.WHITE.blue * 255.0f);
        float af = Mth.m_14089_((float)(q + pi)) * spikeWidth;
        float ag = Mth.m_14031_((float)(q + pi)) * spikeWidth;
        float ah = Mth.m_14089_((float)(q + 0.0f)) * spikeWidth;
        float ai = Mth.m_14031_((float)(q + 0.0f)) * spikeWidth;
        float aj = Mth.m_14089_((float)(q + pi / 2.0f)) * spikeWidth;
        float ak = Mth.m_14031_((float)(q + pi / 2.0f)) * spikeWidth;
        float al = Mth.m_14089_((float)(q + 4.712389f)) * spikeWidth;
        float am = Mth.m_14031_((float)(q + 4.712389f)) * spikeWidth;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        float c0 = texTransformer.apply(Float.valueOf(0.4999f)).floatValue();
        float c2 = texTransformer.apply(Float.valueOf(0.0f)).floatValue();
        float c1 = texTransformer.apply(Float.valueOf(1.0f)).floatValue();
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, af, spikeHeight, ag, red, green, blue, c0, 0.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, af, 0.0f, ag, red, green, blue, c0, 1.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, ah, 0.0f, ai, red, green, blue, c2, 1.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, ah, spikeHeight, ai, red, green, blue, c2, 0.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, aj, spikeHeight, ak, red, green, blue, c1, 0.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, aj, 0.0f, ak, red, green, blue, c1, 1.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, al, 0.0f, am, red, green, blue, c0, 1.0f);
        BlossomThornRenderer.vertex(vertexConsumer, matrix4f, matrix3f, al, spikeHeight, am, red, green, blue, c0, 0.0f);
        poseStack.m_85849_();
    }

    public static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float f, float g, float h, int red, int green, int blue, float l, float m) {
        vertexConsumer.m_252986_(matrix4f, f, g, h).m_6122_(red, green, blue, 255).m_7421_(l, m).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000A0).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    public Function<Float, Float> textureMultiplier(Float multiplier, float adjustment) {
        return texCoord -> Float.valueOf(texCoord.floatValue() * multiplier.floatValue() + adjustment);
    }

    public static float randFloat(Random random, float range) {
        return (random.nextFloat() - 0.5f) * 2.0f * range;
    }

    public static Vec3 fromLerpedPosition(Entity entity, double yOffset, float delta) {
        double d = Mth.m_14139_((double)delta, (double)entity.f_19790_, (double)entity.m_20185_());
        double e = Mth.m_14139_((double)delta, (double)entity.f_19791_, (double)entity.m_20186_()) + yOffset;
        double f = Mth.m_14139_((double)delta, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(d, e, f);
    }

    public ResourceLocation getTextureLocation(BlossomThorn p_114482_) {
        return TEXTURE_LOCATION;
    }
}

