/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.DrownedNecromancerModel;
import com.Polarice3.Goety.common.entities.neutral.DrownedNecromancer;
import com.Polarice3.Goety.config.MobsConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class DrownedNecromancerRenderer
extends MobRenderer<DrownedNecromancer, DrownedNecromancerModel<DrownedNecromancer>> {
    private static final ResourceLocation SKELETON_LOCATION = Goety.location("textures/entity/necromancer/drowned_necromancer.png");
    private static final ResourceLocation SERVANT_LOCATION = Goety.location("textures/entity/necromancer/drowned_necromancer_servant.png");

    public DrownedNecromancerRenderer(EntityRendererProvider.Context p_174382_) {
        super(p_174382_, new DrownedNecromancerModel(p_174382_.m_174023_(ModModelLayer.DROWNED_NECROMANCER)), 0.5f);
        this.m_115326_((RenderLayer)new NecromancerEyesLayer(this));
    }

    protected void scale(DrownedNecromancer necromancer, PoseStack matrixStackIn, float partialTickTime) {
        float original = 1.45f;
        float f1 = necromancer.getNecroLevel();
        float size = original + Math.max(f1 * 0.15f, 0.0f);
        matrixStackIn.m_85841_(size, size, size);
    }

    public ResourceLocation getTextureLocation(DrownedNecromancer p_115941_) {
        if (p_115941_.isHostile() || !((Boolean)MobsConfig.NecromancerServantTexture.get()).booleanValue()) {
            return SKELETON_LOCATION;
        }
        return SERVANT_LOCATION;
    }

    protected void setupRotations(DrownedNecromancer p_114109_, PoseStack p_114110_, float p_114111_, float p_114112_, float p_114113_) {
        super.m_7523_((LivingEntity)p_114109_, p_114110_, p_114111_, p_114112_, p_114113_);
        float f = p_114109_.m_20998_(p_114113_);
        if (f > 0.0f) {
            p_114110_.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)f, (float)p_114109_.m_146909_(), (float)(-10.0f - p_114109_.m_146909_()))));
        }
    }

    public static class NecromancerEyesLayer<T extends DrownedNecromancer, M extends DrownedNecromancerModel<T>>
    extends EyesLayer<T, M> {
        private static final ResourceLocation GLOW = Goety.location("textures/entity/necromancer/drowned_necromancer_glow.png");

        public NecromancerEyesLayer(RenderLayerParent<T, M> p_i50919_1_) {
            super(p_i50919_1_);
        }

        public RenderType m_5708_() {
            return RenderType.m_110488_((ResourceLocation)GLOW);
        }
    }
}

