/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.entities.projectiles.IceStorm;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public class IceStormRenderer
extends EntityRenderer<IceStorm> {
    private static final ResourceLocation ICE_STORM_LOCATION = Goety.location("textures/entity/projectiles/ice_storm.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110467_((ResourceLocation)ICE_STORM_LOCATION);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart cube;
    private final ModelPart glass;

    public IceStormRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.f_114477_ = 0.0f;
        ModelPart modelpart = renderManagerIn.m_174023_(ModelLayers.f_171145_);
        this.glass = modelpart.m_171324_("glass");
        this.cube = modelpart.m_171324_("cube");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("glass", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void render(IceStorm p_114162_, float p_114163_, float p_114164_, PoseStack p_114165_, MultiBufferSource p_114166_, int p_114167_) {
        p_114165_.m_85836_();
        float f1 = ((float)p_114162_.f_19797_ + p_114164_) * 3.0f;
        VertexConsumer vertexconsumer = p_114166_.m_6299_(RENDER_TYPE);
        p_114165_.m_85836_();
        float f2 = this.scale(p_114162_);
        p_114165_.m_85841_(f2, f2, f2);
        p_114165_.m_85841_(2.0f, 2.0f, 2.0f);
        int i = OverlayTexture.f_118083_;
        p_114165_.m_252781_(Axis.f_252436_.m_252977_(f1));
        p_114165_.m_85837_(0.0, 0.25, 0.0);
        p_114165_.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.m_104306_(p_114165_, vertexconsumer, p_114167_, i, 1.0f, 1.0f, 1.0f, 0.25f);
        p_114165_.m_85841_(0.875f, 0.875f, 0.875f);
        p_114165_.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        p_114165_.m_252781_(Axis.f_252436_.m_252977_(f1));
        this.glass.m_104306_(p_114165_, vertexconsumer, p_114167_, i, 1.0f, 1.0f, 1.0f, 0.5f);
        p_114165_.m_85841_(0.875f, 0.875f, 0.875f);
        p_114165_.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        p_114165_.m_252781_(Axis.f_252436_.m_252977_(f1));
        this.cube.m_104306_(p_114165_, vertexconsumer, p_114167_, i, 1.0f, 1.0f, 1.0f, 0.75f);
        p_114165_.m_85849_();
        p_114165_.m_85849_();
        super.m_7392_((Entity)p_114162_, p_114163_, p_114164_, p_114165_, p_114166_, p_114167_);
    }

    public float scale(IceStorm entityIn) {
        return 1.0f + entityIn.getSize() / 8.0f;
    }

    public ResourceLocation getTextureLocation(IceStorm entity) {
        return ICE_STORM_LOCATION;
    }
}

