/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.WebShotModel;
import com.Polarice3.Goety.common.entities.projectiles.SnarelingShot;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SnarelingShotRenderer<T extends SnarelingShot>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = Goety.location("textures/entity/projectiles/snareling_shot.png");
    private static final ResourceLocation TRAIL = Goety.location("textures/entity/projectiles/minor_trail.png");
    public WebShotModel<T> model;

    public SnarelingShotRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
        this.model = new WebShotModel(p_174008_.m_174023_(ModModelLayer.WEB_SHOT));
        this.f_114477_ = 0.5f;
    }

    public void render(T pEntity, float pYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, pEntity.m_20191_().m_82376_() * 0.5, 0.0);
        this.scale(pEntity, pPoseStack, 1.0f);
        Vec3 vec3 = pEntity.m_20184_();
        float xRot = -((float)(Mth.m_14136_((double)vec3.m_165924_(), (double)vec3.f_82480_) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.2957763671875) + 90.0f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        VertexConsumer consumer = pBuffer.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(pEntity)));
        this.model.m_7695_(pPoseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
        pPoseStack.m_85849_();
        if (((SnarelingShot)((Object)pEntity)).hasTrail()) {
            double x = Mth.m_14139_((double)pPartialTicks, (double)((SnarelingShot)((Object)pEntity)).f_19790_, (double)pEntity.m_20185_());
            double y = Mth.m_14139_((double)pPartialTicks, (double)((SnarelingShot)((Object)pEntity)).f_19791_, (double)pEntity.m_20186_());
            double z = Mth.m_14139_((double)pPartialTicks, (double)((SnarelingShot)((Object)pEntity)).f_19792_, (double)pEntity.m_20189_());
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(-x, -y, -z);
            ColorUtil colorUtil = new ColorUtil(16646082);
            this.renderTrail(pEntity, pPartialTicks, pPoseStack, pBuffer, colorUtil.red, colorUtil.green, colorUtil.blue, 0.6f, pPackedLight);
            pPoseStack.m_85849_();
        }
        super.m_7392_(pEntity, pYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return TEXTURE;
    }

    protected void scale(T p_116294_, PoseStack p_116295_, float p_116296_) {
        p_116295_.m_85841_(p_116296_, p_116296_, p_116296_);
    }

    private void renderTrail(T entityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, float red, float green, float blue, float alpha, int packedLightIn) {
        int sampleSize = 1;
        double trailHeight = 0.25;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, -trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = ((SnarelingShot)((Object)entityIn)).getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = ((SnarelingShot)((Object)entityIn)).getTrailPosition(samples + 8, partialTicks);
            Vec3 draw1 = drawFrom;
            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f2 = (float)(((SnarelingShot)((Object)entityIn)).f_19797_ % 8) / 8.0f;
            float f3 = f2 + 0.5f;
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)bottomAngleVec.f_82479_, (float)sample.f_82480_ + (float)bottomAngleVec.f_82480_, (float)sample.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)topAngleVec.f_82479_, (float)sample.f_82480_ + (float)topAngleVec.f_82480_, (float)sample.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }
}

