/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.SoulBoltModel;
import com.Polarice3.Goety.common.entities.projectiles.SoulBolt;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SoulBoltRenderer
extends EntityRenderer<SoulBolt> {
    private static final ResourceLocation TRAIL = Goety.location("textures/entity/projectiles/trail.png");
    private final SoulBoltModel<SoulBolt> model;

    public SoulBoltRenderer(EntityRendererProvider.Context p_174449_) {
        super(p_174449_);
        this.model = new SoulBoltModel(p_174449_.m_174023_(ModModelLayer.SOUL_BOLT));
    }

    protected int getBlockLightLevel(SoulBolt p_116491_, BlockPos p_116492_) {
        return 15;
    }

    public void render(SoulBolt entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(-1.25f, -1.25f, 1.25f);
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_());
        float f1 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(entityIn)));
        this.model.setupAnim(0.0f, f, f1);
        this.model.m_7695_(matrixStackIn, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
        matrixStackIn.m_85849_();
        if (entityIn.hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-x, -y, -z);
            ColorUtil colorUtil = new ColorUtil(0xDAFDFF);
            this.renderTrail(entityIn, partialTicks, matrixStackIn, bufferIn, colorUtil.red, colorUtil.green, colorUtil.blue, 0.6f, packedLightIn);
            matrixStackIn.m_85849_();
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderTrail(SoulBolt entityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, float red, float green, float blue, float alpha, int packedLightIn) {
        int sampleSize = 1;
        double trailHeight = 0.25;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, -trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 8, partialTicks);
            Vec3 draw1 = drawFrom;
            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f2 = (float)(entityIn.f_19797_ % 8) / 8.0f;
            float f3 = f2 + 0.5f;
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)bottomAngleVec.f_82479_, (float)sample.f_82480_ + (float)bottomAngleVec.f_82480_, (float)sample.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)topAngleVec.f_82479_, (float)sample.f_82480_ + (float)topAngleVec.f_82480_, (float)sample.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f3, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(red, green, blue, alpha).m_7421_(f2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }

    public ResourceLocation getTextureLocation(SoulBolt p_116482_) {
        return p_116482_.getResourceLocation();
    }
}

