/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.VoidShockBombModel;
import com.Polarice3.Goety.common.entities.projectiles.VoidShockBomb;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class VoidShockBombRenderer
extends EntityRenderer<VoidShockBomb> {
    private static final ResourceLocation OUTER_TEXTURES = Goety.location("textures/entity/projectiles/void_shock_bomb_outer.png");
    private static final ResourceLocation INNER_TEXTURES = Goety.location("textures/entity/projectiles/void_shock_bomb_inner.png");
    private static final ResourceLocation TRAIL_TEXTURE = Goety.location("textures/entity/projectiles/trail.png");
    private final VoidShockBombModel<VoidShockBomb> model;
    private final RandomSource random = RandomSource.m_216327_();

    public VoidShockBombRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.model = new VoidShockBombModel(renderManagerIn.m_174023_(ModModelLayer.VOID_SHOCK_BOMB));
    }

    public void render(VoidShockBomb entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.growTick <= 0) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(entityYaw * ((float)Math.PI / 180), 0.0f, -1.0f, 0.0f));
            VertexConsumer VertexConsumer2 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(entityIn)));
            this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, 0.0f, 0.0f);
            this.model.m_7695_(matrixStackIn, VertexConsumer2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumer VertexConsumer22 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)OUTER_TEXTURES));
            this.model.m_7695_(matrixStackIn, VertexConsumer22, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.4f);
            matrixStackIn.m_85849_();
            if (entityIn.hasTrail()) {
                double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
                double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
                double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
                float randomF = 0.04f;
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                float r = colorUtil.red() + this.random.m_188501_() * randomF;
                float g = colorUtil.green() + this.random.m_188501_() * randomF;
                float b = colorUtil.blue() + this.random.m_188501_() * randomF;
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(-x, -y, -z);
                this.renderTrail(entityIn, partialTicks, matrixStackIn, bufferIn, r, g, b, 1.0f, packedLightIn);
                matrixStackIn.m_85849_();
            }
        } else {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(entityYaw * ((float)Math.PI / 180), 0.0f, -1.0f, 0.0f));
            float scale2 = entityIn.size;
            matrixStackIn.m_85837_(0.0, (double)scale2 / 4.0, 0.0);
            matrixStackIn.m_85841_(-scale2, -scale2, scale2);
            VertexConsumer VertexConsumer3 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(entityIn)));
            this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, 0.0f, 0.0f);
            this.model.m_7695_(matrixStackIn, VertexConsumer3, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, entityIn.alpha);
            matrixStackIn.m_85849_();
        }
    }

    private void renderTrail(VoidShockBomb entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn) {
        int sampleSize = 10;
        float trailHeight = 0.5f;
        float trailYRot = 0.0f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3((double)trailHeight, (double)trailHeight, 0.0).m_82524_(trailYRot).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3((double)(-trailHeight), (double)(-trailHeight), 0.0).m_82524_(trailYRot).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 2, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            this.addVertex(vertexconsumer, matrix4f, matrix3f, drawFrom, bottomAngleVec, trailR, trailG, trailB, u1, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, sample, bottomAngleVec, trailR, trailG, trailB, u2, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, sample, topAngleVec, trailR, trailG, trailB, u2, 0.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, drawFrom, topAngleVec, trailR, trailG, trailB, u1, 0.0f, packedLightIn);
            drawFrom = sample;
        }
    }

    private void addVertex(VertexConsumer consumer, Matrix4f matrix, Matrix3f matrix3, Vec3 pos, Vec3 offset, float r, float g, float b, float u, float v, int light) {
        consumer.m_252986_(matrix, (float)(pos.f_82479_ + offset.f_82479_), (float)(pos.f_82480_ + offset.f_82480_), (float)(pos.f_82481_ + offset.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected int getBlockLightLevel(VoidShockBomb entityIn, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(VoidShockBomb entity) {
        return INNER_TEXTURES;
    }
}

