/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.layer.HierarchicalArmor;
import com.Polarice3.Goety.common.entities.ally.illager.IceologerServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.BoundIceologer;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;

public class IceologerModel<T extends LivingEntity>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
HierarchicalArmor {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart upperBody;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart body;
    private final ModelPart clothes;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    public static final AnimationDefinition IDLE = AnimationDefinition.Builder.m_232275_((float)2.95f).m_232274_().m_232279_("upperBody", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.95f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.95f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.0f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.95f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.0f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.95f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("cape", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)-10.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.95f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232282_();
    public static final AnimationDefinition SPELL = AnimationDefinition.Builder.m_232275_((float)3.3f).m_232279_("upperBody", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.35f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)-30.0f, (float)12.5f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)-25.4724f, (float)-6.509f, (float)-6.8912f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8f, KeyframeAnimations.m_253186_((float)-40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.05f, KeyframeAnimations.m_253186_((float)-42.5f, (float)10.0f, (float)-3.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.3f, KeyframeAnimations.m_253186_((float)27.5f, (float)-10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)27.5f, (float)-10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upperBody", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.35f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.55f, KeyframeAnimations.m_253186_((float)10.0303f, (float)12.497f, (float)0.2771f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)-2.5107f, (float)-0.1631f, (float)7.4982f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.05f, KeyframeAnimations.m_253186_((float)-9.14f, (float)-4.7137f, (float)-6.3135f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.3f, KeyframeAnimations.m_253186_((float)-25.0f, (float)5.0f, (float)-6.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)-25.0f, (float)5.0f, (float)-6.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.35f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)-10.0f, (float)-10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.55f, KeyframeAnimations.m_253186_((float)-96.0295f, (float)-11.9586f, (float)52.6054f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)-140.0f, (float)-10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)-100.0f, (float)-20.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8f, KeyframeAnimations.m_253186_((float)-187.5f, (float)-20.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.05f, KeyframeAnimations.m_253186_((float)-186.868f, (float)-19.631f, (float)-7.5175f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.3f, KeyframeAnimations.m_253186_((float)-56.4138f, (float)-7.1672f, (float)-7.1198f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)-56.4138f, (float)-7.1672f, (float)-7.1198f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.35f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.55f, KeyframeAnimations.m_253186_((float)-30.0f, (float)2.5f, (float)7.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)-72.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)-60.7838f, (float)8.6342f, (float)22.0555f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8f, KeyframeAnimations.m_253186_((float)-60.1585f, (float)6.8859f, (float)8.0535f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.05f, KeyframeAnimations.m_253186_((float)-60.1585f, (float)6.8859f, (float)8.0535f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.3f, KeyframeAnimations.m_253186_((float)-30.6164f, (float)12.4617f, (float)0.621f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)64.3836f, (float)12.4617f, (float)0.621f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("cape", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.35f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)7.4229f, (float)-13.6127f, (float)-1.3157f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8f, KeyframeAnimations.m_253186_((float)9.7873f, (float)-4.4399f, (float)12.6903f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.05f, KeyframeAnimations.m_253186_((float)14.7873f, (float)-4.4399f, (float)12.6903f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.3f, KeyframeAnimations.m_253186_((float)4.8658f, (float)-4.7706f, (float)3.4965f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)12.3658f, (float)-4.7706f, (float)3.4965f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.8f, KeyframeAnimations.m_253186_((float)12.3658f, (float)-4.7706f, (float)3.4965f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("nose", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.35f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-7.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.05f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)7.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.15f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232282_();
    public static final AnimationDefinition WALK = AnimationDefinition.Builder.m_232275_((float)1.45f).m_232274_().m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-22.5f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)20.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)-22.5f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.15f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("leftLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)32.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)17.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)32.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("leftLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.5f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upperBody", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-7.5f, (float)-5.0f, (float)-1.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)-7.5f, (float)-5.0f, (float)-1.5f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upperBody", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-1.5f, (float)5.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-1.0f, (float)3.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-1.5f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-1.0f, (float)-0.5f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-1.5f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)-1.0f, (float)3.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)-1.5f, (float)5.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.25f, (float)-0.1f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.25f, (float)-0.2f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.25f, (float)-0.1f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)10.0f, (float)-15.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)10.0f, (float)-15.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-7.5f, (float)-15.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.85f, KeyframeAnimations.m_253186_((float)-10.0f, (float)-15.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.05f, KeyframeAnimations.m_253186_((float)-10.0f, (float)-15.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)10.0f, (float)-15.0f, (float)2.5f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-18.0f, (float)2.5f, (float)10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.55f, KeyframeAnimations.m_253186_((float)27.5f, (float)2.5f, (float)10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)45.0f, (float)2.5f, (float)10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9f, KeyframeAnimations.m_253186_((float)45.0f, (float)2.5f, (float)10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)-18.0f, (float)2.5f, (float)10.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("cape", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)-7.5f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-2.5f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.45f, KeyframeAnimations.m_253186_((float)0.0f, (float)-7.5f, (float)5.0f), AnimationChannel.Interpolations.f_232230_)})).m_232282_();

    public IceologerModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.rightLeg = this.illager.m_171324_("rightLeg");
        this.leftLeg = this.illager.m_171324_("leftLeg");
        this.upperBody = this.illager.m_171324_("upperBody");
        this.body = this.upperBody.m_171324_("body");
        this.clothes = this.body.m_171324_("clothes");
        this.head = this.upperBody.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.rightArm = this.upperBody.m_171324_("right_arm");
        this.leftArm = this.upperBody.m_171324_("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = illager.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.97f, (float)12.0f, (float)0.5f, (float)0.1309f, (float)0.0f, (float)0.0524f));
        PartDefinition leftLeg = illager.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.2f, (float)-0.0873f, (float)0.0f, (float)-0.0873f));
        PartDefinition upperBody = illager.m_171599_("upperBody", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.3491f, (float)0.0436f, (float)0.0175f));
        PartDefinition body = upperBody.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition clothes = body.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = upperBody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.25f, (float)-12.0f, (float)0.0f, (float)-0.1527f, (float)0.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.25f, -34.5f, -4.5f, 9.0f, 11.0f, 9.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)-0.25f, (float)24.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-4.0f));
        PartDefinition right_arm = upperBody.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.25f, (float)-10.0f, (float)0.8f, (float)0.1745f, (float)0.2618f, (float)-0.0436f));
        PartDefinition left_arm = upperBody.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.25f, (float)-9.8f, (float)0.0f, (float)-0.4363f, (float)-0.0436f, (float)-0.1745f));
        PartDefinition cape = upperBody.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-4.5f, -1.0f, 0.5f, 9.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0f, (float)3.0f, (float)0.3054f, (float)0.1309f, (float)-0.0873f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RaiderServant servant;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) - MathHelper.modelDegrees(8.75f);
        if (entity instanceof IceologerServant) {
            servant = (IceologerServant)entity;
            this.m_233381_(((IceologerServant)servant).idleAnimationState, IDLE, ageInTicks);
            this.m_233381_(((IceologerServant)servant).attackAnimationState, SPELL, ageInTicks);
            if (((IceologerServant)servant).getCurrentAnimation() != ((IceologerServant)servant).getAnimationState("attack")) {
                this.m_267799_(WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            }
        }
        if (entity instanceof BoundIceologer) {
            servant = (BoundIceologer)entity;
            this.m_233381_(((BoundIceologer)servant).idleAnimationState, IDLE, ageInTicks);
            this.m_233381_(((BoundIceologer)servant).attackAnimationState, SPELL, ageInTicks);
            if (((BoundIceologer)servant).getCurrentAnimation() != ((BoundIceologer)servant).getAnimationState("attack")) {
                this.m_267799_(WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            }
        }
        boolean flag2 = entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem || entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
        this.clothes.f_104207_ = !flag2;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHat() {
        return this.hat;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        this.getArm(arm).m_104299_(poseStack);
    }

    @Override
    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    @Override
    public void translateToArms(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.upperBody.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightArm);
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftArm);
    }

    @Override
    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.rightLeg);
    }

    @Override
    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

