/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.ally.illager.Ravaged;
import com.Polarice3.Goety.utils.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class RavagedModel<T extends Ravaged>
extends HierarchicalModel<T> {
    private final ModelPart ghoul;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart body;

    public RavagedModel(ModelPart root) {
        this.ghoul = root.m_171324_("ghoul");
        this.head = this.ghoul.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth");
        this.rightArm = this.ghoul.m_171324_("rightArm");
        this.leftArm = this.ghoul.m_171324_("leftArm");
        this.rightLeg = this.ghoul.m_171324_("rightLeg");
        this.leftLeg = this.ghoul.m_171324_("leftLeg");
        this.body = this.ghoul.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition ghoul = partdefinition.m_171599_("ghoul", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = ghoul.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.0f, -8.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)-6.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-9.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, 0.0f, -6.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-2.0f));
        PartDefinition body = ghoul.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 17).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 35).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)18.0f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = ghoul.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(28, 35).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(44, 19).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)-4.0f));
        PartDefinition leftArm = ghoul.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(44, 35).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(44, 19).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)-4.0f));
        PartDefinition rightLeg = ghoul.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-12.0f, (float)6.0f));
        PartDefinition leftLeg = ghoul.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)-12.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104204_ = 0.0f;
        float f = 0.4f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * f;
        this.rightArm.f_104203_ = -MathHelper.modelDegrees(15.0f) + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * f;
        this.leftArm.f_104203_ = -MathHelper.modelDegrees(15.0f) + Mth.m_14089_((float)(limbSwing * 0.6662f)) * f;
        this.rightArm.f_104204_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.setupAttackAnimation(entity);
    }

    public void prepareMobModel(T pEntity, float limbSwing, float limbSwingAmount, float pPartialTick) {
        super.m_6839_(pEntity, limbSwing, limbSwingAmount, pPartialTick);
        int b = ((Ravaged)pEntity).getBitingTick();
        this.mouth.f_104203_ = b > 0 ? (b > 5 ? Mth.m_14031_((float)(((float)(-4 + b) - pPartialTick) / 4.0f)) * (float)Math.PI * 0.4f : 0.15707964f * Mth.m_14031_((float)((float)Math.PI * ((float)b - pPartialTick) / 10.0f))) : 0.03141593f;
    }

    protected void setupAttackAnimation(T pEntity) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm handside = this.getAttackArm(pEntity);
            ModelPart modelrenderer = this.getArm(handside);
            float f = this.f_102608_;
            this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                this.body.f_104204_ *= -1.0f;
            }
            this.rightArm.f_104200_ = -Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
            this.leftArm.f_104200_ = Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
            this.rightArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104203_ += this.body.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            modelrenderer.f_104203_ = (float)((double)modelrenderer.f_104203_ - ((double)f1 * 1.2 + (double)f2));
            modelrenderer.f_104204_ += this.body.f_104204_ * 2.0f;
            modelrenderer.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    protected HumanoidArm getAttackArm(T pEntity) {
        HumanoidArm handside = pEntity.m_5737_();
        return ((Ravaged)pEntity).f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }

    protected ModelPart getArm(HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.ghoul.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.ghoul;
    }
}

