/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class SpecterModel<T extends Mob>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart Ghost;
    private final ModelPart head;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart body;

    public SpecterModel(ModelPart root) {
        this.root = root;
        this.Ghost = root.m_171324_("Ghost");
        this.head = this.Ghost.m_171324_("head");
        this.right_arm = this.Ghost.m_171324_("right_arm");
        this.left_arm = this.Ghost.m_171324_("left_arm");
        this.body = this.Ghost.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Ghost = partdefinition.m_171599_("Ghost", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = Ghost.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(40, 16).m_171488_(-4.0f, -8.0f, 4.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-23.0f, (float)0.0f));
        PartDefinition right_arm = Ghost.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)-22.0f, (float)0.0f));
        PartDefinition right_robe = right_arm.m_171599_("right_robe", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(-2.0f, -3.0f, 2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = Ghost.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-22.0f, (float)0.0f));
        PartDefinition left_robe = left_arm.m_171599_("left_robe", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171480_().m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(16, 34).m_171488_(-2.0f, -3.0f, 2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = Ghost.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition robe = body.m_171599_("robe", CubeListBuilder.m_171558_().m_171514_(40, 28).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Mob entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks * 0.0025f;
        this.Ghost.f_104201_ = Mth.m_14031_((float)(f * 40.0f)) + 24.0f;
        float f4 = Math.min(limbSwingAmount / 0.3f, 1.0f);
        this.body.f_104203_ = f4 * MathHelper.modelDegrees(40.0f);
        this.body.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.1f + 0.1f;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        SpecterModel.animateArms(this.left_arm, this.right_arm, this.f_102608_, ageInTicks);
    }

    public static void animateArms(ModelPart leftArm, ModelPart rightArm, float attackTime, float ageInTicks) {
        float f2;
        float f = Mth.m_14031_((float)(attackTime * (float)Math.PI));
        float f1 = Mth.m_14031_((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        rightArm.f_104205_ = 0.0f;
        leftArm.f_104205_ = 0.0f;
        rightArm.f_104204_ = -0.1f;
        leftArm.f_104204_ = 0.1f;
        rightArm.f_104203_ = f2 = -MathHelper.modelDegrees(45.0f);
        leftArm.f_104203_ = f2;
        rightArm.f_104203_ += f * 1.2f - f1 * 0.4f;
        leftArm.f_104203_ += f * 1.2f - f1 * 0.4f;
        AnimationUtils.m_102082_((ModelPart)rightArm, (ModelPart)leftArm, (float)ageInTicks);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

