/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.projectiles.AbstractWave;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class TidalSurgeModel<T extends AbstractWave>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart wave;
    private final ModelPart top;

    public TidalSurgeModel(ModelPart root) {
        this.root = root;
        this.wave = root.m_171324_("wave");
        this.top = this.wave.m_171324_("top");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition wave = partdefinition.m_171599_("wave", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-13.0f, -5.7f, 1.0f, 26.0f, 6.0f, 12.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition top = wave.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-13.0f, -8.0f, 0.0f, 26.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.25f, (float)1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = (float)((Math.sin(ageInTicks * 0.1f) + 1.0) * (double)0.2f);
        float waveScale = ((AbstractWave)((Object)entity)).getWaveScale();
        float stretch = Math.min(40.0f, ageInTicks) / 40.0f;
        float slam = ((AbstractWave)((Object)entity)).getSlamAmount(ageInTicks - (float)((AbstractWave)((Object)entity)).activeWaveTicks) * 1.4f;
        this.slamPos(this.top, slam, 0.0f, -1.0f, 7.5f);
        this.top.f_104203_ += f;
        this.top.f_104201_ += f * 8.0f;
        this.top.f_104202_ += f * 2.0f;
        this.scale(this.wave, waveScale, waveScale, waveScale + stretch);
        this.scale(this.top, waveScale, waveScale, waveScale + stretch);
        this.top.f_104201_ += stretch * 2.0f;
        this.top.f_104202_ += stretch * 2.0f;
    }

    public void scale(ModelPart modelPart, float x, float y, float z) {
        modelPart.f_233553_ = x;
        modelPart.f_233554_ = y;
        modelPart.f_233555_ = z;
    }

    public void slamRot(ModelPart model, float slam, float xRot, float yRot, float zRot) {
        Vector3f vector3f = new Vector3f(slam * xRot, slam * yRot, slam * zRot);
        model.m_252899_(vector3f);
    }

    public void slamPos(ModelPart model, float slam, float x, float y, float z) {
        Vector3f vector3f = new Vector3f(slam * x, slam * y, slam * z);
        model.m_252854_(vector3f);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

