/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.WightAnimations;
import com.Polarice3.Goety.common.entities.hostile.Wight;
import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;

public class WightModel<T extends Wight>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart wight;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart right_lower_leg;
    private final ModelPart left_lower_leg;

    public WightModel(ModelPart root) {
        this.root = root;
        this.wight = root.m_171324_("wight");
        this.body = this.wight.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.right_arm = this.body.m_171324_("right_arm");
        this.left_arm = this.body.m_171324_("left_arm");
        this.right_leg = this.wight.m_171324_("right_leg");
        this.left_leg = this.wight.m_171324_("left_leg");
        this.right_lower_leg = this.right_leg.m_171324_("right_lower_leg");
        this.left_lower_leg = this.left_leg.m_171324_("left_lower_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition wight = partdefinition.m_171599_("wight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition body = wight.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171488_(-5.0f, -8.0f, -3.0f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body_r1 = body.m_171599_("Body_r1", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-8.0f, -4.0f, -5.0f, 16.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition body_robe = body.m_171599_("body_robe", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.5f));
        PartDefinition Body_r2 = body_robe.m_171599_("Body_r2", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-8.0f, -6.0f, -5.0f, 16.0f, 10.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)-2.0f));
        PartDefinition top = head.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -6.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition robe = top.m_171599_("robe", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -6.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(0, 75).m_171488_(-6.0f, -8.0f, -8.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-3.5f, 0.0f, -6.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(48, 30).m_171488_(-3.0f, -2.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_lower = right_arm.m_171599_("right_lower", CubeListBuilder.m_171558_().m_171514_(48, 47).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 22).m_171488_(-1.5f, 11.5f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(50, 18).m_171488_(-1.5f, 15.5f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)13.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 30).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_lower = left_arm.m_171599_("left_lower", CubeListBuilder.m_171558_().m_171514_(48, 47).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 22).m_171480_().m_171488_(-1.5f, 11.5f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(50, 18).m_171480_().m_171488_(-1.5f, 15.5f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition right_leg = wight.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(56, 30).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_lower_leg = right_leg.m_171599_("right_lower_leg", CubeListBuilder.m_171558_().m_171514_(56, 47).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition left_leg = wight.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(56, 30).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_lower_leg = left_leg.m_171599_("left_lower_leg", CubeListBuilder.m_171558_().m_171514_(56, 47).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            boolean isCrouching;
            boolean bl = isCrouching = entity.m_20089_() == Pose.CROUCHING;
            if (isCrouching) {
                this.m_233381_(((Wight)entity).idleAnimationState, WightAnimations.CROUCH, ageInTicks);
            } else {
                this.m_233381_(((Wight)entity).idleAnimationState, WightAnimations.IDLE, ageInTicks);
            }
            if (!((Wight)entity).isMeleeAttacking()) {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
                if (isCrouching) {
                    this.head.f_104203_ -= MathHelper.modelDegrees(75.0f);
                }
                if (((Wight)entity).isClimbing()) {
                    this.m_267799_(WightAnimations.CLIMB, limbSwing, limbSwingAmount, 2.5f, 1.0f);
                } else {
                    this.m_267799_(WightAnimations.WALK, limbSwing, limbSwingAmount, 5.0f, 1.0f);
                }
            } else if (!isCrouching) {
                boolean flag = entity.m_21256_() > 4;
                float f = 1.0f;
                if (flag) {
                    f = (float)entity.m_20184_().m_82556_();
                    f /= 0.2f;
                    f *= f * f;
                }
                if (f < 1.0f) {
                    f = 1.0f;
                }
                this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
                this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
                if (this.right_leg.f_104203_ > 0.4f) {
                    this.right_leg.f_104203_ = 0.4f;
                }
                if (this.left_leg.f_104203_ > 0.4f) {
                    this.left_leg.f_104203_ = 0.4f;
                }
                if (this.right_leg.f_104203_ < -0.4f) {
                    this.right_leg.f_104203_ = -0.4f;
                }
                if (this.left_leg.f_104203_ < -0.4f) {
                    this.left_leg.f_104203_ = -0.4f;
                }
            }
            if (isCrouching) {
                this.m_233381_(((Wight)entity).attackAnimationState, WightAnimations.CROUCH_ATTACK, ageInTicks);
                this.m_233381_(((Wight)entity).smashAnimationState, WightAnimations.CROUCH_SMASH, ageInTicks);
            } else {
                this.m_233381_(((Wight)entity).attackAnimationState, WightAnimations.ATTACK, ageInTicks);
                this.m_233381_(((Wight)entity).smashAnimationState, WightAnimations.SMASH, ageInTicks);
            }
            this.m_233381_(((Wight)entity).unleashAnimationState, WightAnimations.UNLEASH, ageInTicks);
            this.m_233381_(((Wight)entity).summonAnimationState, WightAnimations.SUMMON, ageInTicks);
            this.m_233381_(((Wight)entity).superSmashAnimationState, WightAnimations.SUPER_SMASH, ageInTicks);
        } else {
            this.right_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.left_arm.f_104203_ = -Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.right_arm.f_104205_ = 2.3561945f;
            this.left_arm.f_104205_ = -2.3561945f;
            this.right_leg.f_104203_ = 0.0f;
            this.right_leg.f_104204_ = 0.0f;
            this.right_leg.f_104205_ = 0.0f;
            this.left_leg.f_104203_ = 0.0f;
            this.left_leg.f_104204_ = 0.0f;
            this.left_leg.f_104205_ = 0.0f;
            this.right_lower_leg.f_104203_ = 0.0f;
            this.right_lower_leg.f_104204_ = 0.0f;
            this.right_lower_leg.f_104205_ = 0.0f;
            this.left_lower_leg.f_104203_ = 0.0f;
            this.left_lower_leg.f_104204_ = 0.0f;
            this.left_lower_leg.f_104205_ = 0.0f;
            this.head.f_104203_ = -MathHelper.modelDegrees(45.0f);
            this.head.f_104204_ = this.body.f_104204_;
            this.jaw.f_104203_ = MathHelper.modelDegrees(25.0f);
        }
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

