/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.IWindPowered;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.WindBlowParticle;
import com.Polarice3.Goety.common.blocks.WindBlowerBlock;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindBlowerBlockEntity
extends BlockEntity {
    public WindBlowerBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.WIND_BLOWER.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof WindBlowerBlock) {
            Direction facing = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)WindBlowerBlock.f_52588_);
            double power = ((Integer)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)WindBlowerBlock.POWER)).intValue();
            boolean active = power > 0.0;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_);
            if (blockEntity instanceof WindBlowerBlockEntity) {
                WindBlowerBlockEntity fan = (WindBlowerBlockEntity)blockEntity;
                if (this.f_58857_.m_46467_() % 2L == 0L && this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof WindBlowerBlock && active) {
                    fan.blowEntities();
                }
                if (!this.f_58857_.f_46443_) {
                    this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this.f_58857_.m_8055_(this.m_58899_()), 8);
                }
                if (this.f_58857_.f_46443_ && active && this.f_58857_.f_46441_.m_188501_() <= 0.25f) {
                    Vec3 pos = WindBlowerBlockEntity.getCenterOf((Vec3i)this.m_58899_()).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.5));
                    Vec3 direction = Vec3.m_82528_((Vec3i)facing.m_122436_());
                    Vec3 motion = direction.m_82490_(0.125);
                    double distance = new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()).m_82546_(WindBlowerBlockEntity.getCenterOf((Vec3i)this.m_58899_())).m_82559_(direction).m_82553_() - 0.5;
                    motion = motion.m_82490_(power - (distance - 1.0)).m_82490_(0.5);
                    this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.FAN_CLOUD.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    pos = pos.m_272010_(this.f_58857_.m_213780_(), 1.01f);
                    int width = this.f_58857_.m_213780_().m_216332_(1, 4);
                    float height = this.f_58857_.m_213780_().m_188501_() * 0.5f;
                    this.f_58857_.m_7106_((ParticleOptions)new WindBlowParticle.Option(ColorUtil.WHITE, width, height), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)WindBlowerBlock.POWERED, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return new Vec3(0.5, 0.5, 0.5);
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }

    public AABB getAABB() {
        if (this.f_58857_ != null) {
            int distance;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            if (!(state.m_60734_() instanceof WindBlowerBlock)) {
                return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            Direction facing = (Direction)state.m_61143_((Property)WindBlowerBlock.f_52588_);
            for (distance = 1; distance < (Integer)state.m_61143_((Property)WindBlowerBlock.POWER); ++distance) {
                BlockPos blockPos = this.m_58899_().m_5484_(facing, distance);
                BlockState state2 = this.f_58857_.m_8055_(blockPos);
                BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
                if (blockEntity instanceof IWindPowered) {
                    IWindPowered windPowered = (IWindPowered)blockEntity;
                    windPowered.activate(20);
                }
                if (state2.m_60734_() instanceof BaseFireBlock && !this.f_58857_.m_8055_(blockPos.m_7495_()).isFireSource((LevelReader)this.f_58857_, blockPos.m_7495_(), Direction.UP)) {
                    this.f_58857_.m_7471_(blockPos, false);
                    this.f_58857_.m_5898_((Player)null, 1009, blockPos, 0);
                }
                if (state2.m_280296_() && state2.m_60804_((BlockGetter)this.f_58857_, blockPos) || state2.m_278721_()) break;
            }
            BlockPos blockPos2 = this.m_58899_().m_5484_(facing, distance);
            switch (facing) {
                case UP: 
                case EAST: 
                case SOUTH: {
                    blockPos2 = blockPos2.m_7918_(1, 1, 1);
                    break;
                }
                case DOWN: {
                    blockPos2 = blockPos2.m_7918_(1, 0, 1);
                    break;
                }
                case WEST: {
                    blockPos2 = blockPos2.m_7918_(0, 1, 1);
                    break;
                }
                case NORTH: {
                    blockPos2 = blockPos2.m_7918_(1, 1, 0);
                }
            }
            return new AABB(this.m_58899_(), blockPos2);
        }
        return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    protected void blowEntities() {
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            if (!(state.m_60734_() instanceof WindBlowerBlock)) {
                return;
            }
            Direction facing = (Direction)state.m_61143_((Property)WindBlowerBlock.f_52588_);
            List list = this.f_58857_.m_6443_(Entity.class, this.getAABB(), EntitySelector.f_20406_);
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity) && !(entity instanceof AbstractArrow) || entity.m_6095_().m_204039_(ModTags.EntityTypes.UNBLOWABLE_ENTITIES)) continue;
                Vec3 vec3d = entity.m_20184_();
                double y = vec3d.f_82480_;
                if (facing.m_122434_().m_122479_()) {
                    double strength = MobUtil.isShifting(entity) ? 0.0 : 0.2;
                    MobUtil.push(entity, (double)Mth.m_14031_((float)(facing.m_122424_().m_122435_() * (float)Math.PI / 180.0f)) * strength, 0.0, (double)(-Mth.m_14089_((float)(facing.m_122424_().m_122435_() * (float)Math.PI / 180.0f))) * strength);
                    continue;
                }
                if (facing == Direction.UP) {
                    if (MobUtil.isShifting(entity)) {
                        if (y < 0.0) {
                            y *= 0.9;
                        }
                    } else {
                        y += 0.2;
                        y = Mth.m_14008_((double)y, (double)-0.35, (double)0.35);
                    }
                    double resist = 0.0;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        resist = living.m_21133_(Attributes.f_22278_);
                    }
                    double resist1 = Math.max(0.0, 1.0 - resist);
                    entity.m_20256_(new Vec3(vec3d.f_82479_, y, vec3d.f_82481_).m_82490_(resist1));
                    entity.m_183634_();
                    continue;
                }
                MobUtil.push(entity, 0.0, -0.2, 0.0);
            }
        }
    }
}

