/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities.void_vault;

import com.Polarice3.Goety.common.blocks.entities.VoidVaultBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawner;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultConfig;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultServerData;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultSharedData;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VoidVaultState implements StringRepresentable
{
    INACTIVE("inactive", Light.HALF_LIT){

        @Override
        protected void onChangedTo(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
            sharedData.setDisplayItem(ItemStack.f_41583_);
            VoidVaultBlockEntity.Client.spawnDeactivateParticles((Level)world, pos);
            world.m_5594_(null, pos, (SoundEvent)ModSounds.VOID_VAULT_DEACTIVATE.get(), SoundSource.BLOCKS, 1.0f, (world.m_213780_().m_188501_() - world.m_213780_().m_188501_()) * 0.2f + 1.0f);
        }
    }
    ,
    ACTIVE("active", Light.LIT){

        @Override
        protected void onChangedTo(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
            BlockEntity blockEntity;
            if (!sharedData.hasDisplayItem()) {
                VoidVaultBlockEntity.Server.updateDisplayItem(world, this, config, sharedData, pos);
            }
            if ((blockEntity = world.m_7702_(pos)) instanceof VoidVaultBlockEntity) {
                VoidVaultBlockEntity vaultBlockEntity = (VoidVaultBlockEntity)blockEntity;
                VoidVaultBlockEntity.Client.spawnActivateParticles((Level)world, vaultBlockEntity.m_58899_(), vaultBlockEntity.m_58900_(), vaultBlockEntity.getSharedData());
                world.m_5594_(null, pos, (SoundEvent)ModSounds.VOID_VAULT_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, (world.m_213780_().m_188501_() - world.m_213780_().m_188501_()) * 0.2f + 1.0f);
            }
        }
    }
    ,
    UNLOCKING("unlocking", Light.LIT){

        @Override
        protected void onChangedTo(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
            world.m_247517_(null, pos, (SoundEvent)ModSounds.VOID_VAULT_INSERT.get(), SoundSource.BLOCKS);
        }
    }
    ,
    EJECTING("ejecting", Light.LIT){

        @Override
        protected void onChangedTo(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
            world.m_247517_(null, pos, (SoundEvent)ModSounds.VOID_VAULT_OPEN_SHUTTER.get(), SoundSource.BLOCKS);
        }

        @Override
        protected void onChangedFrom(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
            world.m_247517_(null, pos, (SoundEvent)ModSounds.VOID_VAULT_CLOSE_SHUTTER.get(), SoundSource.BLOCKS);
        }
    };

    private final String id;
    private final Light light;

    private VoidVaultState(String id, Light light) {
        this.id = id;
        this.light = light;
    }

    public String m_7912_() {
        return this.id;
    }

    public int getLuminance() {
        return this.light.luminance;
    }

    public VoidVaultState update(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultServerData serverData, VoidVaultSharedData sharedData) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case INACTIVE -> VoidVaultState.updateActiveState(world, pos, config, serverData, sharedData, config.activationRange());
            case ACTIVE -> VoidVaultState.updateActiveState(world, pos, config, serverData, sharedData, config.deactivationRange());
            case UNLOCKING -> {
                serverData.setStateUpdatingResumeTime(world.m_46467_() + 20L);
                yield EJECTING;
            }
            case EJECTING -> {
                if (serverData.getItemsToEject().isEmpty()) {
                    serverData.finishEjecting();
                    yield VoidVaultState.updateActiveState(world, pos, config, serverData, sharedData, config.deactivationRange());
                }
                float f = serverData.getEjectSoundPitchModifier();
                this.ejectItem(world, pos, serverData.getItemToEject(), f);
                sharedData.setDisplayItem(serverData.getItemToDisplay());
                boolean bl = serverData.getItemsToEject().isEmpty();
                int i = bl ? 20 : 20;
                serverData.setStateUpdatingResumeTime(world.m_46467_() + (long)i);
                yield EJECTING;
            }
        };
    }

    private static VoidVaultState updateActiveState(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultServerData serverData, VoidVaultSharedData sharedData, double radius) {
        sharedData.updateConnectedPlayers(world, pos, serverData, config, radius);
        serverData.setStateUpdatingResumeTime(world.m_46467_() + 20L);
        return sharedData.hasConnectedPlayers() ? ACTIVE : INACTIVE;
    }

    public void onStateChange(ServerLevel world, BlockPos pos, VoidVaultState newState, VoidVaultConfig config, VoidVaultSharedData sharedData) {
        this.onChangedFrom(world, pos, config, sharedData);
        newState.onChangedTo(world, pos, config, sharedData);
    }

    protected void onChangedTo(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
    }

    protected void onChangedFrom(ServerLevel world, BlockPos pos, VoidVaultConfig config, VoidVaultSharedData sharedData) {
    }

    private void ejectItem(ServerLevel world, BlockPos pos, ItemStack stack, float pitchModifier) {
        DefaultDispenseItemBehavior.m_123378_((Level)world, (ItemStack)stack, (int)2, (Direction)Direction.UP, (Position)Vec3.m_82539_((Vec3i)pos).m_231075_(Direction.UP, 1.2));
        VoidSpawner.addEjectItemParticles(world, pos, world.m_213780_());
        world.m_5594_(null, pos, (SoundEvent)ModSounds.VOID_VAULT_EJECT_ITEM.get(), SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * pitchModifier);
    }

    static enum Light {
        HALF_LIT(6),
        LIT(12);

        final int luminance;

        private Light(int luminance) {
            this.luminance = luminance;
        }
    }
}

