/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ai;

import com.Polarice3.Goety.api.entities.ICharger;
import com.Polarice3.Goety.utils.MathHelper;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ChargeGoal
extends Goal {
    public PathfinderMob charger;
    public LivingEntity chargeTarget;
    public Vec3 chargePos;
    protected final float speed;
    protected double minRange;
    protected double maxRange;
    protected int chance;
    public int windup;
    public int coolDown;
    public final int coolDownTotal;
    public boolean hasAttacked;

    public ChargeGoal(PathfinderMob mob, float speed, int coolDownTotal) {
        this(mob, speed, 10, coolDownTotal);
    }

    public ChargeGoal(PathfinderMob mob, float speed, int chance, int coolDownTotal) {
        this(mob, speed, 4.0, 8.0, chance, coolDownTotal);
    }

    public ChargeGoal(PathfinderMob mob, float speed, double minRange, double maxRange, int chance, int coolDownTotal) {
        this.charger = mob;
        this.speed = speed;
        this.chance = chance;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.windup = 0;
        this.coolDownTotal = coolDownTotal;
        this.hasAttacked = false;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.chargeTarget = this.charger.m_5448_();
        if (this.charger.f_19797_ < this.coolDown) {
            return false;
        }
        if (this.chargeTarget == null) {
            return false;
        }
        double distance = this.charger.m_20270_((Entity)this.chargeTarget);
        if (distance < this.minRange || distance > this.maxRange) {
            return false;
        }
        if (!this.charger.m_20096_()) {
            return false;
        }
        Vec3 chargePos = this.findChargePoint((Entity)this.charger, (Entity)this.chargeTarget);
        boolean canSeeTarget = this.charger.m_21574_().m_148306_((Entity)this.chargeTarget);
        if (!canSeeTarget) {
            return false;
        }
        this.chargePos = chargePos;
        return this.charger.m_217043_().m_188503_(this.chance + 1) == 0;
    }

    public void m_8056_() {
        this.windup = MathHelper.secondsToTicks(1) + this.charger.m_217043_().m_188503_(MathHelper.secondsToTicks(1));
        this.charger.m_6858_(true);
    }

    public boolean m_8045_() {
        return this.windup > 0 || !this.charger.m_21573_().m_26571_();
    }

    public void m_8037_() {
        this.charger.m_21563_().m_24950_(this.chargePos.m_7096_(), this.chargePos.m_7098_() - 1.0, this.chargePos.m_7094_(), 10.0f, (float)this.charger.m_8132_());
        if (this.windup > 0) {
            if (--this.windup == 0) {
                this.charger.m_21573_().m_26519_(this.chargePos.m_7096_(), this.chargePos.m_7098_(), this.chargePos.m_7094_(), (double)this.speed);
            } else {
                PathfinderMob pathfinderMob = this.charger;
                if (pathfinderMob instanceof ICharger) {
                    ICharger chargeMob = (ICharger)pathfinderMob;
                    chargeMob.setCharging(true);
                }
            }
        }
        if (this.charger.m_20275_(this.chargeTarget.m_20185_(), this.chargeTarget.m_20186_(), this.chargeTarget.m_20189_()) <= this.getAttackReachSqr(this.chargeTarget) && !this.hasAttacked) {
            this.hasAttacked = true;
            this.charger.m_7327_((Entity)this.chargeTarget);
        }
    }

    public void m_8041_() {
        this.windup = 0;
        this.chargeTarget = null;
        this.hasAttacked = false;
        this.charger.m_6858_(false);
        this.coolDown = this.charger.f_19797_ + this.coolDownTotal;
        PathfinderMob pathfinderMob = this.charger;
        if (pathfinderMob instanceof ICharger) {
            ICharger chargeMob = (ICharger)pathfinderMob;
            chargeMob.setCharging(false);
        }
    }

    public double getAttackReachSqr(LivingEntity target) {
        return this.charger.m_20205_() * 2.0f * this.charger.m_20205_() * 2.0f + target.m_20205_();
    }

    protected Vec3 findChargePoint(Entity attacker, Entity target) {
        double vecx = target.m_20185_() - attacker.m_20185_();
        double vecz = target.m_20189_() - attacker.m_20189_();
        float rangle = (float)Math.atan2(vecz, vecx);
        double distance = Mth.m_14116_((float)((float)(vecx * vecx + vecz * vecz)));
        double overshoot = 2.1;
        double dx = (double)Mth.m_14089_((float)rangle) * (distance + overshoot);
        double dz = (double)Mth.m_14031_((float)rangle) * (distance + overshoot);
        return new Vec3(attacker.m_20185_() + dx, target.m_20186_(), attacker.m_20189_() + dz);
    }
}

