/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ai;

import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.config.MobsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class IllagerChestGoal
extends MoveToBlockGoal {
    public final AbstractIllagerServant illager;
    public boolean hasOpenedChest = false;
    public final int searchRange;
    public Predicate<ItemStack> predicate = itemStack -> true;
    public Predicate<ItemStack> chestPredicate = itemStack -> false;

    public IllagerChestGoal(AbstractIllagerServant illager, int range) {
        super((PathfinderMob)illager, 0.75, range);
        this.illager = illager;
        this.searchRange = range;
    }

    public IllagerChestGoal(AbstractIllagerServant illager) {
        this(illager, (Integer)MobsConfig.IllagerServantChestRange.get());
    }

    public ItemStack getItem() {
        Optional optional = this.illager.itemsInInv(this.predicate).stream().findFirst();
        return optional.orElse(ItemStack.f_41583_);
    }

    public boolean m_8036_() {
        if (this.illager.isStaying()) {
            return false;
        }
        if (this.illager.m_5448_() != null) {
            return false;
        }
        if (this.illager.getMarked() != null) {
            return false;
        }
        if (this.illager.isRaiding()) {
            return false;
        }
        if (this.illager.isCelebrating()) {
            return false;
        }
        if (this.illager.itemsInInv(this.predicate).isEmpty()) {
            return false;
        }
        return this.m_25626_();
    }

    public boolean m_8045_() {
        return super.m_8045_() && this.m_8036_();
    }

    protected boolean baseNearestBlock() {
        return super.m_25626_();
    }

    protected boolean m_25626_() {
        if (this.illager.getChestPos() != null) {
            this.f_25602_ = this.illager.getChestPos();
            if (this.f_25602_ != null) {
                return this.illager.m_20275_((float)this.f_25602_.m_123341_() + 0.5f, (float)this.f_25602_.m_123342_() + 0.5f, (float)this.f_25602_.m_123343_() + 0.5f) <= (double)Mth.m_144944_((int)this.searchRange);
            }
        }
        return false;
    }

    public boolean isChestRaidable(LevelReader world, BlockPos pos) {
        Container container = this.getChest(world, pos);
        if (container != null) {
            return container.m_216874_(this.chestPredicate);
        }
        return false;
    }

    @Nullable
    public Container getChest(LevelReader world, BlockPos pos) {
        BlockEntity entity;
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof ChestBlock) {
            ChestBlock chestBlock = (ChestBlock)block;
            if (world instanceof Level) {
                Level level = (Level)world;
                return ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)blockState, (Level)level, (BlockPos)pos, (boolean)true);
            }
        }
        if (world.m_8055_(pos).m_60734_() instanceof BaseEntityBlock && (entity = world.m_7702_(pos)) instanceof Container) {
            Container inventory = (Container)entity;
            return inventory;
        }
        return null;
    }

    public List<ItemStack> getChestContent(LevelReader world, BlockPos pos) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Container container = this.getChest(world, pos);
        if (container != null) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack itemStack = container.m_8020_(i);
                list.add(itemStack);
            }
        }
        return list;
    }

    public boolean isFull(ItemStack addStack, LevelReader world, BlockPos pos) {
        Container chest = this.getChest(world, pos);
        if (chest == null) {
            return false;
        }
        List<ItemStack> list = this.getChestContent(world, pos);
        if (list.isEmpty()) {
            return false;
        }
        if (addStack == null || addStack.m_41619_()) {
            return false;
        }
        int i = 0;
        for (ItemStack containerStack : list) {
            if (containerStack.m_41619_()) {
                ++i;
                continue;
            }
            if (!ItemStack.m_41656_((ItemStack)containerStack, (ItemStack)addStack)) continue;
            int j = Math.min(addStack.m_41741_(), containerStack.m_41741_());
            int k = Math.min(addStack.m_41613_(), j - containerStack.m_41613_());
            if (k <= 0) continue;
            ++i;
        }
        return i == 0;
    }

    public boolean hasLineOfSightChest() {
        BlockHitResult hitResult = this.illager.f_19853_.m_45547_(new ClipContext(this.illager.m_20299_(1.0f), new Vec3((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_() + 0.5, (double)this.f_25602_.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.illager));
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = hitResult;
            BlockPos pos = blockHitResult.m_82425_();
            return pos.equals((Object)this.f_25602_) || this.illager.f_19853_.m_46859_(pos) || this.illager.f_19853_.m_7702_(pos) == this.illager.f_19853_.m_7702_(this.f_25602_);
        }
        return true;
    }

    public List<ItemStack> getItems(Container inventory) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!this.chestPredicate.test(stack)) continue;
            items.add(stack);
        }
        return items;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.f_25602_ == null) {
            this.m_8041_();
        } else {
            Container chest = this.getChest((LevelReader)this.illager.f_19853_, this.f_25602_);
            if (chest != null) {
                double distance = this.illager.m_20275_((float)this.f_25602_.m_123341_() + 0.5f, (float)this.f_25602_.m_123342_() + 0.5f, (float)this.f_25602_.m_123343_() + 0.5f);
                if (this.hasLineOfSightChest()) {
                    if (this.m_25625_() && distance <= 3.0) {
                        this.toggleChest(chest, false);
                        this.chestInteract(chest);
                        this.m_8041_();
                    } else if (distance < 5.0 && !this.hasOpenedChest) {
                        this.hasOpenedChest = true;
                        this.toggleChest(chest, true);
                    }
                }
            }
        }
    }

    public void chestInteract(Container container) {
    }

    public void m_8041_() {
        BlockEntity blockEntity;
        super.m_8041_();
        if (this.f_25602_ != null && (blockEntity = this.illager.f_19853_.m_7702_(this.f_25602_)) instanceof Container) {
            Container container = (Container)blockEntity;
            this.toggleChest(container, false);
        }
        this.f_25602_ = BlockPos.f_121853_;
        this.hasOpenedChest = false;
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return pos != null && this.isChestRaidable(worldIn, pos);
    }

    public void toggleChest(Container container, boolean open) {
        if (container instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)container;
            if (open) {
                this.illager.f_19853_.m_7696_(this.f_25602_, chest.m_58900_().m_60734_(), 1, 1);
            } else {
                this.illager.f_19853_.m_7696_(this.f_25602_, chest.m_58900_().m_60734_(), 1, 0);
            }
            this.illager.f_19853_.m_46672_(this.f_25602_, chest.m_58900_().m_60734_());
            this.illager.f_19853_.m_46672_(this.f_25602_.m_7495_(), chest.m_58900_().m_60734_());
        }
    }
}

