/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ai;

import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.config.MobsConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class MinionFollowGoal
extends Goal {
    private final Minion summonedEntity;
    private LivingEntity owner;
    private final LevelReader level;
    private final double followSpeed;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;

    public MinionFollowGoal(Minion summonedEntity, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.summonedEntity = summonedEntity;
        this.level = summonedEntity.f_19853_;
        this.followSpeed = speed;
        this.navigation = summonedEntity.m_21573_();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(summonedEntity.m_21573_() instanceof GroundPathNavigation) && !(summonedEntity.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.summonedEntity.getTrueOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (livingentity instanceof Mob) {
            return false;
        }
        if (this.summonedEntity.m_20280_((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        if (this.summonedEntity.m_5448_() != null) {
            return false;
        }
        if (this.summonedEntity.isCharging()) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.summonedEntity.m_5448_() != null) {
            return false;
        }
        if (this.summonedEntity.isCharging()) {
            return false;
        }
        if (this.navigation.m_26571_()) {
            return false;
        }
        return !(this.summonedEntity.m_20280_((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.summonedEntity.m_21439_(BlockPathTypes.WATER);
        this.summonedEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.navigation.m_26573_();
        this.summonedEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.summonedEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.summonedEntity.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if ((double)this.summonedEntity.m_20270_((Entity)this.owner) > 8.0) {
                double x = Mth.m_14107_((double)this.owner.m_20185_()) - 2;
                double y = Mth.m_14107_((double)this.owner.m_20191_().f_82289_);
                double z = Mth.m_14107_((double)this.owner.m_20189_()) - 2;
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.ValidPosition(BlockPos.m_274561_((double)(x + (double)l), (double)(y + 2.0), (double)(z + (double)i1)))) continue;
                        float a = (float)(x + (double)l + 0.5);
                        float b = (float)(z + (double)i1 + 0.5);
                        this.summonedEntity.m_21566_().m_6849_((double)a, y, (double)b, this.followSpeed);
                        this.navigation.m_26573_();
                    }
                }
            }
            if (this.summonedEntity.m_20280_((Entity)this.owner) > 144.0 && ((Boolean)MobsConfig.VexTeleport.get()).booleanValue()) {
                this.tryToTeleportNearEntity();
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.summonedEntity.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.summonedEntity.m_146908_(), this.summonedEntity.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.summonedEntity.m_20183_());
        return this.level.m_45756_((Entity)this.summonedEntity, this.summonedEntity.m_20191_().m_82338_(blockpos));
    }

    protected boolean ValidPosition(BlockPos pos) {
        BlockState blockstate = this.level.m_8055_(pos);
        return blockstate.m_60710_(this.level, pos) && this.level.m_46859_(pos.m_7494_()) && this.level.m_46859_(pos.m_6630_(2));
    }

    private int getRandomNumber(int min, int max) {
        return this.summonedEntity.m_217043_().m_188503_(max - min + 1) + min;
    }
}

