/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.SpellConfig;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class GuardianServant
extends Summoned {
    protected static final int ATTACK_TIME = 80;
    private static final EntityDataAccessor<Boolean> DATA_ID_MOVING = SynchedEntityData.m_135353_(GuardianServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(GuardianServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float clientSideTailAnimation;
    private float clientSideTailAnimationO;
    private float clientSideTailAnimationSpeed;
    private float clientSideSpikesAnimation;
    private float clientSideSpikesAnimationO;
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    public boolean playAttackSound;
    @Nullable
    protected RandomStrollGoal randomStrollGoal;

    public GuardianServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new GuardianMoveControl(this);
        this.clientSideTailAnimationO = this.clientSideTailAnimation = this.f_19796_.m_188501_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
        this.randomStrollGoal = new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this);
        this.f_21345_.m_25352_(4, (Goal)new GuardianAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)movetowardsrestrictiongoal);
        this.f_21345_.m_25352_(7, (Goal)this.randomStrollGoal);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Guardian.class, 12.0f, 0.01f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.randomStrollGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal(this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected PathNavigation m_6037_(Level p_32846_) {
        return new WaterBoundPathNavigation((Mob)this, p_32846_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_MOVING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return livingEntity -> livingEntity instanceof GuardianServant;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.GuardianLimit.get();
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    @Override
    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_MOVING);
    }

    void setMoving(boolean p_32862_) {
        this.f_19804_.m_135381_(DATA_ID_MOVING, (Object)p_32862_);
    }

    public int getAttackDuration() {
        return 80;
    }

    void setActiveAttackTarget(int p_32818_) {
        this.f_19804_.m_135381_(DATA_ID_ATTACK_TARGET, (Object)p_32818_);
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET) != 0;
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.clientSideCachedAttackTarget = livingEntity = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    public void m_7350_(EntityDataAccessor<?> p_32834_) {
        super.m_7350_(p_32834_);
        if (DATA_ID_ATTACK_TARGET.equals(p_32834_)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public int m_8100_() {
        return 160;
    }

    protected SoundEvent m_7515_() {
        return this.m_20072_() ? SoundEvents.f_11999_ : SoundEvents.f_12000_;
    }

    protected SoundEvent m_7975_(DamageSource p_32852_) {
        return this.m_20072_() ? SoundEvents.f_12005_ : SoundEvents.f_12006_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20072_() ? SoundEvents.f_12002_ : SoundEvents.f_12003_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected float m_6431_(Pose p_32843_, EntityDimensions p_32844_) {
        return p_32844_.f_20378_ * 0.5f;
    }

    public float m_5610_(BlockPos p_32831_, LevelReader p_32832_) {
        return p_32832_.m_6425_(p_32831_).m_205070_(FluidTags.f_13131_) ? 10.0f + p_32832_.m_220419_(p_32831_) : super.m_5610_(p_32831_, p_32832_);
    }

    @Override
    public void m_8107_() {
        if (this.m_6084_()) {
            if (this.f_19853_.f_46443_) {
                this.clientSideTailAnimationO = this.clientSideTailAnimation;
                if (!this.m_20069_()) {
                    this.clientSideTailAnimationSpeed = 2.0f;
                    Vec3 vec3 = this.m_20184_();
                    if (vec3.f_82480_ > 0.0 && this.clientSideTouchedGround && !this.m_20067_()) {
                        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlopSound(), this.m_5720_(), 1.0f, 1.0f, false);
                    }
                    this.clientSideTouchedGround = vec3.f_82480_ < 0.0 && this.f_19853_.m_46575_(this.m_20183_().m_7495_(), (Entity)this);
                } else {
                    this.clientSideTailAnimationSpeed = this.isMoving() ? (this.clientSideTailAnimationSpeed < 0.5f ? 4.0f : (this.clientSideTailAnimationSpeed += (0.5f - this.clientSideTailAnimationSpeed) * 0.1f)) : (this.clientSideTailAnimationSpeed += (0.125f - this.clientSideTailAnimationSpeed) * 0.2f);
                }
                this.clientSideTailAnimation += this.clientSideTailAnimationSpeed;
                this.clientSideSpikesAnimationO = this.clientSideSpikesAnimation;
                this.clientSideSpikesAnimation = !this.m_20072_() ? this.f_19796_.m_188501_() : (this.isMoving() ? (this.clientSideSpikesAnimation += (0.0f - this.clientSideSpikesAnimation) * 0.25f) : (this.clientSideSpikesAnimation += (1.0f - this.clientSideSpikesAnimation) * 0.06f));
                if (this.isMoving() && this.m_20069_()) {
                    Vec3 vec31 = this.m_20252_(0.0f);
                    for (int i = 0; i < 2; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5) - vec31.f_82479_ * 1.5, this.m_20187_() - vec31.f_82480_ * 1.5, this.m_20262_(0.5) - vec31.f_82481_ * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.hasActiveAttackTarget()) {
                    LivingEntity livingentity;
                    if (this.clientSideAttackTime < this.getAttackDuration()) {
                        ++this.clientSideAttackTime;
                    }
                    if ((livingentity = this.getActiveAttackTarget()) != null) {
                        this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                        this.m_21563_().m_8128_();
                        double d5 = this.getAttackAnimationScale(0.0f);
                        double d0 = livingentity.m_20185_() - this.m_20185_();
                        double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                        double d2 = livingentity.m_20189_() - this.m_20189_();
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.f_19796_.m_188500_();
                        while (d4 < d3) {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + d0 * (d4 += 1.8 - d5 + this.f_19796_.m_188500_() * (1.7 - d5)), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.m_20072_()) {
                this.m_20301_(300);
            } else if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.4f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.4f)));
                this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
                this.m_6853_(false);
                this.f_19812_ = true;
            }
            if (this.hasActiveAttackTarget()) {
                this.m_146922_(this.f_20885_);
            }
        }
        super.m_8107_();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public float getTailAnimation(float p_32864_) {
        return Mth.m_14179_((float)p_32864_, (float)this.clientSideTailAnimationO, (float)this.clientSideTailAnimation);
    }

    public float getSpikesAnimation(float p_32866_) {
        return Mth.m_14179_((float)p_32866_, (float)this.clientSideSpikesAnimationO, (float)this.clientSideSpikesAnimation);
    }

    public float getAttackAnimationScale(float p_32813_) {
        return ((float)this.clientSideAttackTime + p_32813_) / (float)this.getAttackDuration();
    }

    public float getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    public boolean m_6914_(LevelReader p_32829_) {
        return p_32829_.m_45784_((Entity)this);
    }

    @Override
    public boolean m_6469_(DamageSource p_32820_, float p_32821_) {
        Entity entity;
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (!this.isMoving() && !p_32820_.m_269533_(DamageTypeTags.f_268640_) && !p_32820_.m_276093_(DamageTypes.f_268440_) && (entity = p_32820_.m_7640_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            livingentity.m_6469_(this.m_269291_().m_269374_((Entity)this), 2.0f);
        }
        if (this.randomStrollGoal != null) {
            this.randomStrollGoal.m_25751_();
        }
        return super.m_6469_(p_32820_, p_32821_);
    }

    public int m_8132_() {
        return 180;
    }

    public void m_7023_(Vec3 p_32858_) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.1f, p_32858_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.isMoving() && this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_32858_);
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.playAttackSound = true;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        FoodProperties foodProperties;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_() && (foodProperties = itemstack.getFoodProperties((LivingEntity)this)) != null) {
            this.m_5634_(foodProperties.m_38744_());
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            this.m_5584_(this.f_19853_, itemstack);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            pPlayer.m_6674_(pHand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class GuardianMoveControl
    extends MoveControl {
        private final GuardianServant guardian;

        public GuardianMoveControl(GuardianServant p_32886_) {
            super((Mob)p_32886_);
            this.guardian = p_32886_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.guardian.m_21573_().m_26571_()) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.guardian.m_20185_(), this.f_24976_ - this.guardian.m_20186_(), this.f_24977_ - this.guardian.m_20189_());
                double d0 = vec3.m_82553_();
                double d1 = vec3.f_82479_ / d0;
                double d2 = vec3.f_82480_ / d0;
                double d3 = vec3.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.2957763671875) - 90.0f;
                this.guardian.m_146922_(this.m_24991_(this.guardian.m_146908_(), f, 90.0f));
                this.guardian.f_20883_ = this.guardian.m_146908_();
                float f1 = (float)(this.f_24978_ * this.guardian.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.guardian.m_6113_(), (float)f1);
                this.guardian.m_7910_(f2);
                double d4 = Math.sin((double)(this.guardian.f_19797_ + this.guardian.m_19879_()) * 0.5) * 0.05;
                double d5 = Math.cos(this.guardian.m_146908_() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.guardian.m_146908_() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.guardian.f_19797_ + this.guardian.m_19879_()) * 0.75) * 0.05;
                this.guardian.m_20256_(this.guardian.m_20184_().m_82520_(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookControl lookcontrol = this.guardian.m_21563_();
                double d8 = this.guardian.m_20185_() + d1 * 2.0;
                double d9 = this.guardian.m_20188_() + d2 / d0;
                double d10 = this.guardian.m_20189_() + d3 * 2.0;
                double d11 = lookcontrol.m_24969_();
                double d12 = lookcontrol.m_24970_();
                double d13 = lookcontrol.m_24971_();
                if (!lookcontrol.m_186069_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.guardian.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
                this.guardian.setMoving(true);
            } else {
                this.guardian.m_7910_(0.0f);
                this.guardian.setMoving(false);
            }
        }
    }

    static class GuardianAttackGoal
    extends Goal {
        private final GuardianServant guardian;
        private int attackTime;
        private final boolean elder;

        public GuardianAttackGoal(GuardianServant p_32871_) {
            this.guardian = p_32871_;
            this.elder = false;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.guardian.m_5448_();
            return livingentity != null && livingentity.m_6084_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && (this.elder || this.guardian.m_5448_() != null && this.guardian.m_20280_((Entity)this.guardian.m_5448_()) > 9.0);
        }

        public void m_8056_() {
            this.attackTime = -10;
            this.guardian.m_21573_().m_26573_();
            LivingEntity livingentity = this.guardian.m_5448_();
            if (livingentity != null) {
                this.guardian.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
            }
            this.guardian.f_19812_ = true;
        }

        public void m_8041_() {
            this.guardian.setActiveAttackTarget(0);
            this.guardian.m_6710_(null);
            this.guardian.randomStrollGoal.m_25751_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.guardian.m_5448_();
            if (livingentity != null) {
                this.guardian.m_21573_().m_26573_();
                this.guardian.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                if (!this.guardian.m_142582_((Entity)livingentity)) {
                    this.guardian.m_6710_(null);
                } else {
                    ++this.attackTime;
                    if (this.attackTime == 0) {
                        this.guardian.setActiveAttackTarget(livingentity.m_19879_());
                        if (!this.guardian.m_20067_() && !this.guardian.f_19853_.f_46443_) {
                            this.guardian.f_19853_.m_7605_((Entity)this.guardian, (byte)4);
                        }
                    } else if (this.attackTime >= this.guardian.getAttackDuration()) {
                        float f = 1.0f;
                        if (this.guardian.f_19853_.m_46791_() == Difficulty.HARD) {
                            f += 2.0f;
                        }
                        if (this.elder) {
                            f += 2.0f;
                        }
                        livingentity.m_6469_(this.guardian.m_269291_().m_269104_((Entity)this.guardian, (Entity)this.guardian), f);
                        livingentity.m_6469_(this.guardian.getServantAttack(), (float)this.guardian.m_21133_(Attributes.f_22281_));
                        this.guardian.m_6710_(null);
                    }
                    super.m_8037_();
                }
            }
        }
    }
}

