/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.ModRavager;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class ZombieRavager
extends ModRavager {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(ZombieRavager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int villagerConversionTime;
    @Nullable
    private UUID conversionStarter;

    public ZombieRavager(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RavagerDamage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22284_, (Double)AttributesConfig.RavagerArmor.get() + 2.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.RavagerArmor.get() + 2.0);
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RavagerDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_34397_) {
        super.m_7380_(p_34397_);
        p_34397_.m_128405_("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        if (this.conversionStarter != null) {
            p_34397_.m_128362_("ConversionPlayer", this.conversionStarter);
        }
    }

    @Override
    public void m_7378_(CompoundTag p_34387_) {
        super.m_7378_(p_34387_);
        if (p_34387_.m_128425_("ConversionTime", 99) && p_34387_.m_128451_("ConversionTime") > -1) {
            this.startConverting(p_34387_.m_128403_("ConversionPlayer") ? p_34387_.m_128342_("ConversionPlayer") : null, p_34387_.m_128451_("ConversionTime"));
        }
    }

    @Override
    public double regularSpeed() {
        return 0.23;
    }

    @Override
    public double aggressiveSpeed() {
        return 0.28;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    protected boolean isSunSensitive() {
        return this.getArmor().m_41619_();
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_33359_) {
        return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound() {
        if (this.hasSaddle()) {
            return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_STEP.get();
        }
        return SoundEvents.f_12284_;
    }

    @Override
    protected SoundEvent getAttackSound() {
        return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_BITE.get();
    }

    @Override
    protected SoundEvent getStunnedSound() {
        return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_STUN.get();
    }

    @Override
    protected SoundEvent getRoarSound() {
        return (SoundEvent)ModSounds.ZOMBIE_RAVAGER_ROAR.get();
    }

    @Override
    public void convertNewEquipment(Entity entity) {
        if (!this.f_19853_.f_46443_) {
            if (entity instanceof Ravager) {
                this.equipSaddle(false);
                this.m_21153_(((Ravager)entity).m_21223_());
                this.updateArmor();
            } else if (entity instanceof ModRavager) {
                ModRavager modRavager = (ModRavager)entity;
                if (modRavager.hasSaddle()) {
                    this.equipSaddle(false);
                }
                this.m_21153_(modRavager.m_21223_());
                this.updateArmor();
            }
        }
    }

    @Override
    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.isConverting()) {
            int i = this.getConversionProgress();
            this.villagerConversionTime -= i;
            if (this.villagerConversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                this.villagerConversionTime = timer;
            })) {
                this.finishConversion((ServerLevel)this.f_19853_);
            }
        }
        super.m_8119_();
    }

    @Override
    public InteractionResult m_6071_(Player p_34394_, InteractionHand p_34395_) {
        ItemStack itemstack = p_34394_.m_21120_(p_34395_);
        if (itemstack.m_150930_(Items.f_42436_)) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!p_34394_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    this.startConverting(p_34394_.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(p_34394_, p_34395_);
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID p_34384_, int p_34385_) {
        this.conversionStarter = p_34384_;
        this.villagerConversionTime = p_34385_;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, p_34385_, Math.min(this.f_19853_.m_46791_().m_19028_() - 1, 0)));
        this.f_19853_.m_7605_((Entity)this, (byte)16);
    }

    @Override
    public void m_7822_(byte p_34372_) {
        if (p_34372_ == 16) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(p_34372_);
        }
    }

    private void finishConversion(ServerLevel p_34399_) {
        ModRavager modRavager = (ModRavager)this.m_21406_((EntityType)ModEntityType.MOD_RAVAGER.get(), false);
        if (modRavager != null) {
            Player player;
            if (this.conversionStarter != null && (player = p_34399_.m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
                modRavager.setTrueOwner((LivingEntity)player);
            }
            modRavager.m_6518_((ServerLevelAccessor)p_34399_, p_34399_.m_6436_(modRavager.m_20183_()), MobSpawnType.CONVERSION, null, null);
            if (this.hasSaddle()) {
                modRavager.equipSaddle(false);
            }
            modRavager.m_21153_(this.m_21223_());
            modRavager.updateArmor();
            modRavager.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            if (!this.m_20067_()) {
                p_34399_.m_5898_((Player)null, 1027, this.m_20183_(), 0);
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)modRavager);
        }
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k, l, i1));
                        if (!blockstate.m_60713_(Blocks.f_50183_) && !(blockstate.m_60734_() instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }
}

