/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.illagers.HostileGolem;
import com.Polarice3.Goety.common.entities.projectiles.ScatterMine;
import com.Polarice3.Goety.common.entities.util.CameraShake;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class HostileRedstoneGolem
extends HostileGolem {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(HostileRedstoneGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(HostileRedstoneGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String SUMMON = "summon";
    public static String NOVELTY = "novelty";
    public static String DEATH = "death";
    public static float SUMMON_SECONDS_TIME = 5.15f;
    private int activateTick;
    private int idleTime;
    public int summonTick;
    private int summonCool;
    private int mineCount;
    public int attackTick;
    public int postAttackTick;
    public float getGlow;
    public float glowAmount = 0.03f;
    public int noveltyTick;
    public int deathTime = 0;
    public float deathRotation = 0.0f;
    public boolean isNovelty = false;
    public boolean isPostAttack = false;
    public boolean isFlash = false;
    private final ModServerBossInfo bossInfo;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState noveltyAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public HostileRedstoneGolem(EntityType<? extends HostileGolem> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
        this.bossInfo = new ModServerBossInfo((Mob)this, BossEvent.BossBarColor.RED, false, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21342_ = new MobUtil.noSpinControl((Mob)this);
        this.f_21364_ = 99;
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new SummonMinesGoal());
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.RedstoneGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.RedstoneGolemArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RedstoneGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.RedstoneGolemFollowRange.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.RedstoneGolemHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.RedstoneGolemArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RedstoneGolemDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.RedstoneGolemFollowRange.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntityType.REDSTONE_GOLEM.get()).m_20676_();
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "attack")) {
            return 2;
        }
        if (Objects.equals(animation, "summon")) {
            return 3;
        }
        if (Objects.equals(animation, "novelty")) {
            return 4;
        }
        if (Objects.equals(animation, "death")) {
            return 5;
        }
        return 0;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 3: {
                    this.summonAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.summonAnimationState);
                    break;
                }
                case 4: {
                    this.noveltyAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.noveltyAnimationState);
                    break;
                }
                case 5: {
                    this.deathAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.deathAnimationState);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ActivateTick", this.activateTick);
        pCompound.m_128405_("SummonTick", this.summonTick);
        pCompound.m_128405_("CoolDown", this.summonCool);
        pCompound.m_128405_("MineCount", this.mineCount);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ActivateTick")) {
            this.activateTick = pCompound.m_128451_("ActivateTick");
        }
        if (pCompound.m_128441_("SummonTick")) {
            this.summonTick = pCompound.m_128451_("SummonTick");
        }
        if (pCompound.m_128441_("CoolDown")) {
            this.summonCool = pCompound.m_128451_("CoolDown");
        }
        if (pCompound.m_128441_("MineCount")) {
            this.mineCount = pCompound.m_128451_("MineCount");
        }
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    @Override
    public boolean canAnimateMove() {
        return super.canAnimateMove() && this.getCurrentAnimation() == this.getAnimationState(IDLE);
    }

    public boolean m_7307_(Entity pEntity) {
        return MobUtil.illagerAllies((Entity)this, pEntity);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_8321_((Boolean)MainConfig.SpecialBossBar.get());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_STEP.get());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get();
    }

    private boolean getGolemFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setGolemFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getGolemFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setGolemFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSummoning();
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.summonTick <= 0 && super.m_142582_(p_149755_);
    }

    public boolean isSummoning() {
        return this.summonTick > 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.noveltyAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= 30) {
            this.m_21373_();
            ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.REDSTONE_GOLEM_SKULL_ITEM.get());
            if (this.f_19853_.f_46441_.m_188501_() <= 0.11f) {
                this.m_19983_(itemStack);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_20916_ = 1;
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    public void m_6667_(DamageSource p_21014_) {
        this.setAnimationState(DEATH);
        this.deathRotation = this.m_146908_();
        super.m_6667_(p_21014_);
    }

    public void stopMostAnimations(AnimationState animationState0) {
        for (AnimationState animationState : this.getAnimations()) {
            if (animationState == animationState0) continue;
            animationState.m_216973_();
        }
    }

    public void stopAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_21224_()) {
            this.stopMostAnimations(this.deathAnimationState);
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        if (this.f_19853_.m_5776_() && this.m_6084_()) {
            if (!this.isSummoning()) {
                this.glow();
            }
            if (this.summonTick > 0) {
                this.isFlash = this.summonTick < 60 && this.summonTick > 55 || this.summonTick < 52 && this.summonTick > 47 || this.summonTick < 45 && this.summonTick > 40 || this.summonTick < 38 && this.summonTick > 20;
                --this.summonTick;
            } else {
                this.isFlash = false;
            }
        }
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            if (!(this.isMeleeAttacking() || this.isSummoning() || this.isPostAttack || this.isNovelty)) {
                this.setAnimationState(IDLE);
            }
            if (this.m_6084_()) {
                if (this.isNovelty) {
                    this.f_20899_ = false;
                    this.f_20900_ = 0.0f;
                    this.f_20902_ = 0.0f;
                    ++this.noveltyTick;
                    if (this.noveltyTick == 8 || this.noveltyTick == 13 || this.noveltyTick == 18 || this.noveltyTick == 23 || this.noveltyTick == 28 || this.noveltyTick == 33) {
                        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_CHEST.get());
                    }
                    if (this.noveltyTick == 42) {
                        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_GROWL.get());
                        this.m_146852_(GameEvent.f_223709_, (Entity)this);
                    }
                    if (this.noveltyTick >= 92 || this.m_5448_() != null || this.f_20916_ > 0) {
                        this.isNovelty = false;
                    }
                } else {
                    this.noveltyTick = 0;
                }
                if (!(this.isMeleeAttacking() || this.isSummoning() || this.isMoving())) {
                    ++this.idleTime;
                    if (this.f_19853_.f_46441_.m_188501_() <= 0.05f && this.f_20916_ <= 0 && (this.m_5448_() == null || this.m_5448_().m_21224_()) && !this.isNovelty && this.idleTime >= MathHelper.minutesToTicks(1)) {
                        this.idleTime = 0;
                        this.isNovelty = true;
                        this.setAnimationState(NOVELTY);
                    }
                } else {
                    this.idleTime = 0;
                    this.isNovelty = false;
                }
                if (this.summonTick > 0) {
                    --this.summonTick;
                }
                if (this.summonCool > 0) {
                    --this.summonCool;
                }
                if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                }
                if (this.isPostAttack) {
                    ++this.postAttackTick;
                }
                if (this.postAttackTick >= 15) {
                    if (!this.isSummoning()) {
                        this.setAnimationState(IDLE);
                    }
                    this.postAttackTick = 0;
                    this.isPostAttack = false;
                }
                if (this.isSummoning()) {
                    int time;
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 5; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_ELECTRIC.get()), this.m_20208_(0.5), this.m_20188_() - (double)serverLevel.f_46441_.m_188503_(5), this.m_20262_(0.5), 0, d0, d1, d2, 0.5);
                        }
                    }
                    if (this.summonTick == MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f)) {
                        CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 10.0f, 0.1f, 0, 20);
                    }
                    if (this.summonTick <= MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) && this.mineCount > 0 && this.f_19797_ % (time = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) / 14) == 0 && this.m_20096_()) {
                        BlockPos blockPos = this.m_20183_();
                        blockPos = blockPos.m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                        BlockPos blockPos2 = this.m_20183_().m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                        Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
                        Vec3 vec32 = Vec3.m_82539_((Vec3i)blockPos2);
                        ScatterMine scatterMine = new ScatterMine(this.f_19853_, (LivingEntity)this, vec3);
                        if (!this.f_19853_.m_45976_(ScatterMine.class, new AABB(blockPos)).isEmpty()) {
                            scatterMine.m_6034_(vec32.m_7096_(), vec32.m_7098_(), vec32.m_7094_());
                        }
                        if (this.f_19853_.m_7967_((Entity)scatterMine)) {
                            if (this.f_19853_.f_46441_.m_188499_()) {
                                SoundUtil.playRedstoneMineLoad(scatterMine);
                            }
                            --this.mineCount;
                        }
                    }
                }
            }
        }
    }

    private void glow() {
        this.getGlow = Mth.m_14036_((float)(this.getGlow + this.glowAmount), (float)0.0f, (float)1.0f);
        if (this.getGlow == 0.0f || this.getGlow == 1.0f) {
            this.glowAmount *= -1.0f;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_SUMMON.get());
            this.summonTick = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME) + 5;
            this.getGlow = 1.0f;
        } else if (pId == 5) {
            this.attackTick = 0;
        } else if (pId == 6) {
            this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get());
        } else if (pId == 7) {
            this.deathRotation = this.m_146908_();
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get(), 1.0f, 1.0f);
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return (double)(this.m_20205_() * 6.0f + enemy.m_20205_()) + 1.0;
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_PRE_ATTACK.get(), 1.5f, 1.0f);
            this.setMeleeAttacking(true);
        }
        return true;
    }

    public void m_6710_(@Nullable LivingEntity p_21544_) {
        if (!(p_21544_ instanceof Player) && p_21544_ != null && this.m_5448_() != p_21544_ && this.summonCool <= 0) {
            this.summonCool = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
        }
        super.m_6710_(p_21544_);
    }

    public class SummonMinesGoal
    extends Goal {
        public boolean m_8036_() {
            LivingEntity livingentity = HostileRedstoneGolem.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = HostileRedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                return HostileRedstoneGolem.this.summonCool <= 0 && HostileRedstoneGolem.this.m_20096_() && HostileRedstoneGolem.this.targetClose(livingentity, d0);
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            HostileRedstoneGolem.this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_SUMMON.get(), HostileRedstoneGolem.this.m_6121_(), HostileRedstoneGolem.this.m_6100_());
            HostileRedstoneGolem.this.setAnimationState(SUMMON);
            HostileRedstoneGolem.this.summonTick = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
            HostileRedstoneGolem.this.summonCool = MathHelper.secondsToTicks(10.0f + SUMMON_SECONDS_TIME);
            HostileRedstoneGolem.this.mineCount = 14;
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return HostileRedstoneGolem.this.m_5448_() != null && HostileRedstoneGolem.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return HostileRedstoneGolem.this.attackTick < 5;
        }

        public void m_8056_() {
            HostileRedstoneGolem.this.setMeleeAttacking(true);
        }

        public void m_8041_() {
            HostileRedstoneGolem.this.setMeleeAttacking(false);
            HostileRedstoneGolem.this.isPostAttack = true;
        }

        public void m_8037_() {
            if (HostileRedstoneGolem.this.m_5448_() != null && HostileRedstoneGolem.this.m_5448_().m_6084_()) {
                LivingEntity livingentity = HostileRedstoneGolem.this.m_5448_();
                double d0 = HostileRedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                HostileRedstoneGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)HostileRedstoneGolem.this.m_8085_(), (float)HostileRedstoneGolem.this.m_8132_());
                if (HostileRedstoneGolem.this.targetClose(livingentity, d0)) {
                    HostileRedstoneGolem.this.m_5618_(HostileRedstoneGolem.this.m_6080_());
                    if (HostileRedstoneGolem.this.attackTick == 1) {
                        HostileRedstoneGolem.this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get());
                        HostileRedstoneGolem.this.setAnimationState(ATTACK);
                    }
                    if (HostileRedstoneGolem.this.attackTick == 3 && HostileRedstoneGolem.this.targetClose(livingentity, d0)) {
                        this.hurtTarget((Entity)livingentity);
                        this.massiveSweep((LivingEntity)HostileRedstoneGolem.this, livingentity, 3.0, 100.0);
                    }
                }
            }
        }

        public void hurtTarget(Entity target) {
            float f = (float)HostileRedstoneGolem.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)HostileRedstoneGolem.this.m_21133_(Attributes.f_22282_);
            boolean flag = target.m_6469_(HostileRedstoneGolem.this.m_269291_().m_269333_((LivingEntity)HostileRedstoneGolem.this), f);
            if (flag) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (livingEntity.m_20191_().m_82309_() > HostileRedstoneGolem.this.m_20191_().m_82309_()) {
                        livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        MobUtil.forcefulKnockBack(livingEntity, f1 * 0.5f, Mth.m_14031_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), 0.5);
                    }
                    HostileRedstoneGolem.this.m_20256_(HostileRedstoneGolem.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                HostileRedstoneGolem.this.m_19970_((LivingEntity)HostileRedstoneGolem.this, target);
                HostileRedstoneGolem.this.m_21335_(target);
            }
        }

        public void massiveSweep(LivingEntity source, LivingEntity exempt, double range, double arc) {
            List<LivingEntity> hits = MobUtil.getAttackableLivingEntitiesNearby(source, range, 1.0, range, range);
            for (LivingEntity target : hits) {
                float targetAngle = (float)((Math.atan2(target.m_20189_() - source.m_20189_(), target.m_20185_() - source.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float attackAngle = source.f_20883_ % 360.0f;
                if (targetAngle < 0.0f) {
                    targetAngle += 360.0f;
                }
                if (attackAngle < 0.0f) {
                    attackAngle += 360.0f;
                }
                float relativeAngle = targetAngle - attackAngle;
                float hitDistance = (float)Math.sqrt((target.m_20189_() - source.m_20189_()) * (target.m_20189_() - source.m_20189_()) + (target.m_20185_() - source.m_20185_()) * (target.m_20185_() - source.m_20185_())) - target.m_20205_() / 2.0f;
                if (target == exempt || !((double)hitDistance <= range && (double)relativeAngle <= arc / 2.0 && (double)relativeAngle >= -arc / 2.0 || (double)relativeAngle >= 360.0 - arc / 2.0) && !((double)relativeAngle <= -360.0 + arc / 2.0)) continue;
                this.hurtTarget((Entity)target);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)HostileRedstoneGolem.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return HostileRedstoneGolem.this.m_5448_() != null && HostileRedstoneGolem.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            HostileRedstoneGolem.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            HostileRedstoneGolem.this.m_21573_().m_26573_();
            if (HostileRedstoneGolem.this.m_5448_() == null) {
                HostileRedstoneGolem.this.m_21561_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = HostileRedstoneGolem.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            HostileRedstoneGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)HostileRedstoneGolem.this.m_8085_(), (float)HostileRedstoneGolem.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                HostileRedstoneGolem.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, HostileRedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (HostileRedstoneGolem.this.targetClose(enemy, distToEnemySqr) && !HostileRedstoneGolem.this.isPostAttack) {
                HostileRedstoneGolem.this.m_7327_((Entity)enemy);
            }
        }
    }
}

