/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.CarrionMaggot;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CarrionFly
extends Summoned {
    public CarrionFly(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_20242_(true);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<CarrionFly>(this, 1.0, 10, 0.0f));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(8, new Summoned.FollowOwnerGoal<CarrionFly>(this, 1.0, 20.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22281_, 3.0);
    }

    public float m_5610_(@NotNull BlockPos p_27788_, LevelReader p_27789_) {
        return p_27789_.m_8055_(p_27788_).m_60795_() ? 10.0f : 0.0f;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, @NotNull DamageSource damageSource) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_32615_) {
        return (SoundEvent)ModSounds.FLY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.FLY_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.SPAWN_EGG) {
            this.setHostile(true);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_20068_() {
        return true;
    }

    private void jumpInLiquidInternal() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public void jumpInFluid(@NotNull FluidType type) {
        this.jumpInLiquidInternal();
    }

    @Override
    public void m_8119_() {
        Mob mobOwner;
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.f_19853_.m_46791_() == Difficulty.HARD && this.m_5448_() != null && this.m_5448_().m_6084_()) {
            this.f_19794_ = true;
        }
        if (!this.f_19853_.f_46443_ && this.getTrueOwner() != null && (livingEntity = this.getTrueOwner()) instanceof Mob && ((mobOwner = (Mob)livingEntity).m_213877_() || mobOwner.m_21224_())) {
            this.lifeSpanDamage();
        }
    }

    @Override
    public void lifeSpanDamage() {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(10) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_146870_();
    }

    public void m_5618_(float p_32621_) {
        this.m_146922_(p_32621_);
        super.m_5618_(p_32621_);
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        super.setUpgraded(upgraded);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (health != null && attack != null) {
            if (upgraded) {
                health.m_22100_(10.64);
                attack.m_22100_(2.2);
            } else {
                health.m_22100_(8.0);
                attack.m_22100_(2.0);
            }
        }
    }

    @Override
    public void uncreditedKill(LivingEntity target) {
        if (!MobUtil.areAllies((Entity)this, (Entity)target)) {
            int random = this.m_217043_().m_216332_(1, 3);
            for (int i = 0; i < random; ++i) {
                CarrionMaggot carrionMaggot = new CarrionMaggot((EntityType<? extends CarrionMaggot>)((EntityType)ModEntityType.CARRION_MAGGOT.get()), this.f_19853_);
                carrionMaggot.setTrueOwner((LivingEntity)(this.getTrueOwner() != null ? this.getTrueOwner() : this));
                BlockPos blockPos = BlockFinder.SummonRadius(target.m_20183_(), (Entity)carrionMaggot, this.f_19853_, 3);
                carrionMaggot.m_20219_(blockPos.m_252807_());
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    carrionMaggot.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(carrionMaggot.m_20183_()), MobSpawnType.BREEDING, null, null);
                }
                carrionMaggot.setNatural(this.isNatural());
                carrionMaggot.setHostile(this.isHostile());
                carrionMaggot.setUpgraded(this.isUpgraded());
                this.f_19853_.m_7967_((Entity)carrionMaggot);
            }
        }
    }
}

